import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoggingBillingAccountExclusionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html#billing_account LoggingBillingAccountExclusion#billing_account}.
     */
    readonly billingAccount: string;
    /**
     * A human-readable description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html#description LoggingBillingAccountExclusion#description}
     */
    readonly description?: string;
    /**
     * Whether this exclusion rule should be disabled or not. This defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html#disabled LoggingBillingAccountExclusion#disabled}
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * The filter to apply when excluding logs. Only log entries that match the filter are excluded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html#filter LoggingBillingAccountExclusion#filter}
     */
    readonly filter: string;
    /**
     * The name of the logging exclusion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html#name LoggingBillingAccountExclusion#name}
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html google_logging_billing_account_exclusion}.
 */
export declare class LoggingBillingAccountExclusion extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html google_logging_billing_account_exclusion} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: LoggingBillingAccountExclusionConfig);
    private _billingAccount?;
    get billingAccount(): string;
    set billingAccount(value: string);
    get billingAccountInput(): string | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable | undefined;
    set disabled(value: boolean | cdktf.IResolvable | undefined);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
