import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmsSecretCiphertextConfig extends cdktf.TerraformMetaArguments {
    /**
     * The additional authenticated data used for integrity checks during encryption and decryption.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html#additional_authenticated_data KmsSecretCiphertext#additional_authenticated_data}
     */
    readonly additionalAuthenticatedData?: string;
    /**
     * The full name of the CryptoKey that will be used to encrypt the provided plaintext. Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}/cryptoKeys/{{cryptoKey}}''.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html#crypto_key KmsSecretCiphertext#crypto_key}
     */
    readonly cryptoKey: string;
    /**
     * The plaintext to be encrypted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html#plaintext KmsSecretCiphertext#plaintext}
     */
    readonly plaintext: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html#timeouts KmsSecretCiphertext#timeouts}
     */
    readonly timeouts?: KmsSecretCiphertextTimeouts;
}
export interface KmsSecretCiphertextTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html#create KmsSecretCiphertext#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html#delete KmsSecretCiphertext#delete}.
     */
    readonly delete?: string;
}
export declare class KmsSecretCiphertextTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html google_kms_secret_ciphertext}.
 */
export declare class KmsSecretCiphertext extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_secret_ciphertext.html google_kms_secret_ciphertext} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: KmsSecretCiphertextConfig);
    private _additionalAuthenticatedData?;
    get additionalAuthenticatedData(): string | undefined;
    set additionalAuthenticatedData(value: string | undefined);
    resetAdditionalAuthenticatedData(): void;
    get additionalAuthenticatedDataInput(): string | undefined;
    get ciphertext(): string;
    private _cryptoKey?;
    get cryptoKey(): string;
    set cryptoKey(value: string);
    get cryptoKeyInput(): string | undefined;
    get id(): string;
    private _plaintext?;
    get plaintext(): string;
    set plaintext(value: string);
    get plaintextInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): KmsSecretCiphertextTimeoutsOutputReference;
    putTimeouts(value: KmsSecretCiphertextTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): KmsSecretCiphertextTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
