import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmsCryptoKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The period of time that versions of this key spend in the DESTROY_SCHEDULED state before transitioning to DESTROYED.
     *
     * If not specified at creation time, the default duration is 24 hours.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#destroy_scheduled_duration KmsCryptoKey#destroy_scheduled_duration}
     */
    readonly destroyScheduledDuration?: string;
    /**
     * Whether this key may contain imported versions only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#import_only KmsCryptoKey#import_only}
     */
    readonly importOnly?: boolean | cdktf.IResolvable;
    /**
     * The KeyRing that this key belongs to. Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}''.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#key_ring KmsCryptoKey#key_ring}
     */
    readonly keyRing: string;
    /**
     * Labels with user-defined metadata to apply to this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#labels KmsCryptoKey#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The resource name for the CryptoKey.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#name KmsCryptoKey#name}
     */
    readonly name: string;
    /**
     * The immutable purpose of this CryptoKey. See the [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose) for possible inputs. Default value: "ENCRYPT_DECRYPT" Possible values: ["ENCRYPT_DECRYPT", "ASYMMETRIC_SIGN", "ASYMMETRIC_DECRYPT"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#purpose KmsCryptoKey#purpose}
     */
    readonly purpose?: string;
    /**
     * Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
     *
     * The first rotation will take place after the specified period. The rotation period has
     * the format of a decimal number with up to 9 fractional digits, followed by the
     * letter 's' (seconds). It must be greater than a day (ie, 86400).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#rotation_period KmsCryptoKey#rotation_period}
     */
    readonly rotationPeriod?: string;
    /**
     * If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
     *
     * You must use the 'google_kms_key_ring_import_job' resource to import the CryptoKeyVersion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#skip_initial_version_creation KmsCryptoKey#skip_initial_version_creation}
     */
    readonly skipInitialVersionCreation?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#timeouts KmsCryptoKey#timeouts}
     */
    readonly timeouts?: KmsCryptoKeyTimeouts;
    /**
     * version_template block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#version_template KmsCryptoKey#version_template}
     */
    readonly versionTemplate?: KmsCryptoKeyVersionTemplate;
}
export interface KmsCryptoKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#create KmsCryptoKey#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#delete KmsCryptoKey#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#update KmsCryptoKey#update}.
     */
    readonly update?: string;
}
export declare class KmsCryptoKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface KmsCryptoKeyVersionTemplate {
    /**
     * The algorithm to use when creating a version based on this template. See the [algorithm reference](https://cloud.google.com/kms/docs/reference/rest/v1/CryptoKeyVersionAlgorithm) for possible inputs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#algorithm KmsCryptoKey#algorithm}
     */
    readonly algorithm: string;
    /**
     * The protection level to use when creating a version based on this template.
     *
     * Default value: "SOFTWARE" Possible values: ["SOFTWARE", "HSM"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#protection_level KmsCryptoKey#protection_level}
     */
    readonly protectionLevel?: string;
}
export declare class KmsCryptoKeyVersionTemplateOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    get algorithmInput(): string | undefined;
    private _protectionLevel?;
    get protectionLevel(): string | undefined;
    set protectionLevel(value: string | undefined);
    resetProtectionLevel(): void;
    get protectionLevelInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html google_kms_crypto_key}.
 */
export declare class KmsCryptoKey extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html google_kms_crypto_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: KmsCryptoKeyConfig);
    private _destroyScheduledDuration?;
    get destroyScheduledDuration(): string | undefined;
    set destroyScheduledDuration(value: string | undefined);
    resetDestroyScheduledDuration(): void;
    get destroyScheduledDurationInput(): string | undefined;
    get id(): string;
    private _importOnly?;
    get importOnly(): boolean | cdktf.IResolvable | undefined;
    set importOnly(value: boolean | cdktf.IResolvable | undefined);
    resetImportOnly(): void;
    get importOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyRing?;
    get keyRing(): string;
    set keyRing(value: string);
    get keyRingInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _purpose?;
    get purpose(): string | undefined;
    set purpose(value: string | undefined);
    resetPurpose(): void;
    get purposeInput(): string | undefined;
    private _rotationPeriod?;
    get rotationPeriod(): string | undefined;
    set rotationPeriod(value: string | undefined);
    resetRotationPeriod(): void;
    get rotationPeriodInput(): string | undefined;
    get selfLink(): string;
    private _skipInitialVersionCreation?;
    get skipInitialVersionCreation(): boolean | cdktf.IResolvable | undefined;
    set skipInitialVersionCreation(value: boolean | cdktf.IResolvable | undefined);
    resetSkipInitialVersionCreation(): void;
    get skipInitialVersionCreationInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): KmsCryptoKeyTimeoutsOutputReference;
    putTimeouts(value: KmsCryptoKeyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): KmsCryptoKeyTimeouts | undefined;
    private _versionTemplate?;
    private __versionTemplateOutput;
    get versionTemplate(): KmsCryptoKeyVersionTemplateOutputReference;
    putVersionTemplate(value: KmsCryptoKeyVersionTemplate | undefined): void;
    resetVersionTemplate(): void;
    get versionTemplateInput(): KmsCryptoKeyVersionTemplate | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
