import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityPlatformTenantConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether to allow email/password user authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#allow_password_signup IdentityPlatformTenant#allow_password_signup}
     */
    readonly allowPasswordSignup?: boolean | cdktf.IResolvable;
    /**
     * Whether authentication is disabled for the tenant.
     *
     * If true, the users under
     * the disabled tenant are not allowed to sign-in. Admins of the disabled tenant
     * are not able to manage its users.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#disable_auth IdentityPlatformTenant#disable_auth}
     */
    readonly disableAuth?: boolean | cdktf.IResolvable;
    /**
     * Human friendly display name of the tenant.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#display_name IdentityPlatformTenant#display_name}
     */
    readonly displayName: string;
    /**
     * Whether to enable email link user authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#enable_email_link_signin IdentityPlatformTenant#enable_email_link_signin}
     */
    readonly enableEmailLinkSignin?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#project IdentityPlatformTenant#project}.
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#timeouts IdentityPlatformTenant#timeouts}
     */
    readonly timeouts?: IdentityPlatformTenantTimeouts;
}
export interface IdentityPlatformTenantTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#create IdentityPlatformTenant#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#delete IdentityPlatformTenant#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html#update IdentityPlatformTenant#update}.
     */
    readonly update?: string;
}
export declare class IdentityPlatformTenantTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html google_identity_platform_tenant}.
 */
export declare class IdentityPlatformTenant extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant.html google_identity_platform_tenant} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: IdentityPlatformTenantConfig);
    private _allowPasswordSignup?;
    get allowPasswordSignup(): boolean | cdktf.IResolvable | undefined;
    set allowPasswordSignup(value: boolean | cdktf.IResolvable | undefined);
    resetAllowPasswordSignup(): void;
    get allowPasswordSignupInput(): boolean | cdktf.IResolvable | undefined;
    private _disableAuth?;
    get disableAuth(): boolean | cdktf.IResolvable | undefined;
    set disableAuth(value: boolean | cdktf.IResolvable | undefined);
    resetDisableAuth(): void;
    get disableAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enableEmailLinkSignin?;
    get enableEmailLinkSignin(): boolean | cdktf.IResolvable | undefined;
    set enableEmailLinkSignin(value: boolean | cdktf.IResolvable | undefined);
    resetEnableEmailLinkSignin(): void;
    get enableEmailLinkSigninInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): IdentityPlatformTenantTimeoutsOutputReference;
    putTimeouts(value: IdentityPlatformTenantTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): IdentityPlatformTenantTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
