import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityPlatformTenantOauthIdpConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * The client id of an OAuth client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html#client_id IdentityPlatformTenantOauthIdpConfig#client_id}
     */
    readonly clientId: string;
    /**
     * The client secret of the OAuth client, to enable OIDC code flow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html#client_secret IdentityPlatformTenantOauthIdpConfig#client_secret}
     */
    readonly clientSecret?: string;
    /**
     * Human friendly display name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html#display_name IdentityPlatformTenantOauthIdpConfig#display_name}
     */
    readonly displayName: string;
    /**
     * If this config allows users to sign in with the provider.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html#enabled IdentityPlatformTenantOauthIdpConfig#enabled}
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * For OIDC Idps, the issuer identifier.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html#issuer IdentityPlatformTenantOauthIdpConfig#issuer}
     */
    readonly issuer: string;
    /**
     * The name of the OauthIdpConfig. Must start with 'oidc.'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html#name IdentityPlatformTenantOauthIdpConfig#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html#project IdentityPlatformTenantOauthIdpConfig#project}.
     */
    readonly project?: string;
    /**
     * The name of the tenant where this OIDC IDP configuration resource exists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html#tenant IdentityPlatformTenantOauthIdpConfig#tenant}
     */
    readonly tenant: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html#timeouts IdentityPlatformTenantOauthIdpConfig#timeouts}
     */
    readonly timeouts?: IdentityPlatformTenantOauthIdpConfigTimeouts;
}
export interface IdentityPlatformTenantOauthIdpConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html#create IdentityPlatformTenantOauthIdpConfig#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html#delete IdentityPlatformTenantOauthIdpConfig#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html#update IdentityPlatformTenantOauthIdpConfig#update}.
     */
    readonly update?: string;
}
export declare class IdentityPlatformTenantOauthIdpConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html google_identity_platform_tenant_oauth_idp_config}.
 */
export declare class IdentityPlatformTenantOauthIdpConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_oauth_idp_config.html google_identity_platform_tenant_oauth_idp_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: IdentityPlatformTenantOauthIdpConfigConfig);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string | undefined;
    set clientSecret(value: string | undefined);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable | undefined;
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    get issuerInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _tenant?;
    get tenant(): string;
    set tenant(value: string);
    get tenantInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): IdentityPlatformTenantOauthIdpConfigTimeoutsOutputReference;
    putTimeouts(value: IdentityPlatformTenantOauthIdpConfigTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): IdentityPlatformTenantOauthIdpConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
