import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityPlatformTenantInboundSamlConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Human friendly display name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#display_name IdentityPlatformTenantInboundSamlConfig#display_name}
     */
    readonly displayName: string;
    /**
     * If this config allows users to sign in with the provider.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#enabled IdentityPlatformTenantInboundSamlConfig#enabled}
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * The name of the InboundSamlConfig resource.
     *
     * Must start with 'saml.' and can only have alphanumeric characters,
     * hyphens, underscores or periods. The part after 'saml.' must also start with a lowercase letter, end with an
     * alphanumeric character, and have at least 2 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#name IdentityPlatformTenantInboundSamlConfig#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#project IdentityPlatformTenantInboundSamlConfig#project}.
     */
    readonly project?: string;
    /**
     * The name of the tenant where this inbound SAML config resource exists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#tenant IdentityPlatformTenantInboundSamlConfig#tenant}
     */
    readonly tenant: string;
    /**
     * idp_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#idp_config IdentityPlatformTenantInboundSamlConfig#idp_config}
     */
    readonly idpConfig: IdentityPlatformTenantInboundSamlConfigIdpConfig;
    /**
     * sp_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#sp_config IdentityPlatformTenantInboundSamlConfig#sp_config}
     */
    readonly spConfig: IdentityPlatformTenantInboundSamlConfigSpConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#timeouts IdentityPlatformTenantInboundSamlConfig#timeouts}
     */
    readonly timeouts?: IdentityPlatformTenantInboundSamlConfigTimeouts;
}
export interface IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates {
    /**
     * The x509 certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#x509_certificate IdentityPlatformTenantInboundSamlConfig#x509_certificate}
     */
    readonly x509Certificate?: string;
}
export interface IdentityPlatformTenantInboundSamlConfigIdpConfig {
    /**
     * Unique identifier for all SAML entities.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#idp_entity_id IdentityPlatformTenantInboundSamlConfig#idp_entity_id}
     */
    readonly idpEntityId: string;
    /**
     * Indicates if outbounding SAMLRequest should be signed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#sign_request IdentityPlatformTenantInboundSamlConfig#sign_request}
     */
    readonly signRequest?: boolean | cdktf.IResolvable;
    /**
     * URL to send Authentication request to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#sso_url IdentityPlatformTenantInboundSamlConfig#sso_url}
     */
    readonly ssoUrl: string;
    /**
     * idp_certificates block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#idp_certificates IdentityPlatformTenantInboundSamlConfig#idp_certificates}
     */
    readonly idpCertificates: IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[];
}
export declare class IdentityPlatformTenantInboundSamlConfigIdpConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _idpEntityId?;
    get idpEntityId(): string;
    set idpEntityId(value: string);
    get idpEntityIdInput(): string | undefined;
    private _signRequest?;
    get signRequest(): boolean | cdktf.IResolvable | undefined;
    set signRequest(value: boolean | cdktf.IResolvable | undefined);
    resetSignRequest(): void;
    get signRequestInput(): boolean | cdktf.IResolvable | undefined;
    private _ssoUrl?;
    get ssoUrl(): string;
    set ssoUrl(value: string);
    get ssoUrlInput(): string | undefined;
    private _idpCertificates?;
    get idpCertificates(): IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[];
    set idpCertificates(value: IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[]);
    get idpCertificatesInput(): IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[] | undefined;
}
export interface IdentityPlatformTenantInboundSamlConfigSpConfig {
    /**
     * Callback URI where responses from IDP are handled. Must start with 'https://'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#callback_uri IdentityPlatformTenantInboundSamlConfig#callback_uri}
     */
    readonly callbackUri: string;
    /**
     * Unique identifier for all SAML entities.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#sp_entity_id IdentityPlatformTenantInboundSamlConfig#sp_entity_id}
     */
    readonly spEntityId: string;
}
export declare class IdentityPlatformTenantInboundSamlConfigSpConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _callbackUri?;
    get callbackUri(): string;
    set callbackUri(value: string);
    get callbackUriInput(): string | undefined;
    private _spEntityId?;
    get spEntityId(): string;
    set spEntityId(value: string);
    get spEntityIdInput(): string | undefined;
}
export interface IdentityPlatformTenantInboundSamlConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#create IdentityPlatformTenantInboundSamlConfig#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#delete IdentityPlatformTenantInboundSamlConfig#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html#update IdentityPlatformTenantInboundSamlConfig#update}.
     */
    readonly update?: string;
}
export declare class IdentityPlatformTenantInboundSamlConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html google_identity_platform_tenant_inbound_saml_config}.
 */
export declare class IdentityPlatformTenantInboundSamlConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config.html google_identity_platform_tenant_inbound_saml_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: IdentityPlatformTenantInboundSamlConfigConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable | undefined;
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _tenant?;
    get tenant(): string;
    set tenant(value: string);
    get tenantInput(): string | undefined;
    private _idpConfig?;
    private __idpConfigOutput;
    get idpConfig(): IdentityPlatformTenantInboundSamlConfigIdpConfigOutputReference;
    putIdpConfig(value: IdentityPlatformTenantInboundSamlConfigIdpConfig): void;
    get idpConfigInput(): IdentityPlatformTenantInboundSamlConfigIdpConfig | undefined;
    private _spConfig?;
    private __spConfigOutput;
    get spConfig(): IdentityPlatformTenantInboundSamlConfigSpConfigOutputReference;
    putSpConfig(value: IdentityPlatformTenantInboundSamlConfigSpConfig): void;
    get spConfigInput(): IdentityPlatformTenantInboundSamlConfigSpConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): IdentityPlatformTenantInboundSamlConfigTimeoutsOutputReference;
    putTimeouts(value: IdentityPlatformTenantInboundSamlConfigTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): IdentityPlatformTenantInboundSamlConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
