import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityPlatformDefaultSupportedIdpConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * OAuth client ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#client_id IdentityPlatformDefaultSupportedIdpConfig#client_id}
     */
    readonly clientId: string;
    /**
     * OAuth client secret.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#client_secret IdentityPlatformDefaultSupportedIdpConfig#client_secret}
     */
    readonly clientSecret: string;
    /**
     * If this IDP allows the user to sign in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#enabled IdentityPlatformDefaultSupportedIdpConfig#enabled}
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * ID of the IDP. Possible values include:.
     *
     * 'apple.com'
     *
     * 'facebook.com'
     *
     * 'gc.apple.com'
     *
     * 'github.com'
     *
     * 'google.com'
     *
     * 'linkedin.com'
     *
     * 'microsoft.com'
     *
     * 'playgames.google.com'
     *
     * 'twitter.com'
     *
     * 'yahoo.com'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#idp_id IdentityPlatformDefaultSupportedIdpConfig#idp_id}
     */
    readonly idpId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#project IdentityPlatformDefaultSupportedIdpConfig#project}.
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#timeouts IdentityPlatformDefaultSupportedIdpConfig#timeouts}
     */
    readonly timeouts?: IdentityPlatformDefaultSupportedIdpConfigTimeouts;
}
export interface IdentityPlatformDefaultSupportedIdpConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#create IdentityPlatformDefaultSupportedIdpConfig#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#delete IdentityPlatformDefaultSupportedIdpConfig#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html#update IdentityPlatformDefaultSupportedIdpConfig#update}.
     */
    readonly update?: string;
}
export declare class IdentityPlatformDefaultSupportedIdpConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html google_identity_platform_default_supported_idp_config}.
 */
export declare class IdentityPlatformDefaultSupportedIdpConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_default_supported_idp_config.html google_identity_platform_default_supported_idp_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: IdentityPlatformDefaultSupportedIdpConfigConfig);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable | undefined;
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _idpId?;
    get idpId(): string;
    set idpId(value: string);
    get idpIdInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): IdentityPlatformDefaultSupportedIdpConfigTimeoutsOutputReference;
    putTimeouts(value: IdentityPlatformDefaultSupportedIdpConfigTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): IdentityPlatformDefaultSupportedIdpConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
