import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IapClientConfig extends cdktf.TerraformMetaArguments {
    /**
     * Identifier of the brand to which this client is attached to. The format is 'projects/{project_number}/brands/{brand_id}/identityAwareProxyClients/{client_id}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client.html#brand IapClient#brand}
     */
    readonly brand: string;
    /**
     * Human-friendly name given to the OAuth client.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client.html#display_name IapClient#display_name}
     */
    readonly displayName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client.html#timeouts IapClient#timeouts}
     */
    readonly timeouts?: IapClientTimeouts;
}
export interface IapClientTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client.html#create IapClient#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_client.html#delete IapClient#delete}.
     */
    readonly delete?: string;
}
export declare class IapClientTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_client.html google_iap_client}.
 */
export declare class IapClient extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_client.html google_iap_client} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: IapClientConfig);
    private _brand?;
    get brand(): string;
    set brand(value: string);
    get brandInput(): string | undefined;
    get clientId(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    get secret(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): IapClientTimeoutsOutputReference;
    putTimeouts(value: IapClientTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): IapClientTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
