import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IapBrandConfig extends cdktf.TerraformMetaArguments {
    /**
     * Application name displayed on OAuth consent screen.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_brand.html#application_title IapBrand#application_title}
     */
    readonly applicationTitle: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_brand.html#project IapBrand#project}.
     */
    readonly project?: string;
    /**
     * Support email displayed on the OAuth consent screen.
     *
     * Can be either a
     * user or group email. When a user email is specified, the caller must
     * be the user with the associated email address. When a group email is
     * specified, the caller can be either a user or a service account which
     * is an owner of the specified group in Cloud Identity.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_brand.html#support_email IapBrand#support_email}
     */
    readonly supportEmail: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_brand.html#timeouts IapBrand#timeouts}
     */
    readonly timeouts?: IapBrandTimeouts;
}
export interface IapBrandTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_brand.html#create IapBrand#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_brand.html#delete IapBrand#delete}.
     */
    readonly delete?: string;
}
export declare class IapBrandTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_brand.html google_iap_brand}.
 */
export declare class IapBrand extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_brand.html google_iap_brand} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: IapBrandConfig);
    private _applicationTitle?;
    get applicationTitle(): string;
    set applicationTitle(value: string);
    get applicationTitleInput(): string | undefined;
    get id(): string;
    get name(): string;
    get orgInternalOnly(): any;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _supportEmail?;
    get supportEmail(): string;
    set supportEmail(value: string);
    get supportEmailInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): IapBrandTimeoutsOutputReference;
    putTimeouts(value: IapBrandTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): IapBrandTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
