import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IapAppEngineVersionIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#app_id IapAppEngineVersionIamBinding#app_id}.
     */
    readonly appId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#members IapAppEngineVersionIamBinding#members}.
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#project IapAppEngineVersionIamBinding#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#role IapAppEngineVersionIamBinding#role}.
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#service IapAppEngineVersionIamBinding#service}.
     */
    readonly service: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#version_id IapAppEngineVersionIamBinding#version_id}.
     */
    readonly versionId: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#condition IapAppEngineVersionIamBinding#condition}
     */
    readonly condition?: IapAppEngineVersionIamBindingCondition;
}
export interface IapAppEngineVersionIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#description IapAppEngineVersionIamBinding#description}.
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#expression IapAppEngineVersionIamBinding#expression}.
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html#title IapAppEngineVersionIamBinding#title}.
     */
    readonly title: string;
}
export declare class IapAppEngineVersionIamBindingConditionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html google_iap_app_engine_version_iam_binding}.
 */
export declare class IapAppEngineVersionIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_app_engine_version_iam_binding.html google_iap_app_engine_version_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: IapAppEngineVersionIamBindingConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _versionId?;
    get versionId(): string;
    set versionId(value: string);
    get versionIdInput(): string | undefined;
    private _condition?;
    private __conditionOutput;
    get condition(): IapAppEngineVersionIamBindingConditionOutputReference;
    putCondition(value: IapAppEngineVersionIamBindingCondition | undefined): void;
    resetCondition(): void;
    get conditionInput(): IapAppEngineVersionIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
