import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthcareHl7V2StoreIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#hl7_v2_store_id HealthcareHl7V2StoreIamMember#hl7_v2_store_id}.
     */
    readonly hl7V2StoreId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#member HealthcareHl7V2StoreIamMember#member}.
     */
    readonly member: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#role HealthcareHl7V2StoreIamMember#role}.
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#condition HealthcareHl7V2StoreIamMember#condition}
     */
    readonly condition?: HealthcareHl7V2StoreIamMemberCondition;
}
export interface HealthcareHl7V2StoreIamMemberCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#description HealthcareHl7V2StoreIamMember#description}.
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#expression HealthcareHl7V2StoreIamMember#expression}.
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#title HealthcareHl7V2StoreIamMember#title}.
     */
    readonly title: string;
}
export declare class HealthcareHl7V2StoreIamMemberConditionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html google_healthcare_hl7_v2_store_iam_member}.
 */
export declare class HealthcareHl7V2StoreIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html google_healthcare_hl7_v2_store_iam_member} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: HealthcareHl7V2StoreIamMemberConfig);
    get etag(): string;
    private _hl7V2StoreId?;
    get hl7V2StoreId(): string;
    set hl7V2StoreId(value: string);
    get hl7V2StoreIdInput(): string | undefined;
    get id(): string;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition?;
    private __conditionOutput;
    get condition(): HealthcareHl7V2StoreIamMemberConditionOutputReference;
    putCondition(value: HealthcareHl7V2StoreIamMemberCondition | undefined): void;
    resetCondition(): void;
    get conditionInput(): HealthcareHl7V2StoreIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
