import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthcareFhirStoreConfig extends cdktf.TerraformMetaArguments {
    /**
     * Identifies the dataset addressed by this request. Must be in the format 'projects/{project}/locations/{location}/datasets/{dataset}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#dataset HealthcareFhirStore#dataset}
     */
    readonly dataset: string;
    /**
     * Whether to disable referential integrity in this FHIR store.
     *
     * This field is immutable after FHIR store
     * creation. The default value is false, meaning that the API will enforce referential integrity and fail the
     * requests that will result in inconsistent state in the FHIR store. When this field is set to true, the API
     * will skip referential integrity check. Consequently, operations that rely on references, such as
     * Patient.get$everything, will not return all the results if broken references exist.
     *
     * * Changing this property may recreate the FHIR store (removing all data) **
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#disable_referential_integrity HealthcareFhirStore#disable_referential_integrity}
     */
    readonly disableReferentialIntegrity?: boolean | cdktf.IResolvable;
    /**
     * Whether to disable resource versioning for this FHIR store.
     *
     * This field can not be changed after the creation
     * of FHIR store. If set to false, which is the default behavior, all write operations will cause historical
     * versions to be recorded automatically. The historical versions can be fetched through the history APIs, but
     * cannot be updated. If set to true, no historical versions will be kept. The server will send back errors for
     * attempts to read the historical versions.
     *
     * * Changing this property may recreate the FHIR store (removing all data) **
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#disable_resource_versioning HealthcareFhirStore#disable_resource_versioning}
     */
    readonly disableResourceVersioning?: boolean | cdktf.IResolvable;
    /**
     * Whether to allow the bulk import API to accept history bundles and directly insert historical resource versions into the FHIR store.
     *
     * Importing resource histories creates resource interactions that appear to have
     * occurred in the past, which clients may not want to allow. If set to false, history bundles within an import
     * will fail with an error.
     *
     * * Changing this property may recreate the FHIR store (removing all data) **
     *
     * * This property can be changed manually in the Google Cloud Healthcare admin console without recreating the FHIR store **
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#enable_history_import HealthcareFhirStore#enable_history_import}
     */
    readonly enableHistoryImport?: boolean | cdktf.IResolvable;
    /**
     * Whether this FHIR store has the updateCreate capability.
     *
     * This determines if the client can use an Update
     * operation to create a new resource with a client-specified ID. If false, all IDs are server-assigned through
     * the Create operation and attempts to Update a non-existent resource will return errors. Please treat the audit
     * logs with appropriate levels of care if client-specified resource IDs contain sensitive data such as patient
     * identifiers, those IDs will be part of the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
     * notifications.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#enable_update_create HealthcareFhirStore#enable_update_create}
     */
    readonly enableUpdateCreate?: boolean | cdktf.IResolvable;
    /**
     * User-supplied key-value pairs used to organize FHIR stores.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
     * conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
     *
     * Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
     * bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
     *
     * No more than 64 labels can be associated with a given store.
     *
     * An object containing a list of "key": value pairs.
     * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#labels HealthcareFhirStore#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The resource name for the FhirStore.
     *
     * * Changing this property may recreate the FHIR store (removing all data) **
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#name HealthcareFhirStore#name}
     */
    readonly name: string;
    /**
     * The FHIR specification version. Possible values: ["DSTU2", "STU3", "R4"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#version HealthcareFhirStore#version}
     */
    readonly version: string;
    /**
     * notification_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#notification_config HealthcareFhirStore#notification_config}
     */
    readonly notificationConfig?: HealthcareFhirStoreNotificationConfig;
    /**
     * stream_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#stream_configs HealthcareFhirStore#stream_configs}
     */
    readonly streamConfigs?: HealthcareFhirStoreStreamConfigs[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#timeouts HealthcareFhirStore#timeouts}
     */
    readonly timeouts?: HealthcareFhirStoreTimeouts;
}
export interface HealthcareFhirStoreNotificationConfig {
    /**
     * The Cloud Pub/Sub topic that notifications of changes are published on.
     *
     * Supplied by the client.
     * PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
     * It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
     * was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
     * project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
     * Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#pubsub_topic HealthcareFhirStore#pubsub_topic}
     */
    readonly pubsubTopic: string;
}
export declare class HealthcareFhirStoreNotificationConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _pubsubTopic?;
    get pubsubTopic(): string;
    set pubsubTopic(value: string);
    get pubsubTopicInput(): string | undefined;
}
export interface HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig {
    /**
     * The depth for all recursive structures in the output analytics schema.
     *
     * For example, concept in the CodeSystem
     * resource is a recursive structure; when the depth is 2, the CodeSystem table will have a column called
     * concept.concept but not concept.concept.concept. If not specified or set to 0, the server will use the default
     * value 2. The maximum depth allowed is 5.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#recursive_structure_depth HealthcareFhirStore#recursive_structure_depth}
     */
    readonly recursiveStructureDepth: number;
    /**
     * Specifies the output schema type.
     *
     * Only ANALYTICS is supported at this time.
     * ANALYTICS: Analytics schema defined by the FHIR community.
     * See https://github.com/FHIR/sql-on-fhir/blob/master/sql-on-fhir.md. Default value: "ANALYTICS" Possible values: ["ANALYTICS"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#schema_type HealthcareFhirStore#schema_type}
     */
    readonly schemaType?: string;
}
export declare class HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _recursiveStructureDepth?;
    get recursiveStructureDepth(): number;
    set recursiveStructureDepth(value: number);
    get recursiveStructureDepthInput(): number | undefined;
    private _schemaType?;
    get schemaType(): string | undefined;
    set schemaType(value: string | undefined);
    resetSchemaType(): void;
    get schemaTypeInput(): string | undefined;
}
export interface HealthcareFhirStoreStreamConfigsBigqueryDestination {
    /**
     * BigQuery URI to a dataset, up to 2000 characters long, in the format bq://projectId.bqDatasetId.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#dataset_uri HealthcareFhirStore#dataset_uri}
     */
    readonly datasetUri: string;
    /**
     * schema_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#schema_config HealthcareFhirStore#schema_config}
     */
    readonly schemaConfig: HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig;
}
export declare class HealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetUri?;
    get datasetUri(): string;
    set datasetUri(value: string);
    get datasetUriInput(): string | undefined;
    private _schemaConfig?;
    private __schemaConfigOutput;
    get schemaConfig(): HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference;
    putSchemaConfig(value: HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig): void;
    get schemaConfigInput(): HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig | undefined;
}
export interface HealthcareFhirStoreStreamConfigs {
    /**
     * Supply a FHIR resource type (such as "Patient" or "Observation").
     *
     * See
     * https://www.hl7.org/fhir/valueset-resource-types.html for a list of all FHIR resource types. The server treats
     * an empty list as an intent to stream all the supported resource types in this FHIR store.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#resource_types HealthcareFhirStore#resource_types}
     */
    readonly resourceTypes?: string[];
    /**
     * bigquery_destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#bigquery_destination HealthcareFhirStore#bigquery_destination}
     */
    readonly bigqueryDestination: HealthcareFhirStoreStreamConfigsBigqueryDestination;
}
export interface HealthcareFhirStoreTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#create HealthcareFhirStore#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#delete HealthcareFhirStore#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html#update HealthcareFhirStore#update}.
     */
    readonly update?: string;
}
export declare class HealthcareFhirStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html google_healthcare_fhir_store}.
 */
export declare class HealthcareFhirStore extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store.html google_healthcare_fhir_store} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: HealthcareFhirStoreConfig);
    private _dataset?;
    get dataset(): string;
    set dataset(value: string);
    get datasetInput(): string | undefined;
    private _disableReferentialIntegrity?;
    get disableReferentialIntegrity(): boolean | cdktf.IResolvable | undefined;
    set disableReferentialIntegrity(value: boolean | cdktf.IResolvable | undefined);
    resetDisableReferentialIntegrity(): void;
    get disableReferentialIntegrityInput(): boolean | cdktf.IResolvable | undefined;
    private _disableResourceVersioning?;
    get disableResourceVersioning(): boolean | cdktf.IResolvable | undefined;
    set disableResourceVersioning(value: boolean | cdktf.IResolvable | undefined);
    resetDisableResourceVersioning(): void;
    get disableResourceVersioningInput(): boolean | cdktf.IResolvable | undefined;
    private _enableHistoryImport?;
    get enableHistoryImport(): boolean | cdktf.IResolvable | undefined;
    set enableHistoryImport(value: boolean | cdktf.IResolvable | undefined);
    resetEnableHistoryImport(): void;
    get enableHistoryImportInput(): boolean | cdktf.IResolvable | undefined;
    private _enableUpdateCreate?;
    get enableUpdateCreate(): boolean | cdktf.IResolvable | undefined;
    set enableUpdateCreate(value: boolean | cdktf.IResolvable | undefined);
    resetEnableUpdateCreate(): void;
    get enableUpdateCreateInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get selfLink(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _notificationConfig?;
    private __notificationConfigOutput;
    get notificationConfig(): HealthcareFhirStoreNotificationConfigOutputReference;
    putNotificationConfig(value: HealthcareFhirStoreNotificationConfig | undefined): void;
    resetNotificationConfig(): void;
    get notificationConfigInput(): HealthcareFhirStoreNotificationConfig | undefined;
    private _streamConfigs?;
    get streamConfigs(): HealthcareFhirStoreStreamConfigs[] | undefined;
    set streamConfigs(value: HealthcareFhirStoreStreamConfigs[] | undefined);
    resetStreamConfigs(): void;
    get streamConfigsInput(): HealthcareFhirStoreStreamConfigs[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): HealthcareFhirStoreTimeoutsOutputReference;
    putTimeouts(value: HealthcareFhirStoreTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): HealthcareFhirStoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
