import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthcareFhirStoreIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_binding.html#fhir_store_id HealthcareFhirStoreIamBinding#fhir_store_id}.
     */
    readonly fhirStoreId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_binding.html#members HealthcareFhirStoreIamBinding#members}.
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_binding.html#role HealthcareFhirStoreIamBinding#role}.
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_binding.html#condition HealthcareFhirStoreIamBinding#condition}
     */
    readonly condition?: HealthcareFhirStoreIamBindingCondition;
}
export interface HealthcareFhirStoreIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_binding.html#description HealthcareFhirStoreIamBinding#description}.
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_binding.html#expression HealthcareFhirStoreIamBinding#expression}.
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_binding.html#title HealthcareFhirStoreIamBinding#title}.
     */
    readonly title: string;
}
export declare class HealthcareFhirStoreIamBindingConditionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_binding.html google_healthcare_fhir_store_iam_binding}.
 */
export declare class HealthcareFhirStoreIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store_iam_binding.html google_healthcare_fhir_store_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: HealthcareFhirStoreIamBindingConfig);
    get etag(): string;
    private _fhirStoreId?;
    get fhirStoreId(): string;
    set fhirStoreId(value: string);
    get fhirStoreIdInput(): string | undefined;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition?;
    private __conditionOutput;
    get condition(): HealthcareFhirStoreIamBindingConditionOutputReference;
    putCondition(value: HealthcareFhirStoreIamBindingCondition | undefined): void;
    resetCondition(): void;
    get conditionInput(): HealthcareFhirStoreIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
