import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthcareDatasetConfig extends cdktf.TerraformMetaArguments {
    /**
     * The location for the Dataset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset.html#location HealthcareDataset#location}
     */
    readonly location: string;
    /**
     * The resource name for the Dataset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset.html#name HealthcareDataset#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset.html#project HealthcareDataset#project}.
     */
    readonly project?: string;
    /**
     * The default timezone used by this dataset.
     *
     * Must be a either a valid IANA time zone name such as
     * "America/New_York" or empty, which defaults to UTC. This is used for parsing times in resources
     * (e.g., HL7 messages) where no explicit timezone is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset.html#time_zone HealthcareDataset#time_zone}
     */
    readonly timeZone?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset.html#timeouts HealthcareDataset#timeouts}
     */
    readonly timeouts?: HealthcareDatasetTimeouts;
}
export interface HealthcareDatasetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset.html#create HealthcareDataset#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset.html#delete HealthcareDataset#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset.html#update HealthcareDataset#update}.
     */
    readonly update?: string;
}
export declare class HealthcareDatasetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset.html google_healthcare_dataset}.
 */
export declare class HealthcareDataset extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_dataset.html google_healthcare_dataset} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: HealthcareDatasetConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeZone?;
    get timeZone(): string | undefined;
    set timeZone(value: string | undefined);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): HealthcareDatasetTimeoutsOutputReference;
    putTimeouts(value: HealthcareDatasetTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): HealthcareDatasetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
