import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthcareConsentStoreConfig extends cdktf.TerraformMetaArguments {
    /**
     * Identifies the dataset addressed by this request. Must be in the format 'projects/{project}/locations/{location}/datasets/{dataset}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store.html#dataset HealthcareConsentStore#dataset}
     */
    readonly dataset: string;
    /**
     * Default time to live for consents in this store.
     *
     * Must be at least 24 hours. Updating this field will not affect the expiration time of existing consents.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store.html#default_consent_ttl HealthcareConsentStore#default_consent_ttl}
     */
    readonly defaultConsentTtl?: string;
    /**
     * If true, [consents.patch] [google.cloud.healthcare.v1.consent.UpdateConsent] creates the consent if it does not already exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store.html#enable_consent_create_on_update HealthcareConsentStore#enable_consent_create_on_update}
     */
    readonly enableConsentCreateOnUpdate?: boolean | cdktf.IResolvable;
    /**
     * User-supplied key-value pairs used to organize Consent stores.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
     * conform to the following PCRE regular expression: '[\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}'
     *
     * Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
     * bytes, and must conform to the following PCRE regular expression: '[\p{Ll}\p{Lo}\p{N}_-]{0,63}'
     *
     * No more than 64 labels can be associated with a given store.
     *
     * An object containing a list of "key": value pairs.
     * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store.html#labels HealthcareConsentStore#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The name of this ConsentStore, for example: "consent1".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store.html#name HealthcareConsentStore#name}
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store.html#timeouts HealthcareConsentStore#timeouts}
     */
    readonly timeouts?: HealthcareConsentStoreTimeouts;
}
export interface HealthcareConsentStoreTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store.html#create HealthcareConsentStore#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store.html#delete HealthcareConsentStore#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store.html#update HealthcareConsentStore#update}.
     */
    readonly update?: string;
}
export declare class HealthcareConsentStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store.html google_healthcare_consent_store}.
 */
export declare class HealthcareConsentStore extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store.html google_healthcare_consent_store} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: HealthcareConsentStoreConfig);
    private _dataset?;
    get dataset(): string;
    set dataset(value: string);
    get datasetInput(): string | undefined;
    private _defaultConsentTtl?;
    get defaultConsentTtl(): string | undefined;
    set defaultConsentTtl(value: string | undefined);
    resetDefaultConsentTtl(): void;
    get defaultConsentTtlInput(): string | undefined;
    private _enableConsentCreateOnUpdate?;
    get enableConsentCreateOnUpdate(): boolean | cdktf.IResolvable | undefined;
    set enableConsentCreateOnUpdate(value: boolean | cdktf.IResolvable | undefined);
    resetEnableConsentCreateOnUpdate(): void;
    get enableConsentCreateOnUpdateInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): HealthcareConsentStoreTimeoutsOutputReference;
    putTimeouts(value: HealthcareConsentStoreTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): HealthcareConsentStoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
