import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthcareConsentStoreIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#consent_store_id HealthcareConsentStoreIamBinding#consent_store_id}.
     */
    readonly consentStoreId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#dataset HealthcareConsentStoreIamBinding#dataset}.
     */
    readonly dataset: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#members HealthcareConsentStoreIamBinding#members}.
     */
    readonly members: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#role HealthcareConsentStoreIamBinding#role}.
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#condition HealthcareConsentStoreIamBinding#condition}
     */
    readonly condition?: HealthcareConsentStoreIamBindingCondition;
}
export interface HealthcareConsentStoreIamBindingCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#description HealthcareConsentStoreIamBinding#description}.
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#expression HealthcareConsentStoreIamBinding#expression}.
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html#title HealthcareConsentStoreIamBinding#title}.
     */
    readonly title: string;
}
export declare class HealthcareConsentStoreIamBindingConditionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html google_healthcare_consent_store_iam_binding}.
 */
export declare class HealthcareConsentStoreIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store_iam_binding.html google_healthcare_consent_store_iam_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: HealthcareConsentStoreIamBindingConfig);
    private _consentStoreId?;
    get consentStoreId(): string;
    set consentStoreId(value: string);
    get consentStoreIdInput(): string | undefined;
    private _dataset?;
    get dataset(): string;
    set dataset(value: string);
    get datasetInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition?;
    private __conditionOutput;
    get condition(): HealthcareConsentStoreIamBindingConditionOutputReference;
    putCondition(value: HealthcareConsentStoreIamBindingCondition | undefined): void;
    resetCondition(): void;
    get conditionInput(): HealthcareConsentStoreIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
