import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleProviderConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#access_approval_custom_endpoint GoogleProvider#access_approval_custom_endpoint}.
     */
    readonly accessApprovalCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#access_context_manager_custom_endpoint GoogleProvider#access_context_manager_custom_endpoint}.
     */
    readonly accessContextManagerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#access_token GoogleProvider#access_token}.
     */
    readonly accessToken?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#active_directory_custom_endpoint GoogleProvider#active_directory_custom_endpoint}.
     */
    readonly activeDirectoryCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#apigee_custom_endpoint GoogleProvider#apigee_custom_endpoint}.
     */
    readonly apigeeCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#app_engine_custom_endpoint GoogleProvider#app_engine_custom_endpoint}.
     */
    readonly appEngineCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#assured_workloads_custom_endpoint GoogleProvider#assured_workloads_custom_endpoint}.
     */
    readonly assuredWorkloadsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#big_query_custom_endpoint GoogleProvider#big_query_custom_endpoint}.
     */
    readonly bigQueryCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#bigquery_data_transfer_custom_endpoint GoogleProvider#bigquery_data_transfer_custom_endpoint}.
     */
    readonly bigqueryDataTransferCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#bigquery_reservation_custom_endpoint GoogleProvider#bigquery_reservation_custom_endpoint}.
     */
    readonly bigqueryReservationCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#bigtable_custom_endpoint GoogleProvider#bigtable_custom_endpoint}.
     */
    readonly bigtableCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#billing_custom_endpoint GoogleProvider#billing_custom_endpoint}.
     */
    readonly billingCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#billing_project GoogleProvider#billing_project}.
     */
    readonly billingProject?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#binary_authorization_custom_endpoint GoogleProvider#binary_authorization_custom_endpoint}.
     */
    readonly binaryAuthorizationCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_asset_custom_endpoint GoogleProvider#cloud_asset_custom_endpoint}.
     */
    readonly cloudAssetCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_billing_custom_endpoint GoogleProvider#cloud_billing_custom_endpoint}.
     */
    readonly cloudBillingCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_build_custom_endpoint GoogleProvider#cloud_build_custom_endpoint}.
     */
    readonly cloudBuildCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_functions_custom_endpoint GoogleProvider#cloud_functions_custom_endpoint}.
     */
    readonly cloudFunctionsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_identity_custom_endpoint GoogleProvider#cloud_identity_custom_endpoint}.
     */
    readonly cloudIdentityCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_iot_custom_endpoint GoogleProvider#cloud_iot_custom_endpoint}.
     */
    readonly cloudIotCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_resource_manager_custom_endpoint GoogleProvider#cloud_resource_manager_custom_endpoint}.
     */
    readonly cloudResourceManagerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_run_custom_endpoint GoogleProvider#cloud_run_custom_endpoint}.
     */
    readonly cloudRunCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_scheduler_custom_endpoint GoogleProvider#cloud_scheduler_custom_endpoint}.
     */
    readonly cloudSchedulerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#cloud_tasks_custom_endpoint GoogleProvider#cloud_tasks_custom_endpoint}.
     */
    readonly cloudTasksCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#composer_custom_endpoint GoogleProvider#composer_custom_endpoint}.
     */
    readonly composerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#compute_beta_custom_endpoint GoogleProvider#compute_beta_custom_endpoint}.
     */
    readonly computeBetaCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#compute_custom_endpoint GoogleProvider#compute_custom_endpoint}.
     */
    readonly computeCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#container_analysis_custom_endpoint GoogleProvider#container_analysis_custom_endpoint}.
     */
    readonly containerAnalysisCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#container_beta_custom_endpoint GoogleProvider#container_beta_custom_endpoint}.
     */
    readonly containerBetaCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#container_custom_endpoint GoogleProvider#container_custom_endpoint}.
     */
    readonly containerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#credentials GoogleProvider#credentials}.
     */
    readonly credentials?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#data_catalog_custom_endpoint GoogleProvider#data_catalog_custom_endpoint}.
     */
    readonly dataCatalogCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#data_loss_prevention_custom_endpoint GoogleProvider#data_loss_prevention_custom_endpoint}.
     */
    readonly dataLossPreventionCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#dataflow_custom_endpoint GoogleProvider#dataflow_custom_endpoint}.
     */
    readonly dataflowCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#dataproc_beta_custom_endpoint GoogleProvider#dataproc_beta_custom_endpoint}.
     */
    readonly dataprocBetaCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#dataproc_custom_endpoint GoogleProvider#dataproc_custom_endpoint}.
     */
    readonly dataprocCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#datastore_custom_endpoint GoogleProvider#datastore_custom_endpoint}.
     */
    readonly datastoreCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#deployment_manager_custom_endpoint GoogleProvider#deployment_manager_custom_endpoint}.
     */
    readonly deploymentManagerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#dialogflow_custom_endpoint GoogleProvider#dialogflow_custom_endpoint}.
     */
    readonly dialogflowCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#dialogflow_cx_custom_endpoint GoogleProvider#dialogflow_cx_custom_endpoint}.
     */
    readonly dialogflowCxCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#dns_custom_endpoint GoogleProvider#dns_custom_endpoint}.
     */
    readonly dnsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#essential_contacts_custom_endpoint GoogleProvider#essential_contacts_custom_endpoint}.
     */
    readonly essentialContactsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#eventarc_custom_endpoint GoogleProvider#eventarc_custom_endpoint}.
     */
    readonly eventarcCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#filestore_custom_endpoint GoogleProvider#filestore_custom_endpoint}.
     */
    readonly filestoreCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#firestore_custom_endpoint GoogleProvider#firestore_custom_endpoint}.
     */
    readonly firestoreCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#game_services_custom_endpoint GoogleProvider#game_services_custom_endpoint}.
     */
    readonly gameServicesCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#gke_hub_custom_endpoint GoogleProvider#gke_hub_custom_endpoint}.
     */
    readonly gkeHubCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#gkehub_feature_custom_endpoint GoogleProvider#gkehub_feature_custom_endpoint}.
     */
    readonly gkehubFeatureCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#healthcare_custom_endpoint GoogleProvider#healthcare_custom_endpoint}.
     */
    readonly healthcareCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#iam_credentials_custom_endpoint GoogleProvider#iam_credentials_custom_endpoint}.
     */
    readonly iamCredentialsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#iam_custom_endpoint GoogleProvider#iam_custom_endpoint}.
     */
    readonly iamCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#iap_custom_endpoint GoogleProvider#iap_custom_endpoint}.
     */
    readonly iapCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#identity_platform_custom_endpoint GoogleProvider#identity_platform_custom_endpoint}.
     */
    readonly identityPlatformCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#impersonate_service_account GoogleProvider#impersonate_service_account}.
     */
    readonly impersonateServiceAccount?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#impersonate_service_account_delegates GoogleProvider#impersonate_service_account_delegates}.
     */
    readonly impersonateServiceAccountDelegates?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#kms_custom_endpoint GoogleProvider#kms_custom_endpoint}.
     */
    readonly kmsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#logging_custom_endpoint GoogleProvider#logging_custom_endpoint}.
     */
    readonly loggingCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#memcache_custom_endpoint GoogleProvider#memcache_custom_endpoint}.
     */
    readonly memcacheCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#ml_engine_custom_endpoint GoogleProvider#ml_engine_custom_endpoint}.
     */
    readonly mlEngineCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#monitoring_custom_endpoint GoogleProvider#monitoring_custom_endpoint}.
     */
    readonly monitoringCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#network_management_custom_endpoint GoogleProvider#network_management_custom_endpoint}.
     */
    readonly networkManagementCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#network_services_custom_endpoint GoogleProvider#network_services_custom_endpoint}.
     */
    readonly networkServicesCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#notebooks_custom_endpoint GoogleProvider#notebooks_custom_endpoint}.
     */
    readonly notebooksCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#org_policy_custom_endpoint GoogleProvider#org_policy_custom_endpoint}.
     */
    readonly orgPolicyCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#os_config_custom_endpoint GoogleProvider#os_config_custom_endpoint}.
     */
    readonly osConfigCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#os_login_custom_endpoint GoogleProvider#os_login_custom_endpoint}.
     */
    readonly osLoginCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#privateca_custom_endpoint GoogleProvider#privateca_custom_endpoint}.
     */
    readonly privatecaCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#project GoogleProvider#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#pubsub_custom_endpoint GoogleProvider#pubsub_custom_endpoint}.
     */
    readonly pubsubCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#pubsub_lite_custom_endpoint GoogleProvider#pubsub_lite_custom_endpoint}.
     */
    readonly pubsubLiteCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#redis_custom_endpoint GoogleProvider#redis_custom_endpoint}.
     */
    readonly redisCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#region GoogleProvider#region}.
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#request_reason GoogleProvider#request_reason}.
     */
    readonly requestReason?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#request_timeout GoogleProvider#request_timeout}.
     */
    readonly requestTimeout?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#resource_manager_custom_endpoint GoogleProvider#resource_manager_custom_endpoint}.
     */
    readonly resourceManagerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#resource_manager_v2_custom_endpoint GoogleProvider#resource_manager_v2_custom_endpoint}.
     */
    readonly resourceManagerV2CustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#runtime_config_custom_endpoint GoogleProvider#runtime_config_custom_endpoint}.
     */
    readonly runtimeConfigCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#runtimeconfig_custom_endpoint GoogleProvider#runtimeconfig_custom_endpoint}.
     */
    readonly runtimeconfigCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#scopes GoogleProvider#scopes}.
     */
    readonly scopes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#secret_manager_custom_endpoint GoogleProvider#secret_manager_custom_endpoint}.
     */
    readonly secretManagerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#security_center_custom_endpoint GoogleProvider#security_center_custom_endpoint}.
     */
    readonly securityCenterCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#service_management_custom_endpoint GoogleProvider#service_management_custom_endpoint}.
     */
    readonly serviceManagementCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#service_networking_custom_endpoint GoogleProvider#service_networking_custom_endpoint}.
     */
    readonly serviceNetworkingCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#service_usage_custom_endpoint GoogleProvider#service_usage_custom_endpoint}.
     */
    readonly serviceUsageCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#source_repo_custom_endpoint GoogleProvider#source_repo_custom_endpoint}.
     */
    readonly sourceRepoCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#spanner_custom_endpoint GoogleProvider#spanner_custom_endpoint}.
     */
    readonly spannerCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#sql_custom_endpoint GoogleProvider#sql_custom_endpoint}.
     */
    readonly sqlCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#storage_custom_endpoint GoogleProvider#storage_custom_endpoint}.
     */
    readonly storageCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#storage_transfer_custom_endpoint GoogleProvider#storage_transfer_custom_endpoint}.
     */
    readonly storageTransferCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#tags_custom_endpoint GoogleProvider#tags_custom_endpoint}.
     */
    readonly tagsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#tpu_custom_endpoint GoogleProvider#tpu_custom_endpoint}.
     */
    readonly tpuCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#user_project_override GoogleProvider#user_project_override}.
     */
    readonly userProjectOverride?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#vertex_ai_custom_endpoint GoogleProvider#vertex_ai_custom_endpoint}.
     */
    readonly vertexAiCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#vpc_access_custom_endpoint GoogleProvider#vpc_access_custom_endpoint}.
     */
    readonly vpcAccessCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#workflows_custom_endpoint GoogleProvider#workflows_custom_endpoint}.
     */
    readonly workflowsCustomEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#zone GoogleProvider#zone}.
     */
    readonly zone?: string;
    /**
     * Alias name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#alias GoogleProvider#alias}
     */
    readonly alias?: string;
    /**
     * batching block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#batching GoogleProvider#batching}
     */
    readonly batching?: GoogleProviderBatching;
}
export interface GoogleProviderBatching {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#enable_batching GoogleProvider#enable_batching}.
     */
    readonly enableBatching?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google#send_after GoogleProvider#send_after}.
     */
    readonly sendAfter?: string;
}
export declare class GoogleProviderBatchingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableBatching?;
    get enableBatching(): boolean | cdktf.IResolvable | undefined | undefined;
    set enableBatching(value: boolean | cdktf.IResolvable | undefined | undefined);
    resetEnableBatching(): void;
    get enableBatchingInput(): boolean | cdktf.IResolvable | undefined;
    private _sendAfter?;
    get sendAfter(): string | undefined | undefined;
    set sendAfter(value: string | undefined | undefined);
    resetSendAfter(): void;
    get sendAfterInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google google}.
 */
export declare class GoogleProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google google} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: GoogleProviderConfig);
    private _accessApprovalCustomEndpoint?;
    get accessApprovalCustomEndpoint(): string | undefined | undefined;
    set accessApprovalCustomEndpoint(value: string | undefined | undefined);
    resetAccessApprovalCustomEndpoint(): void;
    get accessApprovalCustomEndpointInput(): string | undefined;
    private _accessContextManagerCustomEndpoint?;
    get accessContextManagerCustomEndpoint(): string | undefined | undefined;
    set accessContextManagerCustomEndpoint(value: string | undefined | undefined);
    resetAccessContextManagerCustomEndpoint(): void;
    get accessContextManagerCustomEndpointInput(): string | undefined;
    private _accessToken?;
    get accessToken(): string | undefined | undefined;
    set accessToken(value: string | undefined | undefined);
    resetAccessToken(): void;
    get accessTokenInput(): string | undefined;
    private _activeDirectoryCustomEndpoint?;
    get activeDirectoryCustomEndpoint(): string | undefined | undefined;
    set activeDirectoryCustomEndpoint(value: string | undefined | undefined);
    resetActiveDirectoryCustomEndpoint(): void;
    get activeDirectoryCustomEndpointInput(): string | undefined;
    private _apigeeCustomEndpoint?;
    get apigeeCustomEndpoint(): string | undefined | undefined;
    set apigeeCustomEndpoint(value: string | undefined | undefined);
    resetApigeeCustomEndpoint(): void;
    get apigeeCustomEndpointInput(): string | undefined;
    private _appEngineCustomEndpoint?;
    get appEngineCustomEndpoint(): string | undefined | undefined;
    set appEngineCustomEndpoint(value: string | undefined | undefined);
    resetAppEngineCustomEndpoint(): void;
    get appEngineCustomEndpointInput(): string | undefined;
    private _assuredWorkloadsCustomEndpoint?;
    get assuredWorkloadsCustomEndpoint(): string | undefined | undefined;
    set assuredWorkloadsCustomEndpoint(value: string | undefined | undefined);
    resetAssuredWorkloadsCustomEndpoint(): void;
    get assuredWorkloadsCustomEndpointInput(): string | undefined;
    private _bigQueryCustomEndpoint?;
    get bigQueryCustomEndpoint(): string | undefined | undefined;
    set bigQueryCustomEndpoint(value: string | undefined | undefined);
    resetBigQueryCustomEndpoint(): void;
    get bigQueryCustomEndpointInput(): string | undefined;
    private _bigqueryDataTransferCustomEndpoint?;
    get bigqueryDataTransferCustomEndpoint(): string | undefined | undefined;
    set bigqueryDataTransferCustomEndpoint(value: string | undefined | undefined);
    resetBigqueryDataTransferCustomEndpoint(): void;
    get bigqueryDataTransferCustomEndpointInput(): string | undefined;
    private _bigqueryReservationCustomEndpoint?;
    get bigqueryReservationCustomEndpoint(): string | undefined | undefined;
    set bigqueryReservationCustomEndpoint(value: string | undefined | undefined);
    resetBigqueryReservationCustomEndpoint(): void;
    get bigqueryReservationCustomEndpointInput(): string | undefined;
    private _bigtableCustomEndpoint?;
    get bigtableCustomEndpoint(): string | undefined | undefined;
    set bigtableCustomEndpoint(value: string | undefined | undefined);
    resetBigtableCustomEndpoint(): void;
    get bigtableCustomEndpointInput(): string | undefined;
    private _billingCustomEndpoint?;
    get billingCustomEndpoint(): string | undefined | undefined;
    set billingCustomEndpoint(value: string | undefined | undefined);
    resetBillingCustomEndpoint(): void;
    get billingCustomEndpointInput(): string | undefined;
    private _billingProject?;
    get billingProject(): string | undefined | undefined;
    set billingProject(value: string | undefined | undefined);
    resetBillingProject(): void;
    get billingProjectInput(): string | undefined;
    private _binaryAuthorizationCustomEndpoint?;
    get binaryAuthorizationCustomEndpoint(): string | undefined | undefined;
    set binaryAuthorizationCustomEndpoint(value: string | undefined | undefined);
    resetBinaryAuthorizationCustomEndpoint(): void;
    get binaryAuthorizationCustomEndpointInput(): string | undefined;
    private _cloudAssetCustomEndpoint?;
    get cloudAssetCustomEndpoint(): string | undefined | undefined;
    set cloudAssetCustomEndpoint(value: string | undefined | undefined);
    resetCloudAssetCustomEndpoint(): void;
    get cloudAssetCustomEndpointInput(): string | undefined;
    private _cloudBillingCustomEndpoint?;
    get cloudBillingCustomEndpoint(): string | undefined | undefined;
    set cloudBillingCustomEndpoint(value: string | undefined | undefined);
    resetCloudBillingCustomEndpoint(): void;
    get cloudBillingCustomEndpointInput(): string | undefined;
    private _cloudBuildCustomEndpoint?;
    get cloudBuildCustomEndpoint(): string | undefined | undefined;
    set cloudBuildCustomEndpoint(value: string | undefined | undefined);
    resetCloudBuildCustomEndpoint(): void;
    get cloudBuildCustomEndpointInput(): string | undefined;
    private _cloudFunctionsCustomEndpoint?;
    get cloudFunctionsCustomEndpoint(): string | undefined | undefined;
    set cloudFunctionsCustomEndpoint(value: string | undefined | undefined);
    resetCloudFunctionsCustomEndpoint(): void;
    get cloudFunctionsCustomEndpointInput(): string | undefined;
    private _cloudIdentityCustomEndpoint?;
    get cloudIdentityCustomEndpoint(): string | undefined | undefined;
    set cloudIdentityCustomEndpoint(value: string | undefined | undefined);
    resetCloudIdentityCustomEndpoint(): void;
    get cloudIdentityCustomEndpointInput(): string | undefined;
    private _cloudIotCustomEndpoint?;
    get cloudIotCustomEndpoint(): string | undefined | undefined;
    set cloudIotCustomEndpoint(value: string | undefined | undefined);
    resetCloudIotCustomEndpoint(): void;
    get cloudIotCustomEndpointInput(): string | undefined;
    private _cloudResourceManagerCustomEndpoint?;
    get cloudResourceManagerCustomEndpoint(): string | undefined | undefined;
    set cloudResourceManagerCustomEndpoint(value: string | undefined | undefined);
    resetCloudResourceManagerCustomEndpoint(): void;
    get cloudResourceManagerCustomEndpointInput(): string | undefined;
    private _cloudRunCustomEndpoint?;
    get cloudRunCustomEndpoint(): string | undefined | undefined;
    set cloudRunCustomEndpoint(value: string | undefined | undefined);
    resetCloudRunCustomEndpoint(): void;
    get cloudRunCustomEndpointInput(): string | undefined;
    private _cloudSchedulerCustomEndpoint?;
    get cloudSchedulerCustomEndpoint(): string | undefined | undefined;
    set cloudSchedulerCustomEndpoint(value: string | undefined | undefined);
    resetCloudSchedulerCustomEndpoint(): void;
    get cloudSchedulerCustomEndpointInput(): string | undefined;
    private _cloudTasksCustomEndpoint?;
    get cloudTasksCustomEndpoint(): string | undefined | undefined;
    set cloudTasksCustomEndpoint(value: string | undefined | undefined);
    resetCloudTasksCustomEndpoint(): void;
    get cloudTasksCustomEndpointInput(): string | undefined;
    private _composerCustomEndpoint?;
    get composerCustomEndpoint(): string | undefined | undefined;
    set composerCustomEndpoint(value: string | undefined | undefined);
    resetComposerCustomEndpoint(): void;
    get composerCustomEndpointInput(): string | undefined;
    private _computeBetaCustomEndpoint?;
    get computeBetaCustomEndpoint(): string | undefined | undefined;
    set computeBetaCustomEndpoint(value: string | undefined | undefined);
    resetComputeBetaCustomEndpoint(): void;
    get computeBetaCustomEndpointInput(): string | undefined;
    private _computeCustomEndpoint?;
    get computeCustomEndpoint(): string | undefined | undefined;
    set computeCustomEndpoint(value: string | undefined | undefined);
    resetComputeCustomEndpoint(): void;
    get computeCustomEndpointInput(): string | undefined;
    private _containerAnalysisCustomEndpoint?;
    get containerAnalysisCustomEndpoint(): string | undefined | undefined;
    set containerAnalysisCustomEndpoint(value: string | undefined | undefined);
    resetContainerAnalysisCustomEndpoint(): void;
    get containerAnalysisCustomEndpointInput(): string | undefined;
    private _containerBetaCustomEndpoint?;
    get containerBetaCustomEndpoint(): string | undefined | undefined;
    set containerBetaCustomEndpoint(value: string | undefined | undefined);
    resetContainerBetaCustomEndpoint(): void;
    get containerBetaCustomEndpointInput(): string | undefined;
    private _containerCustomEndpoint?;
    get containerCustomEndpoint(): string | undefined | undefined;
    set containerCustomEndpoint(value: string | undefined | undefined);
    resetContainerCustomEndpoint(): void;
    get containerCustomEndpointInput(): string | undefined;
    private _credentials?;
    get credentials(): string | undefined | undefined;
    set credentials(value: string | undefined | undefined);
    resetCredentials(): void;
    get credentialsInput(): string | undefined;
    private _dataCatalogCustomEndpoint?;
    get dataCatalogCustomEndpoint(): string | undefined | undefined;
    set dataCatalogCustomEndpoint(value: string | undefined | undefined);
    resetDataCatalogCustomEndpoint(): void;
    get dataCatalogCustomEndpointInput(): string | undefined;
    private _dataLossPreventionCustomEndpoint?;
    get dataLossPreventionCustomEndpoint(): string | undefined | undefined;
    set dataLossPreventionCustomEndpoint(value: string | undefined | undefined);
    resetDataLossPreventionCustomEndpoint(): void;
    get dataLossPreventionCustomEndpointInput(): string | undefined;
    private _dataflowCustomEndpoint?;
    get dataflowCustomEndpoint(): string | undefined | undefined;
    set dataflowCustomEndpoint(value: string | undefined | undefined);
    resetDataflowCustomEndpoint(): void;
    get dataflowCustomEndpointInput(): string | undefined;
    private _dataprocBetaCustomEndpoint?;
    get dataprocBetaCustomEndpoint(): string | undefined | undefined;
    set dataprocBetaCustomEndpoint(value: string | undefined | undefined);
    resetDataprocBetaCustomEndpoint(): void;
    get dataprocBetaCustomEndpointInput(): string | undefined;
    private _dataprocCustomEndpoint?;
    get dataprocCustomEndpoint(): string | undefined | undefined;
    set dataprocCustomEndpoint(value: string | undefined | undefined);
    resetDataprocCustomEndpoint(): void;
    get dataprocCustomEndpointInput(): string | undefined;
    private _datastoreCustomEndpoint?;
    get datastoreCustomEndpoint(): string | undefined | undefined;
    set datastoreCustomEndpoint(value: string | undefined | undefined);
    resetDatastoreCustomEndpoint(): void;
    get datastoreCustomEndpointInput(): string | undefined;
    private _deploymentManagerCustomEndpoint?;
    get deploymentManagerCustomEndpoint(): string | undefined | undefined;
    set deploymentManagerCustomEndpoint(value: string | undefined | undefined);
    resetDeploymentManagerCustomEndpoint(): void;
    get deploymentManagerCustomEndpointInput(): string | undefined;
    private _dialogflowCustomEndpoint?;
    get dialogflowCustomEndpoint(): string | undefined | undefined;
    set dialogflowCustomEndpoint(value: string | undefined | undefined);
    resetDialogflowCustomEndpoint(): void;
    get dialogflowCustomEndpointInput(): string | undefined;
    private _dialogflowCxCustomEndpoint?;
    get dialogflowCxCustomEndpoint(): string | undefined | undefined;
    set dialogflowCxCustomEndpoint(value: string | undefined | undefined);
    resetDialogflowCxCustomEndpoint(): void;
    get dialogflowCxCustomEndpointInput(): string | undefined;
    private _dnsCustomEndpoint?;
    get dnsCustomEndpoint(): string | undefined | undefined;
    set dnsCustomEndpoint(value: string | undefined | undefined);
    resetDnsCustomEndpoint(): void;
    get dnsCustomEndpointInput(): string | undefined;
    private _essentialContactsCustomEndpoint?;
    get essentialContactsCustomEndpoint(): string | undefined | undefined;
    set essentialContactsCustomEndpoint(value: string | undefined | undefined);
    resetEssentialContactsCustomEndpoint(): void;
    get essentialContactsCustomEndpointInput(): string | undefined;
    private _eventarcCustomEndpoint?;
    get eventarcCustomEndpoint(): string | undefined | undefined;
    set eventarcCustomEndpoint(value: string | undefined | undefined);
    resetEventarcCustomEndpoint(): void;
    get eventarcCustomEndpointInput(): string | undefined;
    private _filestoreCustomEndpoint?;
    get filestoreCustomEndpoint(): string | undefined | undefined;
    set filestoreCustomEndpoint(value: string | undefined | undefined);
    resetFilestoreCustomEndpoint(): void;
    get filestoreCustomEndpointInput(): string | undefined;
    private _firestoreCustomEndpoint?;
    get firestoreCustomEndpoint(): string | undefined | undefined;
    set firestoreCustomEndpoint(value: string | undefined | undefined);
    resetFirestoreCustomEndpoint(): void;
    get firestoreCustomEndpointInput(): string | undefined;
    private _gameServicesCustomEndpoint?;
    get gameServicesCustomEndpoint(): string | undefined | undefined;
    set gameServicesCustomEndpoint(value: string | undefined | undefined);
    resetGameServicesCustomEndpoint(): void;
    get gameServicesCustomEndpointInput(): string | undefined;
    private _gkeHubCustomEndpoint?;
    get gkeHubCustomEndpoint(): string | undefined | undefined;
    set gkeHubCustomEndpoint(value: string | undefined | undefined);
    resetGkeHubCustomEndpoint(): void;
    get gkeHubCustomEndpointInput(): string | undefined;
    private _gkehubFeatureCustomEndpoint?;
    get gkehubFeatureCustomEndpoint(): string | undefined | undefined;
    set gkehubFeatureCustomEndpoint(value: string | undefined | undefined);
    resetGkehubFeatureCustomEndpoint(): void;
    get gkehubFeatureCustomEndpointInput(): string | undefined;
    private _healthcareCustomEndpoint?;
    get healthcareCustomEndpoint(): string | undefined | undefined;
    set healthcareCustomEndpoint(value: string | undefined | undefined);
    resetHealthcareCustomEndpoint(): void;
    get healthcareCustomEndpointInput(): string | undefined;
    private _iamCredentialsCustomEndpoint?;
    get iamCredentialsCustomEndpoint(): string | undefined | undefined;
    set iamCredentialsCustomEndpoint(value: string | undefined | undefined);
    resetIamCredentialsCustomEndpoint(): void;
    get iamCredentialsCustomEndpointInput(): string | undefined;
    private _iamCustomEndpoint?;
    get iamCustomEndpoint(): string | undefined | undefined;
    set iamCustomEndpoint(value: string | undefined | undefined);
    resetIamCustomEndpoint(): void;
    get iamCustomEndpointInput(): string | undefined;
    private _iapCustomEndpoint?;
    get iapCustomEndpoint(): string | undefined | undefined;
    set iapCustomEndpoint(value: string | undefined | undefined);
    resetIapCustomEndpoint(): void;
    get iapCustomEndpointInput(): string | undefined;
    private _identityPlatformCustomEndpoint?;
    get identityPlatformCustomEndpoint(): string | undefined | undefined;
    set identityPlatformCustomEndpoint(value: string | undefined | undefined);
    resetIdentityPlatformCustomEndpoint(): void;
    get identityPlatformCustomEndpointInput(): string | undefined;
    private _impersonateServiceAccount?;
    get impersonateServiceAccount(): string | undefined | undefined;
    set impersonateServiceAccount(value: string | undefined | undefined);
    resetImpersonateServiceAccount(): void;
    get impersonateServiceAccountInput(): string | undefined;
    private _impersonateServiceAccountDelegates?;
    get impersonateServiceAccountDelegates(): string[] | undefined | undefined;
    set impersonateServiceAccountDelegates(value: string[] | undefined | undefined);
    resetImpersonateServiceAccountDelegates(): void;
    get impersonateServiceAccountDelegatesInput(): string[] | undefined;
    private _kmsCustomEndpoint?;
    get kmsCustomEndpoint(): string | undefined | undefined;
    set kmsCustomEndpoint(value: string | undefined | undefined);
    resetKmsCustomEndpoint(): void;
    get kmsCustomEndpointInput(): string | undefined;
    private _loggingCustomEndpoint?;
    get loggingCustomEndpoint(): string | undefined | undefined;
    set loggingCustomEndpoint(value: string | undefined | undefined);
    resetLoggingCustomEndpoint(): void;
    get loggingCustomEndpointInput(): string | undefined;
    private _memcacheCustomEndpoint?;
    get memcacheCustomEndpoint(): string | undefined | undefined;
    set memcacheCustomEndpoint(value: string | undefined | undefined);
    resetMemcacheCustomEndpoint(): void;
    get memcacheCustomEndpointInput(): string | undefined;
    private _mlEngineCustomEndpoint?;
    get mlEngineCustomEndpoint(): string | undefined | undefined;
    set mlEngineCustomEndpoint(value: string | undefined | undefined);
    resetMlEngineCustomEndpoint(): void;
    get mlEngineCustomEndpointInput(): string | undefined;
    private _monitoringCustomEndpoint?;
    get monitoringCustomEndpoint(): string | undefined | undefined;
    set monitoringCustomEndpoint(value: string | undefined | undefined);
    resetMonitoringCustomEndpoint(): void;
    get monitoringCustomEndpointInput(): string | undefined;
    private _networkManagementCustomEndpoint?;
    get networkManagementCustomEndpoint(): string | undefined | undefined;
    set networkManagementCustomEndpoint(value: string | undefined | undefined);
    resetNetworkManagementCustomEndpoint(): void;
    get networkManagementCustomEndpointInput(): string | undefined;
    private _networkServicesCustomEndpoint?;
    get networkServicesCustomEndpoint(): string | undefined | undefined;
    set networkServicesCustomEndpoint(value: string | undefined | undefined);
    resetNetworkServicesCustomEndpoint(): void;
    get networkServicesCustomEndpointInput(): string | undefined;
    private _notebooksCustomEndpoint?;
    get notebooksCustomEndpoint(): string | undefined | undefined;
    set notebooksCustomEndpoint(value: string | undefined | undefined);
    resetNotebooksCustomEndpoint(): void;
    get notebooksCustomEndpointInput(): string | undefined;
    private _orgPolicyCustomEndpoint?;
    get orgPolicyCustomEndpoint(): string | undefined | undefined;
    set orgPolicyCustomEndpoint(value: string | undefined | undefined);
    resetOrgPolicyCustomEndpoint(): void;
    get orgPolicyCustomEndpointInput(): string | undefined;
    private _osConfigCustomEndpoint?;
    get osConfigCustomEndpoint(): string | undefined | undefined;
    set osConfigCustomEndpoint(value: string | undefined | undefined);
    resetOsConfigCustomEndpoint(): void;
    get osConfigCustomEndpointInput(): string | undefined;
    private _osLoginCustomEndpoint?;
    get osLoginCustomEndpoint(): string | undefined | undefined;
    set osLoginCustomEndpoint(value: string | undefined | undefined);
    resetOsLoginCustomEndpoint(): void;
    get osLoginCustomEndpointInput(): string | undefined;
    private _privatecaCustomEndpoint?;
    get privatecaCustomEndpoint(): string | undefined | undefined;
    set privatecaCustomEndpoint(value: string | undefined | undefined);
    resetPrivatecaCustomEndpoint(): void;
    get privatecaCustomEndpointInput(): string | undefined;
    private _project?;
    get project(): string | undefined | undefined;
    set project(value: string | undefined | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _pubsubCustomEndpoint?;
    get pubsubCustomEndpoint(): string | undefined | undefined;
    set pubsubCustomEndpoint(value: string | undefined | undefined);
    resetPubsubCustomEndpoint(): void;
    get pubsubCustomEndpointInput(): string | undefined;
    private _pubsubLiteCustomEndpoint?;
    get pubsubLiteCustomEndpoint(): string | undefined | undefined;
    set pubsubLiteCustomEndpoint(value: string | undefined | undefined);
    resetPubsubLiteCustomEndpoint(): void;
    get pubsubLiteCustomEndpointInput(): string | undefined;
    private _redisCustomEndpoint?;
    get redisCustomEndpoint(): string | undefined | undefined;
    set redisCustomEndpoint(value: string | undefined | undefined);
    resetRedisCustomEndpoint(): void;
    get redisCustomEndpointInput(): string | undefined;
    private _region?;
    get region(): string | undefined | undefined;
    set region(value: string | undefined | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _requestReason?;
    get requestReason(): string | undefined | undefined;
    set requestReason(value: string | undefined | undefined);
    resetRequestReason(): void;
    get requestReasonInput(): string | undefined;
    private _requestTimeout?;
    get requestTimeout(): string | undefined | undefined;
    set requestTimeout(value: string | undefined | undefined);
    resetRequestTimeout(): void;
    get requestTimeoutInput(): string | undefined;
    private _resourceManagerCustomEndpoint?;
    get resourceManagerCustomEndpoint(): string | undefined | undefined;
    set resourceManagerCustomEndpoint(value: string | undefined | undefined);
    resetResourceManagerCustomEndpoint(): void;
    get resourceManagerCustomEndpointInput(): string | undefined;
    private _resourceManagerV2CustomEndpoint?;
    get resourceManagerV2CustomEndpoint(): string | undefined | undefined;
    set resourceManagerV2CustomEndpoint(value: string | undefined | undefined);
    resetResourceManagerV2CustomEndpoint(): void;
    get resourceManagerV2CustomEndpointInput(): string | undefined;
    private _runtimeConfigCustomEndpoint?;
    get runtimeConfigCustomEndpoint(): string | undefined | undefined;
    set runtimeConfigCustomEndpoint(value: string | undefined | undefined);
    resetRuntimeConfigCustomEndpoint(): void;
    get runtimeConfigCustomEndpointInput(): string | undefined;
    private _runtimeconfigCustomEndpoint?;
    get runtimeconfigCustomEndpoint(): string | undefined | undefined;
    set runtimeconfigCustomEndpoint(value: string | undefined | undefined);
    resetRuntimeconfigCustomEndpoint(): void;
    get runtimeconfigCustomEndpointInput(): string | undefined;
    private _scopes?;
    get scopes(): string[] | undefined | undefined;
    set scopes(value: string[] | undefined | undefined);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
    private _secretManagerCustomEndpoint?;
    get secretManagerCustomEndpoint(): string | undefined | undefined;
    set secretManagerCustomEndpoint(value: string | undefined | undefined);
    resetSecretManagerCustomEndpoint(): void;
    get secretManagerCustomEndpointInput(): string | undefined;
    private _securityCenterCustomEndpoint?;
    get securityCenterCustomEndpoint(): string | undefined | undefined;
    set securityCenterCustomEndpoint(value: string | undefined | undefined);
    resetSecurityCenterCustomEndpoint(): void;
    get securityCenterCustomEndpointInput(): string | undefined;
    private _serviceManagementCustomEndpoint?;
    get serviceManagementCustomEndpoint(): string | undefined | undefined;
    set serviceManagementCustomEndpoint(value: string | undefined | undefined);
    resetServiceManagementCustomEndpoint(): void;
    get serviceManagementCustomEndpointInput(): string | undefined;
    private _serviceNetworkingCustomEndpoint?;
    get serviceNetworkingCustomEndpoint(): string | undefined | undefined;
    set serviceNetworkingCustomEndpoint(value: string | undefined | undefined);
    resetServiceNetworkingCustomEndpoint(): void;
    get serviceNetworkingCustomEndpointInput(): string | undefined;
    private _serviceUsageCustomEndpoint?;
    get serviceUsageCustomEndpoint(): string | undefined | undefined;
    set serviceUsageCustomEndpoint(value: string | undefined | undefined);
    resetServiceUsageCustomEndpoint(): void;
    get serviceUsageCustomEndpointInput(): string | undefined;
    private _sourceRepoCustomEndpoint?;
    get sourceRepoCustomEndpoint(): string | undefined | undefined;
    set sourceRepoCustomEndpoint(value: string | undefined | undefined);
    resetSourceRepoCustomEndpoint(): void;
    get sourceRepoCustomEndpointInput(): string | undefined;
    private _spannerCustomEndpoint?;
    get spannerCustomEndpoint(): string | undefined | undefined;
    set spannerCustomEndpoint(value: string | undefined | undefined);
    resetSpannerCustomEndpoint(): void;
    get spannerCustomEndpointInput(): string | undefined;
    private _sqlCustomEndpoint?;
    get sqlCustomEndpoint(): string | undefined | undefined;
    set sqlCustomEndpoint(value: string | undefined | undefined);
    resetSqlCustomEndpoint(): void;
    get sqlCustomEndpointInput(): string | undefined;
    private _storageCustomEndpoint?;
    get storageCustomEndpoint(): string | undefined | undefined;
    set storageCustomEndpoint(value: string | undefined | undefined);
    resetStorageCustomEndpoint(): void;
    get storageCustomEndpointInput(): string | undefined;
    private _storageTransferCustomEndpoint?;
    get storageTransferCustomEndpoint(): string | undefined | undefined;
    set storageTransferCustomEndpoint(value: string | undefined | undefined);
    resetStorageTransferCustomEndpoint(): void;
    get storageTransferCustomEndpointInput(): string | undefined;
    private _tagsCustomEndpoint?;
    get tagsCustomEndpoint(): string | undefined | undefined;
    set tagsCustomEndpoint(value: string | undefined | undefined);
    resetTagsCustomEndpoint(): void;
    get tagsCustomEndpointInput(): string | undefined;
    private _tpuCustomEndpoint?;
    get tpuCustomEndpoint(): string | undefined | undefined;
    set tpuCustomEndpoint(value: string | undefined | undefined);
    resetTpuCustomEndpoint(): void;
    get tpuCustomEndpointInput(): string | undefined;
    private _userProjectOverride?;
    get userProjectOverride(): boolean | cdktf.IResolvable | undefined | undefined;
    set userProjectOverride(value: boolean | cdktf.IResolvable | undefined | undefined);
    resetUserProjectOverride(): void;
    get userProjectOverrideInput(): boolean | cdktf.IResolvable | undefined;
    private _vertexAiCustomEndpoint?;
    get vertexAiCustomEndpoint(): string | undefined | undefined;
    set vertexAiCustomEndpoint(value: string | undefined | undefined);
    resetVertexAiCustomEndpoint(): void;
    get vertexAiCustomEndpointInput(): string | undefined;
    private _vpcAccessCustomEndpoint?;
    get vpcAccessCustomEndpoint(): string | undefined | undefined;
    set vpcAccessCustomEndpoint(value: string | undefined | undefined);
    resetVpcAccessCustomEndpoint(): void;
    get vpcAccessCustomEndpointInput(): string | undefined;
    private _workflowsCustomEndpoint?;
    get workflowsCustomEndpoint(): string | undefined | undefined;
    set workflowsCustomEndpoint(value: string | undefined | undefined);
    resetWorkflowsCustomEndpoint(): void;
    get workflowsCustomEndpointInput(): string | undefined;
    private _zone?;
    get zone(): string | undefined | undefined;
    set zone(value: string | undefined | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined | undefined;
    set alias(value: string | undefined | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _batching?;
    get batching(): GoogleProviderBatching | undefined | undefined;
    set batching(value: GoogleProviderBatching | undefined | undefined);
    resetBatching(): void;
    get batchingInput(): GoogleProviderBatching | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
