import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GkeHubMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
     * Labels to apply to this membership.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#labels GkeHubMembership#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The client-provided identifier of the membership.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#membership_id GkeHubMembership#membership_id}
     */
    readonly membershipId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#project GkeHubMembership#project}.
     */
    readonly project?: string;
    /**
     * authority block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#authority GkeHubMembership#authority}
     */
    readonly authority?: GkeHubMembershipAuthority;
    /**
     * endpoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#endpoint GkeHubMembership#endpoint}
     */
    readonly endpoint?: GkeHubMembershipEndpoint;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#timeouts GkeHubMembership#timeouts}
     */
    readonly timeouts?: GkeHubMembershipTimeouts;
}
export interface GkeHubMembershipAuthority {
    /**
     * A JSON Web Token (JWT) issuer URI.
     *
     * 'issuer' must start with 'https://' and // be a valid
     * with length <2000 characters. For example: 'https://container.googleapis.com/v1/projects/my-project/locations/us-west1/clusters/my-cluster' (must be 'locations' rather than 'zones'). If the cluster is provisioned with Terraform, this is '"https://container.googleapis.com/v1/${google_container_cluster.my-cluster.id}"'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#issuer GkeHubMembership#issuer}
     */
    readonly issuer: string;
}
export declare class GkeHubMembershipAuthorityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    get issuerInput(): string | undefined;
}
export interface GkeHubMembershipEndpointGkeCluster {
    /**
     * Self-link of the GCP resource for the GKE cluster.
     *
     * For example: '//container.googleapis.com/projects/my-project/zones/us-west1-a/clusters/my-cluster'.
     * It can be at the most 1000 characters in length. If the cluster is provisioned with Terraform,
     * this can be '"//container.googleapis.com/${google_container_cluster.my-cluster.id}"' or
     * 'google_container_cluster.my-cluster.id'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#resource_link GkeHubMembership#resource_link}
     */
    readonly resourceLink: string;
}
export declare class GkeHubMembershipEndpointGkeClusterOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resourceLink?;
    get resourceLink(): string;
    set resourceLink(value: string);
    get resourceLinkInput(): string | undefined;
}
export interface GkeHubMembershipEndpoint {
    /**
     * gke_cluster block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#gke_cluster GkeHubMembership#gke_cluster}
     */
    readonly gkeCluster?: GkeHubMembershipEndpointGkeCluster;
}
export declare class GkeHubMembershipEndpointOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _gkeCluster?;
    private __gkeClusterOutput;
    get gkeCluster(): GkeHubMembershipEndpointGkeClusterOutputReference;
    putGkeCluster(value: GkeHubMembershipEndpointGkeCluster | undefined): void;
    resetGkeCluster(): void;
    get gkeClusterInput(): GkeHubMembershipEndpointGkeCluster | undefined;
}
export interface GkeHubMembershipTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#create GkeHubMembership#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#delete GkeHubMembership#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html#update GkeHubMembership#update}.
     */
    readonly update?: string;
}
export declare class GkeHubMembershipTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html google_gke_hub_membership}.
 */
export declare class GkeHubMembership extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/gke_hub_membership.html google_gke_hub_membership} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: GkeHubMembershipConfig);
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _membershipId?;
    get membershipId(): string;
    set membershipId(value: string);
    get membershipIdInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _authority?;
    private __authorityOutput;
    get authority(): GkeHubMembershipAuthorityOutputReference;
    putAuthority(value: GkeHubMembershipAuthority | undefined): void;
    resetAuthority(): void;
    get authorityInput(): GkeHubMembershipAuthority | undefined;
    private _endpoint?;
    private __endpointOutput;
    get endpoint(): GkeHubMembershipEndpointOutputReference;
    putEndpoint(value: GkeHubMembershipEndpoint | undefined): void;
    resetEndpoint(): void;
    get endpointInput(): GkeHubMembershipEndpoint | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): GkeHubMembershipTimeoutsOutputReference;
    putTimeouts(value: GkeHubMembershipTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): GkeHubMembershipTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
