import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GameServicesRealmConfig extends cdktf.TerraformMetaArguments {
    /**
     * Human readable description of the realm.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm.html#description GameServicesRealm#description}
     */
    readonly description?: string;
    /**
     * The labels associated with this realm. Each label is a key-value pair.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm.html#labels GameServicesRealm#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Location of the Realm.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm.html#location GameServicesRealm#location}
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm.html#project GameServicesRealm#project}.
     */
    readonly project?: string;
    /**
     * GCP region of the Realm.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm.html#realm_id GameServicesRealm#realm_id}
     */
    readonly realmId: string;
    /**
     * Required.
     *
     * Time zone where all realm-specific policies are evaluated. The value of
     * this field must be from the IANA time zone database:
     * https://www.iana.org/time-zones.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm.html#time_zone GameServicesRealm#time_zone}
     */
    readonly timeZone: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm.html#timeouts GameServicesRealm#timeouts}
     */
    readonly timeouts?: GameServicesRealmTimeouts;
}
export interface GameServicesRealmTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm.html#create GameServicesRealm#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm.html#delete GameServicesRealm#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_realm.html#update GameServicesRealm#update}.
     */
    readonly update?: string;
}
export declare class GameServicesRealmTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/game_services_realm.html google_game_services_realm}.
 */
export declare class GameServicesRealm extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/game_services_realm.html google_game_services_realm} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: GameServicesRealmConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _realmId?;
    get realmId(): string;
    set realmId(value: string);
    get realmIdInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): GameServicesRealmTimeoutsOutputReference;
    putTimeouts(value: GameServicesRealmTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): GameServicesRealmTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
