import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GameServicesGameServerDeploymentRolloutConfig extends cdktf.TerraformMetaArguments {
    /**
     * This field points to the game server config that is applied by default to all realms and clusters. For example,.
     *
     * 'projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout.html#default_game_server_config GameServicesGameServerDeploymentRollout#default_game_server_config}
     */
    readonly defaultGameServerConfig: string;
    /**
     * The deployment to rollout the new config to. Only 1 rollout must be associated with each deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout.html#deployment_id GameServicesGameServerDeploymentRollout#deployment_id}
     */
    readonly deploymentId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout.html#project GameServicesGameServerDeploymentRollout#project}.
     */
    readonly project?: string;
    /**
     * game_server_config_overrides block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout.html#game_server_config_overrides GameServicesGameServerDeploymentRollout#game_server_config_overrides}
     */
    readonly gameServerConfigOverrides?: GameServicesGameServerDeploymentRolloutGameServerConfigOverrides[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout.html#timeouts GameServicesGameServerDeploymentRollout#timeouts}
     */
    readonly timeouts?: GameServicesGameServerDeploymentRolloutTimeouts;
}
export interface GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector {
    /**
     * List of realms to match against.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout.html#realms GameServicesGameServerDeploymentRollout#realms}
     */
    readonly realms?: string[];
}
export declare class GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _realms?;
    get realms(): string[] | undefined;
    set realms(value: string[] | undefined);
    resetRealms(): void;
    get realmsInput(): string[] | undefined;
}
export interface GameServicesGameServerDeploymentRolloutGameServerConfigOverrides {
    /**
     * Version of the configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout.html#config_version GameServicesGameServerDeploymentRollout#config_version}
     */
    readonly configVersion?: string;
    /**
     * realms_selector block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout.html#realms_selector GameServicesGameServerDeploymentRollout#realms_selector}
     */
    readonly realmsSelector?: GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector;
}
export interface GameServicesGameServerDeploymentRolloutTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout.html#create GameServicesGameServerDeploymentRollout#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout.html#delete GameServicesGameServerDeploymentRollout#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout.html#update GameServicesGameServerDeploymentRollout#update}.
     */
    readonly update?: string;
}
export declare class GameServicesGameServerDeploymentRolloutTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout.html google_game_services_game_server_deployment_rollout}.
 */
export declare class GameServicesGameServerDeploymentRollout extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout.html google_game_services_game_server_deployment_rollout} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: GameServicesGameServerDeploymentRolloutConfig);
    private _defaultGameServerConfig?;
    get defaultGameServerConfig(): string;
    set defaultGameServerConfig(value: string);
    get defaultGameServerConfigInput(): string | undefined;
    private _deploymentId?;
    get deploymentId(): string;
    set deploymentId(value: string);
    get deploymentIdInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _gameServerConfigOverrides?;
    get gameServerConfigOverrides(): GameServicesGameServerDeploymentRolloutGameServerConfigOverrides[] | undefined;
    set gameServerConfigOverrides(value: GameServicesGameServerDeploymentRolloutGameServerConfigOverrides[] | undefined);
    resetGameServerConfigOverrides(): void;
    get gameServerConfigOverridesInput(): GameServicesGameServerDeploymentRolloutGameServerConfigOverrides[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): GameServicesGameServerDeploymentRolloutTimeoutsOutputReference;
    putTimeouts(value: GameServicesGameServerDeploymentRolloutTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): GameServicesGameServerDeploymentRolloutTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
