import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GameServicesGameServerConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * A unique id for the deployment config.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#config_id GameServicesGameServerConfig#config_id}
     */
    readonly configId: string;
    /**
     * A unique id for the deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#deployment_id GameServicesGameServerConfig#deployment_id}
     */
    readonly deploymentId: string;
    /**
     * The description of the game server config.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#description GameServicesGameServerConfig#description}
     */
    readonly description?: string;
    /**
     * The labels associated with this game server config. Each label is a key-value pair.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#labels GameServicesGameServerConfig#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Location of the Deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#location GameServicesGameServerConfig#location}
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#project GameServicesGameServerConfig#project}.
     */
    readonly project?: string;
    /**
     * fleet_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#fleet_configs GameServicesGameServerConfig#fleet_configs}
     */
    readonly fleetConfigs: GameServicesGameServerConfigFleetConfigs[];
    /**
     * scaling_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#scaling_configs GameServicesGameServerConfig#scaling_configs}
     */
    readonly scalingConfigs?: GameServicesGameServerConfigScalingConfigs[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#timeouts GameServicesGameServerConfig#timeouts}
     */
    readonly timeouts?: GameServicesGameServerConfigTimeouts;
}
export interface GameServicesGameServerConfigFleetConfigs {
    /**
     * The fleet spec, which is sent to Agones to configure fleet.
     *
     * The spec can be passed as inline json but it is recommended to use a file reference
     * instead. File references can contain the json or yaml format of the fleet spec. Eg:
     *
     * fleet_spec = jsonencode(yamldecode(file("fleet_configs.yaml")))
     * fleet_spec = file("fleet_configs.json")
     *
     * The format of the spec can be found :
     * 'https://agones.dev/site/docs/reference/fleet/'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#fleet_spec GameServicesGameServerConfig#fleet_spec}
     */
    readonly fleetSpec: string;
    /**
     * The name of the FleetConfig.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#name GameServicesGameServerConfig#name}
     */
    readonly name?: string;
}
export interface GameServicesGameServerConfigScalingConfigsSchedules {
    /**
     * The duration for the cron job event. The duration of the event is effective after the cron job's start time.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#cron_job_duration GameServicesGameServerConfig#cron_job_duration}
     */
    readonly cronJobDuration?: string;
    /**
     * The cron definition of the scheduled event. See https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as defined by the realm.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#cron_spec GameServicesGameServerConfig#cron_spec}
     */
    readonly cronSpec?: string;
    /**
     * The end time of the event.
     *
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#end_time GameServicesGameServerConfig#end_time}
     */
    readonly endTime?: string;
    /**
     * The start time of the event.
     *
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#start_time GameServicesGameServerConfig#start_time}
     */
    readonly startTime?: string;
}
export interface GameServicesGameServerConfigScalingConfigsSelectors {
    /**
     * Set of labels to group by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#labels GameServicesGameServerConfig#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export interface GameServicesGameServerConfigScalingConfigs {
    /**
     * Fleet autoscaler spec, which is sent to Agones. Example spec can be found : https://agones.dev/site/docs/reference/fleetautoscaler/.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#fleet_autoscaler_spec GameServicesGameServerConfig#fleet_autoscaler_spec}
     */
    readonly fleetAutoscalerSpec: string;
    /**
     * The name of the ScalingConfig.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#name GameServicesGameServerConfig#name}
     */
    readonly name: string;
    /**
     * schedules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#schedules GameServicesGameServerConfig#schedules}
     */
    readonly schedules?: GameServicesGameServerConfigScalingConfigsSchedules[];
    /**
     * selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#selectors GameServicesGameServerConfig#selectors}
     */
    readonly selectors?: GameServicesGameServerConfigScalingConfigsSelectors[];
}
export interface GameServicesGameServerConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#create GameServicesGameServerConfig#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#delete GameServicesGameServerConfig#delete}.
     */
    readonly delete?: string;
}
export declare class GameServicesGameServerConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html google_game_services_game_server_config}.
 */
export declare class GameServicesGameServerConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html google_game_services_game_server_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: GameServicesGameServerConfigConfig);
    private _configId?;
    get configId(): string;
    set configId(value: string);
    get configIdInput(): string | undefined;
    private _deploymentId?;
    get deploymentId(): string;
    set deploymentId(value: string);
    get deploymentIdInput(): string | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _fleetConfigs?;
    get fleetConfigs(): GameServicesGameServerConfigFleetConfigs[];
    set fleetConfigs(value: GameServicesGameServerConfigFleetConfigs[]);
    get fleetConfigsInput(): GameServicesGameServerConfigFleetConfigs[] | undefined;
    private _scalingConfigs?;
    get scalingConfigs(): GameServicesGameServerConfigScalingConfigs[] | undefined;
    set scalingConfigs(value: GameServicesGameServerConfigScalingConfigs[] | undefined);
    resetScalingConfigs(): void;
    get scalingConfigsInput(): GameServicesGameServerConfigScalingConfigs[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): GameServicesGameServerConfigTimeoutsOutputReference;
    putTimeouts(value: GameServicesGameServerConfigTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): GameServicesGameServerConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
