import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FolderOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#constraint FolderOrganizationPolicy#constraint}
     */
    readonly constraint: string;
    /**
     * The resource name of the folder to set the policy for. Its format is folders/{folder_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#folder FolderOrganizationPolicy#folder}
     */
    readonly folder: string;
    /**
     * Version of the Policy. Default version is 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#version FolderOrganizationPolicy#version}
     */
    readonly version?: number;
    /**
     * boolean_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#boolean_policy FolderOrganizationPolicy#boolean_policy}
     */
    readonly booleanPolicy?: FolderOrganizationPolicyBooleanPolicy;
    /**
     * list_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#list_policy FolderOrganizationPolicy#list_policy}
     */
    readonly listPolicy?: FolderOrganizationPolicyListPolicy;
    /**
     * restore_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#restore_policy FolderOrganizationPolicy#restore_policy}
     */
    readonly restorePolicy?: FolderOrganizationPolicyRestorePolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#timeouts FolderOrganizationPolicy#timeouts}
     */
    readonly timeouts?: FolderOrganizationPolicyTimeouts;
}
export interface FolderOrganizationPolicyBooleanPolicy {
    /**
     * If true, then the Policy is enforced. If false, then any configuration is acceptable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#enforced FolderOrganizationPolicy#enforced}
     */
    readonly enforced: boolean | cdktf.IResolvable;
}
export declare class FolderOrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enforced?;
    get enforced(): boolean | cdktf.IResolvable;
    set enforced(value: boolean | cdktf.IResolvable);
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface FolderOrganizationPolicyListPolicyAllow {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#all FolderOrganizationPolicy#all}
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#values FolderOrganizationPolicy#values}
     */
    readonly values?: string[];
}
export declare class FolderOrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _all?;
    get all(): boolean | cdktf.IResolvable | undefined;
    set all(value: boolean | cdktf.IResolvable | undefined);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[] | undefined;
    set values(value: string[] | undefined);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface FolderOrganizationPolicyListPolicyDeny {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#all FolderOrganizationPolicy#all}
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#values FolderOrganizationPolicy#values}
     */
    readonly values?: string[];
}
export declare class FolderOrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _all?;
    get all(): boolean | cdktf.IResolvable | undefined;
    set all(value: boolean | cdktf.IResolvable | undefined);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[] | undefined;
    set values(value: string[] | undefined);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface FolderOrganizationPolicyListPolicy {
    /**
     * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#inherit_from_parent FolderOrganizationPolicy#inherit_from_parent}
     */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
     * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#suggested_value FolderOrganizationPolicy#suggested_value}
     */
    readonly suggestedValue?: string;
    /**
     * allow block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#allow FolderOrganizationPolicy#allow}
     */
    readonly allow?: FolderOrganizationPolicyListPolicyAllow;
    /**
     * deny block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#deny FolderOrganizationPolicy#deny}
     */
    readonly deny?: FolderOrganizationPolicyListPolicyDeny;
}
export declare class FolderOrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _inheritFromParent?;
    get inheritFromParent(): boolean | cdktf.IResolvable | undefined;
    set inheritFromParent(value: boolean | cdktf.IResolvable | undefined);
    resetInheritFromParent(): void;
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _suggestedValue?;
    get suggestedValue(): string | undefined;
    set suggestedValue(value: string | undefined);
    resetSuggestedValue(): void;
    get suggestedValueInput(): string | undefined;
    private _allow?;
    private __allowOutput;
    get allow(): FolderOrganizationPolicyListPolicyAllowOutputReference;
    putAllow(value: FolderOrganizationPolicyListPolicyAllow | undefined): void;
    resetAllow(): void;
    get allowInput(): FolderOrganizationPolicyListPolicyAllow | undefined;
    private _deny?;
    private __denyOutput;
    get deny(): FolderOrganizationPolicyListPolicyDenyOutputReference;
    putDeny(value: FolderOrganizationPolicyListPolicyDeny | undefined): void;
    resetDeny(): void;
    get denyInput(): FolderOrganizationPolicyListPolicyDeny | undefined;
}
export interface FolderOrganizationPolicyRestorePolicy {
    /**
     * May only be set to true. If set, then the default Policy is restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#default FolderOrganizationPolicy#default}
     */
    readonly default: boolean | cdktf.IResolvable;
}
export declare class FolderOrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _default?;
    get default(): boolean | cdktf.IResolvable;
    set default(value: boolean | cdktf.IResolvable);
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
}
export interface FolderOrganizationPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#create FolderOrganizationPolicy#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#delete FolderOrganizationPolicy#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#read FolderOrganizationPolicy#read}.
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html#update FolderOrganizationPolicy#update}.
     */
    readonly update?: string;
}
export declare class FolderOrganizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string | undefined;
    set read(value: string | undefined);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html google_folder_organization_policy}.
 */
export declare class FolderOrganizationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy.html google_folder_organization_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: FolderOrganizationPolicyConfig);
    private _constraint?;
    get constraint(): string;
    set constraint(value: string);
    get constraintInput(): string | undefined;
    get etag(): string;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    get id(): string;
    get updateTime(): string;
    private _version?;
    get version(): number | undefined;
    set version(value: number | undefined);
    resetVersion(): void;
    get versionInput(): number | undefined;
    private _booleanPolicy?;
    private __booleanPolicyOutput;
    get booleanPolicy(): FolderOrganizationPolicyBooleanPolicyOutputReference;
    putBooleanPolicy(value: FolderOrganizationPolicyBooleanPolicy | undefined): void;
    resetBooleanPolicy(): void;
    get booleanPolicyInput(): FolderOrganizationPolicyBooleanPolicy | undefined;
    private _listPolicy?;
    private __listPolicyOutput;
    get listPolicy(): FolderOrganizationPolicyListPolicyOutputReference;
    putListPolicy(value: FolderOrganizationPolicyListPolicy | undefined): void;
    resetListPolicy(): void;
    get listPolicyInput(): FolderOrganizationPolicyListPolicy | undefined;
    private _restorePolicy?;
    private __restorePolicyOutput;
    get restorePolicy(): FolderOrganizationPolicyRestorePolicyOutputReference;
    putRestorePolicy(value: FolderOrganizationPolicyRestorePolicy | undefined): void;
    resetRestorePolicy(): void;
    get restorePolicyInput(): FolderOrganizationPolicyRestorePolicy | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): FolderOrganizationPolicyTimeoutsOutputReference;
    putTimeouts(value: FolderOrganizationPolicyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): FolderOrganizationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
