import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FolderAccessApprovalSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of the folder of the access approval settings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#folder_id FolderAccessApprovalSettings#folder_id}
     */
    readonly folderId: string;
    /**
     * A list of email addresses to which notifications relating to approval requests should be sent.
     *
     * Notifications relating to a resource will be sent to all emails in the settings of ancestor
     * resources of that resource. A maximum of 50 email addresses are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#notification_emails FolderAccessApprovalSettings#notification_emails}
     */
    readonly notificationEmails?: string[];
    /**
     * enrolled_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#enrolled_services FolderAccessApprovalSettings#enrolled_services}
     */
    readonly enrolledServices: FolderAccessApprovalSettingsEnrolledServices[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#timeouts FolderAccessApprovalSettings#timeouts}
     */
    readonly timeouts?: FolderAccessApprovalSettingsTimeouts;
}
export interface FolderAccessApprovalSettingsEnrolledServices {
    /**
     * The product for which Access Approval will be enrolled.
     *
     * Allowed values are listed (case-sensitive):
     * all
     * App Engine
     * BigQuery
     * Cloud Bigtable
     * Cloud Key Management Service
     * Compute Engine
     * Cloud Dataflow
     * Cloud Identity and Access Management
     * Cloud Pub/Sub
     * Cloud Storage
     * Persistent Disk
     *
     * Note: These values are supported as input, but considered a legacy format:
     * all
     * appengine.googleapis.com
     * bigquery.googleapis.com
     * bigtable.googleapis.com
     * cloudkms.googleapis.com
     * compute.googleapis.com
     * dataflow.googleapis.com
     * iam.googleapis.com
     * pubsub.googleapis.com
     * storage.googleapis.com
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#cloud_product FolderAccessApprovalSettings#cloud_product}
     */
    readonly cloudProduct: string;
    /**
     * The enrollment level of the service. Default value: "BLOCK_ALL" Possible values: ["BLOCK_ALL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#enrollment_level FolderAccessApprovalSettings#enrollment_level}
     */
    readonly enrollmentLevel?: string;
}
export interface FolderAccessApprovalSettingsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#create FolderAccessApprovalSettings#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#delete FolderAccessApprovalSettings#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#update FolderAccessApprovalSettings#update}.
     */
    readonly update?: string;
}
export declare class FolderAccessApprovalSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html google_folder_access_approval_settings}.
 */
export declare class FolderAccessApprovalSettings extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html google_folder_access_approval_settings} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: FolderAccessApprovalSettingsConfig);
    get enrolledAncestor(): any;
    private _folderId?;
    get folderId(): string;
    set folderId(value: string);
    get folderIdInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _notificationEmails?;
    get notificationEmails(): string[] | undefined;
    set notificationEmails(value: string[] | undefined);
    resetNotificationEmails(): void;
    get notificationEmailsInput(): string[] | undefined;
    private _enrolledServices?;
    get enrolledServices(): FolderAccessApprovalSettingsEnrolledServices[];
    set enrolledServices(value: FolderAccessApprovalSettingsEnrolledServices[]);
    get enrolledServicesInput(): FolderAccessApprovalSettingsEnrolledServices[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): FolderAccessApprovalSettingsTimeoutsOutputReference;
    putTimeouts(value: FolderAccessApprovalSettingsTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): FolderAccessApprovalSettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
