import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirestoreIndexConfig extends cdktf.TerraformMetaArguments {
    /**
     * The collection being indexed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#collection FirestoreIndex#collection}
     */
    readonly collection: string;
    /**
     * The Firestore database id. Defaults to '"(default)"'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#database FirestoreIndex#database}
     */
    readonly database?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#project FirestoreIndex#project}.
     */
    readonly project?: string;
    /**
     * The scope at which a query is run. Default value: "COLLECTION" Possible values: ["COLLECTION", "COLLECTION_GROUP"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#query_scope FirestoreIndex#query_scope}
     */
    readonly queryScope?: string;
    /**
     * fields block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#fields FirestoreIndex#fields}
     */
    readonly fields: FirestoreIndexFields[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#timeouts FirestoreIndex#timeouts}
     */
    readonly timeouts?: FirestoreIndexTimeouts;
}
export interface FirestoreIndexFields {
    /**
     * Indicates that this field supports operations on arrayValues. Only one of 'order' and 'arrayConfig' can be specified. Possible values: ["CONTAINS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#array_config FirestoreIndex#array_config}
     */
    readonly arrayConfig?: string;
    /**
     * Name of the field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#field_path FirestoreIndex#field_path}
     */
    readonly fieldPath?: string;
    /**
     * Indicates that this field supports ordering by the specified order or comparing using =, <, <=, >, >=.
     *
     * Only one of 'order' and 'arrayConfig' can be specified. Possible values: ["ASCENDING", "DESCENDING"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#order FirestoreIndex#order}
     */
    readonly order?: string;
}
export interface FirestoreIndexTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#create FirestoreIndex#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html#delete FirestoreIndex#delete}.
     */
    readonly delete?: string;
}
export declare class FirestoreIndexTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html google_firestore_index}.
 */
export declare class FirestoreIndex extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/firestore_index.html google_firestore_index} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: FirestoreIndexConfig);
    private _collection?;
    get collection(): string;
    set collection(value: string);
    get collectionInput(): string | undefined;
    private _database?;
    get database(): string | undefined;
    set database(value: string | undefined);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _queryScope?;
    get queryScope(): string | undefined;
    set queryScope(value: string | undefined);
    resetQueryScope(): void;
    get queryScopeInput(): string | undefined;
    private _fields?;
    get fields(): FirestoreIndexFields[];
    set fields(value: FirestoreIndexFields[]);
    get fieldsInput(): FirestoreIndexFields[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): FirestoreIndexTimeoutsOutputReference;
    putTimeouts(value: FirestoreIndexTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): FirestoreIndexTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
