import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FilestoreInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#description FilestoreInstance#description}
     */
    readonly description?: string;
    /**
     * Resource labels to represent user-provided metadata.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#labels FilestoreInstance#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The resource name of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#name FilestoreInstance#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#project FilestoreInstance#project}.
     */
    readonly project?: string;
    /**
     * The service tier of the instance. Possible values: ["TIER_UNSPECIFIED", "STANDARD", "PREMIUM", "BASIC_HDD", "BASIC_SSD", "HIGH_SCALE_SSD"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#tier FilestoreInstance#tier}
     */
    readonly tier: string;
    /**
     * The name of the Filestore zone of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#zone FilestoreInstance#zone}
     */
    readonly zone: string;
    /**
     * file_shares block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#file_shares FilestoreInstance#file_shares}
     */
    readonly fileShares: FilestoreInstanceFileShares;
    /**
     * networks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#networks FilestoreInstance#networks}
     */
    readonly networks: FilestoreInstanceNetworks[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#timeouts FilestoreInstance#timeouts}
     */
    readonly timeouts?: FilestoreInstanceTimeouts;
}
export interface FilestoreInstanceFileShares {
    /**
     * File share capacity in GiB.
     *
     * This must be at least 1024 GiB
     * for the standard tier, or 2560 GiB for the premium tier.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#capacity_gb FilestoreInstance#capacity_gb}
     */
    readonly capacityGb: number;
    /**
     * The name of the fileshare (16 characters or less).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#name FilestoreInstance#name}
     */
    readonly name: string;
}
export declare class FilestoreInstanceFileSharesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _capacityGb?;
    get capacityGb(): number;
    set capacityGb(value: number);
    get capacityGbInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface FilestoreInstanceNetworks {
    /**
     * IP versions for which the instance has IP addresses assigned. Possible values: ["ADDRESS_MODE_UNSPECIFIED", "MODE_IPV4", "MODE_IPV6"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#modes FilestoreInstance#modes}
     */
    readonly modes: string[];
    /**
     * The name of the GCE VPC network to which the instance is connected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#network FilestoreInstance#network}
     */
    readonly network: string;
    /**
     * A /29 CIDR block that identifies the range of IP addresses reserved for this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#reserved_ip_range FilestoreInstance#reserved_ip_range}
     */
    readonly reservedIpRange?: string;
}
export interface FilestoreInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#create FilestoreInstance#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#delete FilestoreInstance#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html#update FilestoreInstance#update}.
     */
    readonly update?: string;
}
export declare class FilestoreInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html google_filestore_instance}.
 */
export declare class FilestoreInstance extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/filestore_instance.html google_filestore_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: FilestoreInstanceConfig);
    get createTime(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _fileShares?;
    private __fileSharesOutput;
    get fileShares(): FilestoreInstanceFileSharesOutputReference;
    putFileShares(value: FilestoreInstanceFileShares): void;
    get fileSharesInput(): FilestoreInstanceFileShares | undefined;
    private _networks?;
    get networks(): FilestoreInstanceNetworks[];
    set networks(value: FilestoreInstanceNetworks[]);
    get networksInput(): FilestoreInstanceNetworks[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): FilestoreInstanceTimeoutsOutputReference;
    putTimeouts(value: FilestoreInstanceTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): FilestoreInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
