import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventarcTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Optional. User labels attached to the triggers that can be used to group resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#labels EventarcTrigger#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The location for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#location EventarcTrigger#location}
     */
    readonly location: string;
    /**
     * Required.
     *
     * The resource name of the trigger. Must be unique within the location on the project and must be in `projects/{project}/locations/{location}/triggers/{trigger}` format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#name EventarcTrigger#name}
     */
    readonly name: string;
    /**
     * The project for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#project EventarcTrigger#project}
     */
    readonly project?: string;
    /**
     * Optional.
     *
     * The IAM service account email associated with the trigger. The service account represents the identity of the trigger. The principal who calls this API must have `iam.serviceAccounts.actAs` permission in the service account. See https://cloud.google.com/iam/docs/understanding-service-accounts?hl=en#sa_common for more information. For Cloud Run destinations, this service account is used to generate identity tokens when invoking the service. See https://cloud.google.com/run/docs/triggering/pubsub-push#create-service-account for information on how to invoke authenticated Cloud Run services. In order to create Audit Log triggers, the service account should also have `roles/eventarc.eventReceiver` IAM role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#service_account EventarcTrigger#service_account}
     */
    readonly serviceAccount?: string;
    /**
     * destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#destination EventarcTrigger#destination}
     */
    readonly destination: EventarcTriggerDestination;
    /**
     * matching_criteria block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#matching_criteria EventarcTrigger#matching_criteria}
     */
    readonly matchingCriteria: EventarcTriggerMatchingCriteria[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#timeouts EventarcTrigger#timeouts}
     */
    readonly timeouts?: EventarcTriggerTimeouts;
    /**
     * transport block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#transport EventarcTrigger#transport}
     */
    readonly transport?: EventarcTriggerTransport;
}
export interface EventarcTriggerDestinationCloudRunService {
    /**
     * Optional.
     *
     * The relative path on the Cloud Run service the events should be sent to. The value must conform to the definition of URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#path EventarcTrigger#path}
     */
    readonly path?: string;
    /**
     * Required. The region the Cloud Run service is deployed in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#region EventarcTrigger#region}
     */
    readonly region?: string;
    /**
     * Required.
     *
     * The name of the Cloud Run service being addressed. See https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services. Only services located in the same project of the trigger object can be addressed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#service EventarcTrigger#service}
     */
    readonly service: string;
}
export declare class EventarcTriggerDestinationCloudRunServiceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _path?;
    get path(): string | undefined;
    set path(value: string | undefined);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
}
export interface EventarcTriggerDestination {
    /**
     * The Cloud Function resource name. Only Cloud Functions V2 is supported. Format: projects/{project}/locations/{location}/functions/{function}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#cloud_function EventarcTrigger#cloud_function}
     */
    readonly cloudFunction?: string;
    /**
     * cloud_run_service block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#cloud_run_service EventarcTrigger#cloud_run_service}
     */
    readonly cloudRunService?: EventarcTriggerDestinationCloudRunService;
}
export declare class EventarcTriggerDestinationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cloudFunction?;
    get cloudFunction(): string | undefined;
    set cloudFunction(value: string | undefined);
    resetCloudFunction(): void;
    get cloudFunctionInput(): string | undefined;
    private _cloudRunService?;
    private __cloudRunServiceOutput;
    get cloudRunService(): EventarcTriggerDestinationCloudRunServiceOutputReference;
    putCloudRunService(value: EventarcTriggerDestinationCloudRunService | undefined): void;
    resetCloudRunService(): void;
    get cloudRunServiceInput(): EventarcTriggerDestinationCloudRunService | undefined;
}
export interface EventarcTriggerMatchingCriteria {
    /**
     * Required.
     *
     * The name of a CloudEvents attribute. Currently, only a subset of attributes are supported for filtering. All triggers MUST provide a filter for the 'type' attribute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#attribute EventarcTrigger#attribute}
     */
    readonly attribute: string;
    /**
     * Required. The value for the attribute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#value EventarcTrigger#value}
     */
    readonly value: string;
}
export interface EventarcTriggerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#create EventarcTrigger#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#delete EventarcTrigger#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#update EventarcTrigger#update}.
     */
    readonly update?: string;
}
export declare class EventarcTriggerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface EventarcTriggerTransportPubsub {
    /**
     * Optional.
     *
     * The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{PROJECT_ID}/topics/{TOPIC_NAME You may set an existing topic for triggers of the type google.cloud.pubsub.topic.v1.messagePublished` only. The topic you provide here will not be deleted by Eventarc at trigger deletion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#topic EventarcTrigger#topic}
     */
    readonly topic?: string;
}
export declare class EventarcTriggerTransportPubsubOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _topic?;
    get topic(): string | undefined;
    set topic(value: string | undefined);
    resetTopic(): void;
    get topicInput(): string | undefined;
}
export interface EventarcTriggerTransport {
    /**
     * pubsub block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html#pubsub EventarcTrigger#pubsub}
     */
    readonly pubsub?: EventarcTriggerTransportPubsub;
}
export declare class EventarcTriggerTransportOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _pubsub?;
    private __pubsubOutput;
    get pubsub(): EventarcTriggerTransportPubsubOutputReference;
    putPubsub(value: EventarcTriggerTransportPubsub | undefined): void;
    resetPubsub(): void;
    get pubsubInput(): EventarcTriggerTransportPubsub | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html google_eventarc_trigger}.
 */
export declare class EventarcTrigger extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/eventarc_trigger.html google_eventarc_trigger} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: EventarcTriggerConfig);
    get createTime(): string;
    get etag(): string;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string | undefined;
    set serviceAccount(value: string | undefined);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    private _destination?;
    private __destinationOutput;
    get destination(): EventarcTriggerDestinationOutputReference;
    putDestination(value: EventarcTriggerDestination): void;
    get destinationInput(): EventarcTriggerDestination | undefined;
    private _matchingCriteria?;
    get matchingCriteria(): EventarcTriggerMatchingCriteria[];
    set matchingCriteria(value: EventarcTriggerMatchingCriteria[]);
    get matchingCriteriaInput(): EventarcTriggerMatchingCriteria[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): EventarcTriggerTimeoutsOutputReference;
    putTimeouts(value: EventarcTriggerTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): EventarcTriggerTimeouts | undefined;
    private _transport?;
    private __transportOutput;
    get transport(): EventarcTriggerTransportOutputReference;
    putTransport(value: EventarcTriggerTransport | undefined): void;
    resetTransport(): void;
    get transportInput(): EventarcTriggerTransport | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
