import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EssentialContactsContactConfig extends cdktf.TerraformMetaArguments {
    /**
     * The email address to send notifications to. This does not need to be a Google account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#email EssentialContactsContact#email}
     */
    readonly email: string;
    /**
     * The preferred language for notifications, as a ISO 639-1 language code.
     *
     * See Supported languages for a list of supported languages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#language_tag EssentialContactsContact#language_tag}
     */
    readonly languageTag: string;
    /**
     * The categories of notifications that the contact will receive communications for.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#notification_category_subscriptions EssentialContactsContact#notification_category_subscriptions}
     */
    readonly notificationCategorySubscriptions: string[];
    /**
     * The resource to save this contact for. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#parent EssentialContactsContact#parent}
     */
    readonly parent: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#timeouts EssentialContactsContact#timeouts}
     */
    readonly timeouts?: EssentialContactsContactTimeouts;
}
export interface EssentialContactsContactTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#create EssentialContactsContact#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#delete EssentialContactsContact#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html#update EssentialContactsContact#update}.
     */
    readonly update?: string;
}
export declare class EssentialContactsContactTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html google_essential_contacts_contact}.
 */
export declare class EssentialContactsContact extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/essential_contacts_contact.html google_essential_contacts_contact} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: EssentialContactsContactConfig);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    get id(): string;
    private _languageTag?;
    get languageTag(): string;
    set languageTag(value: string);
    get languageTagInput(): string | undefined;
    get name(): string;
    private _notificationCategorySubscriptions?;
    get notificationCategorySubscriptions(): string[];
    set notificationCategorySubscriptions(value: string[]);
    get notificationCategorySubscriptionsInput(): string[] | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): EssentialContactsContactTimeoutsOutputReference;
    putTimeouts(value: EssentialContactsContactTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): EssentialContactsContactTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
