import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * A textual description field. Defaults to 'Managed by Terraform'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#description DnsPolicy#description}
     */
    readonly description?: string;
    /**
     * Allows networks bound to this policy to receive DNS queries sent by VMs or applications over VPN connections.
     *
     * When enabled, a
     * virtual IP address will be allocated from each of the sub-networks
     * that are bound to this policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#enable_inbound_forwarding DnsPolicy#enable_inbound_forwarding}
     */
    readonly enableInboundForwarding?: boolean | cdktf.IResolvable;
    /**
     * Controls whether logging is enabled for the networks bound to this policy. Defaults to no logging if not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#enable_logging DnsPolicy#enable_logging}
     */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
     * User assigned name for this policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#name DnsPolicy#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#project DnsPolicy#project}.
     */
    readonly project?: string;
    /**
     * alternative_name_server_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#alternative_name_server_config DnsPolicy#alternative_name_server_config}
     */
    readonly alternativeNameServerConfig?: DnsPolicyAlternativeNameServerConfig;
    /**
     * networks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#networks DnsPolicy#networks}
     */
    readonly networks?: DnsPolicyNetworks[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#timeouts DnsPolicy#timeouts}
     */
    readonly timeouts?: DnsPolicyTimeouts;
}
export interface DnsPolicyAlternativeNameServerConfigTargetNameServers {
    /**
     * Forwarding path for this TargetNameServer.
     *
     * If unset or 'default' Cloud DNS will make forwarding
     * decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
     * to the Internet. When set to 'private', Cloud DNS will always send queries through VPC for this target Possible values: ["default", "private"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#forwarding_path DnsPolicy#forwarding_path}
     */
    readonly forwardingPath?: string;
    /**
     * IPv4 address to forward to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#ipv4_address DnsPolicy#ipv4_address}
     */
    readonly ipv4Address: string;
}
export interface DnsPolicyAlternativeNameServerConfig {
    /**
     * target_name_servers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#target_name_servers DnsPolicy#target_name_servers}
     */
    readonly targetNameServers: DnsPolicyAlternativeNameServerConfigTargetNameServers[];
}
export declare class DnsPolicyAlternativeNameServerConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _targetNameServers?;
    get targetNameServers(): DnsPolicyAlternativeNameServerConfigTargetNameServers[];
    set targetNameServers(value: DnsPolicyAlternativeNameServerConfigTargetNameServers[]);
    get targetNameServersInput(): DnsPolicyAlternativeNameServerConfigTargetNameServers[] | undefined;
}
export interface DnsPolicyNetworks {
    /**
     * The id or fully qualified URL of the VPC network to forward queries to.
     *
     * This should be formatted like 'projects/{project}/global/networks/{network}' or
     * 'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#network_url DnsPolicy#network_url}
     */
    readonly networkUrl: string;
}
export interface DnsPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#create DnsPolicy#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#delete DnsPolicy#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html#update DnsPolicy#update}.
     */
    readonly update?: string;
}
export declare class DnsPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html google_dns_policy}.
 */
export declare class DnsPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_policy.html google_dns_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DnsPolicyConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enableInboundForwarding?;
    get enableInboundForwarding(): boolean | cdktf.IResolvable | undefined;
    set enableInboundForwarding(value: boolean | cdktf.IResolvable | undefined);
    resetEnableInboundForwarding(): void;
    get enableInboundForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLogging?;
    get enableLogging(): boolean | cdktf.IResolvable | undefined;
    set enableLogging(value: boolean | cdktf.IResolvable | undefined);
    resetEnableLogging(): void;
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _alternativeNameServerConfig?;
    private __alternativeNameServerConfigOutput;
    get alternativeNameServerConfig(): DnsPolicyAlternativeNameServerConfigOutputReference;
    putAlternativeNameServerConfig(value: DnsPolicyAlternativeNameServerConfig | undefined): void;
    resetAlternativeNameServerConfig(): void;
    get alternativeNameServerConfigInput(): DnsPolicyAlternativeNameServerConfig | undefined;
    private _networks?;
    get networks(): DnsPolicyNetworks[] | undefined;
    set networks(value: DnsPolicyNetworks[] | undefined);
    resetNetworks(): void;
    get networksInput(): DnsPolicyNetworks[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DnsPolicyTimeoutsOutputReference;
    putTimeouts(value: DnsPolicyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DnsPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
