import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsManagedZoneConfig extends cdktf.TerraformMetaArguments {
    /**
     * A textual description field. Defaults to 'Managed by Terraform'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#description DnsManagedZone#description}
     */
    readonly description?: string;
    /**
     * The DNS name of this managed zone, for instance "example.com.".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#dns_name DnsManagedZone#dns_name}
     */
    readonly dnsName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#force_destroy DnsManagedZone#force_destroy}.
     */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
     * A set of key/value label pairs to assign to this ManagedZone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#labels DnsManagedZone#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * User assigned name for this resource. Must be unique within the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#name DnsManagedZone#name}
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#project DnsManagedZone#project}.
     */
    readonly project?: string;
    /**
     * The zone's visibility: public zones are exposed to the Internet, while private zones are visible only to Virtual Private Cloud resources.
     *
     * Default value: "public" Possible values: ["private", "public"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#visibility DnsManagedZone#visibility}
     */
    readonly visibility?: string;
    /**
     * dnssec_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#dnssec_config DnsManagedZone#dnssec_config}
     */
    readonly dnssecConfig?: DnsManagedZoneDnssecConfig;
    /**
     * forwarding_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#forwarding_config DnsManagedZone#forwarding_config}
     */
    readonly forwardingConfig?: DnsManagedZoneForwardingConfig;
    /**
     * peering_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#peering_config DnsManagedZone#peering_config}
     */
    readonly peeringConfig?: DnsManagedZonePeeringConfig;
    /**
     * private_visibility_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#private_visibility_config DnsManagedZone#private_visibility_config}
     */
    readonly privateVisibilityConfig?: DnsManagedZonePrivateVisibilityConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#timeouts DnsManagedZone#timeouts}
     */
    readonly timeouts?: DnsManagedZoneTimeouts;
}
export interface DnsManagedZoneDnssecConfigDefaultKeySpecs {
    /**
     * String mnemonic specifying the DNSSEC algorithm of this key Possible values: ["ecdsap256sha256", "ecdsap384sha384", "rsasha1", "rsasha256", "rsasha512"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#algorithm DnsManagedZone#algorithm}
     */
    readonly algorithm?: string;
    /**
     * Length of the keys in bits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#key_length DnsManagedZone#key_length}
     */
    readonly keyLength?: number;
    /**
     * Specifies whether this is a key signing key (KSK) or a zone signing key (ZSK).
     *
     * Key signing keys have the Secure Entry
     * Point flag set and, when active, will only be used to sign
     * resource record sets of type DNSKEY. Zone signing keys do
     * not have the Secure Entry Point flag set and will be used
     * to sign all other types of resource record sets. Possible values: ["keySigning", "zoneSigning"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#key_type DnsManagedZone#key_type}
     */
    readonly keyType?: string;
    /**
     * Identifies what kind of resource this is.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#kind DnsManagedZone#kind}
     */
    readonly kind?: string;
}
export interface DnsManagedZoneDnssecConfig {
    /**
     * Identifies what kind of resource this is.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#kind DnsManagedZone#kind}
     */
    readonly kind?: string;
    /**
     * Specifies the mechanism used to provide authenticated denial-of-existence responses.
     *
     * non_existence can only be updated when the state is 'off'. Possible values: ["nsec", "nsec3"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#non_existence DnsManagedZone#non_existence}
     */
    readonly nonExistence?: string;
    /**
     * Specifies whether DNSSEC is enabled, and what mode it is in Possible values: ["off", "on", "transfer"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#state DnsManagedZone#state}
     */
    readonly state?: string;
    /**
     * default_key_specs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#default_key_specs DnsManagedZone#default_key_specs}
     */
    readonly defaultKeySpecs?: DnsManagedZoneDnssecConfigDefaultKeySpecs[];
}
export declare class DnsManagedZoneDnssecConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kind?;
    get kind(): string | undefined;
    set kind(value: string | undefined);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _nonExistence?;
    get nonExistence(): string | undefined;
    set nonExistence(value: string | undefined);
    resetNonExistence(): void;
    get nonExistenceInput(): string | undefined;
    private _state?;
    get state(): string | undefined;
    set state(value: string | undefined);
    resetState(): void;
    get stateInput(): string | undefined;
    private _defaultKeySpecs?;
    get defaultKeySpecs(): DnsManagedZoneDnssecConfigDefaultKeySpecs[] | undefined;
    set defaultKeySpecs(value: DnsManagedZoneDnssecConfigDefaultKeySpecs[] | undefined);
    resetDefaultKeySpecs(): void;
    get defaultKeySpecsInput(): DnsManagedZoneDnssecConfigDefaultKeySpecs[] | undefined;
}
export interface DnsManagedZoneForwardingConfigTargetNameServers {
    /**
     * Forwarding path for this TargetNameServer.
     *
     * If unset or 'default' Cloud DNS will make forwarding
     * decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
     * to the Internet. When set to 'private', Cloud DNS will always send queries through VPC for this target Possible values: ["default", "private"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#forwarding_path DnsManagedZone#forwarding_path}
     */
    readonly forwardingPath?: string;
    /**
     * IPv4 address of a target name server.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#ipv4_address DnsManagedZone#ipv4_address}
     */
    readonly ipv4Address: string;
}
export interface DnsManagedZoneForwardingConfig {
    /**
     * target_name_servers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#target_name_servers DnsManagedZone#target_name_servers}
     */
    readonly targetNameServers: DnsManagedZoneForwardingConfigTargetNameServers[];
}
export declare class DnsManagedZoneForwardingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _targetNameServers?;
    get targetNameServers(): DnsManagedZoneForwardingConfigTargetNameServers[];
    set targetNameServers(value: DnsManagedZoneForwardingConfigTargetNameServers[]);
    get targetNameServersInput(): DnsManagedZoneForwardingConfigTargetNameServers[] | undefined;
}
export interface DnsManagedZonePeeringConfigTargetNetwork {
    /**
     * The id or fully qualified URL of the VPC network to forward queries to.
     *
     * This should be formatted like 'projects/{project}/global/networks/{network}' or
     * 'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#network_url DnsManagedZone#network_url}
     */
    readonly networkUrl: string;
}
export declare class DnsManagedZonePeeringConfigTargetNetworkOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _networkUrl?;
    get networkUrl(): string;
    set networkUrl(value: string);
    get networkUrlInput(): string | undefined;
}
export interface DnsManagedZonePeeringConfig {
    /**
     * target_network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#target_network DnsManagedZone#target_network}
     */
    readonly targetNetwork: DnsManagedZonePeeringConfigTargetNetwork;
}
export declare class DnsManagedZonePeeringConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _targetNetwork?;
    private __targetNetworkOutput;
    get targetNetwork(): DnsManagedZonePeeringConfigTargetNetworkOutputReference;
    putTargetNetwork(value: DnsManagedZonePeeringConfigTargetNetwork): void;
    get targetNetworkInput(): DnsManagedZonePeeringConfigTargetNetwork | undefined;
}
export interface DnsManagedZonePrivateVisibilityConfigNetworks {
    /**
     * The id or fully qualified URL of the VPC network to bind to. This should be formatted like 'projects/{project}/global/networks/{network}' or 'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#network_url DnsManagedZone#network_url}
     */
    readonly networkUrl: string;
}
export interface DnsManagedZonePrivateVisibilityConfig {
    /**
     * networks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#networks DnsManagedZone#networks}
     */
    readonly networks: DnsManagedZonePrivateVisibilityConfigNetworks[];
}
export declare class DnsManagedZonePrivateVisibilityConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _networks?;
    get networks(): DnsManagedZonePrivateVisibilityConfigNetworks[];
    set networks(value: DnsManagedZonePrivateVisibilityConfigNetworks[]);
    get networksInput(): DnsManagedZonePrivateVisibilityConfigNetworks[] | undefined;
}
export interface DnsManagedZoneTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#create DnsManagedZone#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#delete DnsManagedZone#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#update DnsManagedZone#update}.
     */
    readonly update?: string;
}
export declare class DnsManagedZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html google_dns_managed_zone}.
 */
export declare class DnsManagedZone extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html google_dns_managed_zone} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DnsManagedZoneConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dnsName?;
    get dnsName(): string;
    set dnsName(value: string);
    get dnsNameInput(): string | undefined;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable | undefined;
    set forceDestroy(value: boolean | cdktf.IResolvable | undefined);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nameServers(): string[];
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _visibility?;
    get visibility(): string | undefined;
    set visibility(value: string | undefined);
    resetVisibility(): void;
    get visibilityInput(): string | undefined;
    private _dnssecConfig?;
    private __dnssecConfigOutput;
    get dnssecConfig(): DnsManagedZoneDnssecConfigOutputReference;
    putDnssecConfig(value: DnsManagedZoneDnssecConfig | undefined): void;
    resetDnssecConfig(): void;
    get dnssecConfigInput(): DnsManagedZoneDnssecConfig | undefined;
    private _forwardingConfig?;
    private __forwardingConfigOutput;
    get forwardingConfig(): DnsManagedZoneForwardingConfigOutputReference;
    putForwardingConfig(value: DnsManagedZoneForwardingConfig | undefined): void;
    resetForwardingConfig(): void;
    get forwardingConfigInput(): DnsManagedZoneForwardingConfig | undefined;
    private _peeringConfig?;
    private __peeringConfigOutput;
    get peeringConfig(): DnsManagedZonePeeringConfigOutputReference;
    putPeeringConfig(value: DnsManagedZonePeeringConfig | undefined): void;
    resetPeeringConfig(): void;
    get peeringConfigInput(): DnsManagedZonePeeringConfig | undefined;
    private _privateVisibilityConfig?;
    private __privateVisibilityConfigOutput;
    get privateVisibilityConfig(): DnsManagedZonePrivateVisibilityConfigOutputReference;
    putPrivateVisibilityConfig(value: DnsManagedZonePrivateVisibilityConfig | undefined): void;
    resetPrivateVisibilityConfig(): void;
    get privateVisibilityConfigInput(): DnsManagedZonePrivateVisibilityConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DnsManagedZoneTimeoutsOutputReference;
    putTimeouts(value: DnsManagedZoneTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DnsManagedZoneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
