import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowFulfillmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The human-readable name of the fulfillment, unique within the agent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#display_name DialogflowFulfillment#display_name}
     */
    readonly displayName: string;
    /**
     * Whether fulfillment is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#enabled DialogflowFulfillment#enabled}
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#project DialogflowFulfillment#project}.
     */
    readonly project?: string;
    /**
     * features block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#features DialogflowFulfillment#features}
     */
    readonly features?: DialogflowFulfillmentFeatures[];
    /**
     * generic_web_service block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#generic_web_service DialogflowFulfillment#generic_web_service}
     */
    readonly genericWebService?: DialogflowFulfillmentGenericWebService;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#timeouts DialogflowFulfillment#timeouts}
     */
    readonly timeouts?: DialogflowFulfillmentTimeouts;
}
export interface DialogflowFulfillmentFeatures {
    /**
     * The type of the feature that enabled for fulfillment. SMALLTALK: Fulfillment is enabled for SmallTalk. Possible values: ["SMALLTALK"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#type DialogflowFulfillment#type}
     */
    readonly type: string;
}
export interface DialogflowFulfillmentGenericWebService {
    /**
     * The password for HTTP Basic authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#password DialogflowFulfillment#password}
     */
    readonly password?: string;
    /**
     * The HTTP request headers to send together with fulfillment requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#request_headers DialogflowFulfillment#request_headers}
     */
    readonly requestHeaders?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The fulfillment URI for receiving POST requests. It must use https protocol.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#uri DialogflowFulfillment#uri}
     */
    readonly uri: string;
    /**
     * The user name for HTTP Basic authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#username DialogflowFulfillment#username}
     */
    readonly username?: string;
}
export declare class DialogflowFulfillmentGenericWebServiceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _requestHeaders?;
    get requestHeaders(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set requestHeaders(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetRequestHeaders(): void;
    get requestHeadersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export interface DialogflowFulfillmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#create DialogflowFulfillment#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#delete DialogflowFulfillment#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#update DialogflowFulfillment#update}.
     */
    readonly update?: string;
}
export declare class DialogflowFulfillmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html google_dialogflow_fulfillment}.
 */
export declare class DialogflowFulfillment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html google_dialogflow_fulfillment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DialogflowFulfillmentConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable | undefined;
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _features?;
    get features(): DialogflowFulfillmentFeatures[] | undefined;
    set features(value: DialogflowFulfillmentFeatures[] | undefined);
    resetFeatures(): void;
    get featuresInput(): DialogflowFulfillmentFeatures[] | undefined;
    private _genericWebService?;
    private __genericWebServiceOutput;
    get genericWebService(): DialogflowFulfillmentGenericWebServiceOutputReference;
    putGenericWebService(value: DialogflowFulfillmentGenericWebService | undefined): void;
    resetGenericWebService(): void;
    get genericWebServiceInput(): DialogflowFulfillmentGenericWebService | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DialogflowFulfillmentTimeoutsOutputReference;
    putTimeouts(value: DialogflowFulfillmentTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DialogflowFulfillmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
