import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowEntityTypeConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of this entity type to be displayed on the console.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#display_name DialogflowEntityType#display_name}
     */
    readonly displayName: string;
    /**
     * Enables fuzzy entity extraction during classification.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#enable_fuzzy_extraction DialogflowEntityType#enable_fuzzy_extraction}
     */
    readonly enableFuzzyExtraction?: boolean | cdktf.IResolvable;
    /**
     * Indicates the kind of entity type.
     *
     * KIND_MAP: Map entity types allow mapping of a group of synonyms to a reference value.
     * KIND_LIST: List entity types contain a set of entries that do not map to reference values. However, list entity
     * types can contain references to other entity types (with or without aliases).
     * KIND_REGEXP: Regexp entity types allow to specify regular expressions in entries values. Possible values: ["KIND_MAP", "KIND_LIST", "KIND_REGEXP"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#kind DialogflowEntityType#kind}
     */
    readonly kind: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#project DialogflowEntityType#project}.
     */
    readonly project?: string;
    /**
     * entities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#entities DialogflowEntityType#entities}
     */
    readonly entities?: DialogflowEntityTypeEntities[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#timeouts DialogflowEntityType#timeouts}
     */
    readonly timeouts?: DialogflowEntityTypeTimeouts;
}
export interface DialogflowEntityTypeEntities {
    /**
     * A collection of value synonyms.
     *
     * For example, if the entity type is vegetable, and value is scallions, a synonym
     * could be green onions.
     * For KIND_LIST entity types:
     * This collection must contain exactly one synonym equal to value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#synonyms DialogflowEntityType#synonyms}
     */
    readonly synonyms: string[];
    /**
     * The primary value associated with this entity entry.
     *
     * For example, if the entity type is vegetable, the value
     * could be scallions.
     * For KIND_MAP entity types:
     * A reference value to be used in place of synonyms.
     * For KIND_LIST entity types:
     * A string that can contain references to other entity types (with or without aliases).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#value DialogflowEntityType#value}
     */
    readonly value: string;
}
export interface DialogflowEntityTypeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#create DialogflowEntityType#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#delete DialogflowEntityType#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html#update DialogflowEntityType#update}.
     */
    readonly update?: string;
}
export declare class DialogflowEntityTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html google_dialogflow_entity_type}.
 */
export declare class DialogflowEntityType extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_entity_type.html google_dialogflow_entity_type} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DialogflowEntityTypeConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enableFuzzyExtraction?;
    get enableFuzzyExtraction(): boolean | cdktf.IResolvable | undefined;
    set enableFuzzyExtraction(value: boolean | cdktf.IResolvable | undefined);
    resetEnableFuzzyExtraction(): void;
    get enableFuzzyExtractionInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _entities?;
    get entities(): DialogflowEntityTypeEntities[] | undefined;
    set entities(value: DialogflowEntityTypeEntities[] | undefined);
    resetEntities(): void;
    get entitiesInput(): DialogflowEntityTypeEntities[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DialogflowEntityTypeTimeoutsOutputReference;
    putTimeouts(value: DialogflowEntityTypeTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DialogflowEntityTypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
