import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowCxPageConfig extends cdktf.TerraformMetaArguments {
    /**
     * The human-readable name of the page, unique within the agent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#display_name DialogflowCxPage#display_name}
     */
    readonly displayName: string;
    /**
     * The language of the following fields in page:.
     *
     * Page.entry_fulfillment.messages
     * Page.entry_fulfillment.conditional_cases
     * Page.event_handlers.trigger_fulfillment.messages
     * Page.event_handlers.trigger_fulfillment.conditional_cases
     * Page.form.parameters.fill_behavior.initial_prompt_fulfillment.messages
     * Page.form.parameters.fill_behavior.initial_prompt_fulfillment.conditional_cases
     * Page.form.parameters.fill_behavior.reprompt_event_handlers.messages
     * Page.form.parameters.fill_behavior.reprompt_event_handlers.conditional_cases
     * Page.transition_routes.trigger_fulfillment.messages
     * Page.transition_routes.trigger_fulfillment.conditional_cases
     * If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#language_code DialogflowCxPage#language_code}
     */
    readonly languageCode?: string;
    /**
     * The flow to create a page for.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#parent DialogflowCxPage#parent}
     */
    readonly parent?: string;
    /**
     * Ordered list of TransitionRouteGroups associated with the page.
     *
     * Transition route groups must be unique within a page.
     * If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route -> page's transition route group -> flow's transition routes.
     * If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence.
     * Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#transition_route_groups DialogflowCxPage#transition_route_groups}
     */
    readonly transitionRouteGroups?: string[];
    /**
     * entry_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#entry_fulfillment DialogflowCxPage#entry_fulfillment}
     */
    readonly entryFulfillment?: DialogflowCxPageEntryFulfillment;
    /**
     * event_handlers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#event_handlers DialogflowCxPage#event_handlers}
     */
    readonly eventHandlers?: DialogflowCxPageEventHandlers[];
    /**
     * form block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#form DialogflowCxPage#form}
     */
    readonly form?: DialogflowCxPageForm;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#timeouts DialogflowCxPage#timeouts}
     */
    readonly timeouts?: DialogflowCxPageTimeouts;
    /**
     * transition_routes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#transition_routes DialogflowCxPage#transition_routes}
     */
    readonly transitionRoutes?: DialogflowCxPageTransitionRoutes[];
}
export interface DialogflowCxPageEntryFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     */
    readonly text?: string[];
}
export declare class DialogflowCxPageEntryFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _text?;
    get text(): string[] | undefined;
    set text(value: string[] | undefined);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface DialogflowCxPageEntryFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     */
    readonly text?: DialogflowCxPageEntryFulfillmentMessagesText;
}
export interface DialogflowCxPageEntryFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#return_partial_responses DialogflowCxPage#return_partial_responses}
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#tag DialogflowCxPage#tag}
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#webhook DialogflowCxPage#webhook}
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#messages DialogflowCxPage#messages}
     */
    readonly messages?: DialogflowCxPageEntryFulfillmentMessages[];
}
export declare class DialogflowCxPageEntryFulfillmentOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable | undefined;
    set returnPartialResponses(value: boolean | cdktf.IResolvable | undefined);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string | undefined;
    set tag(value: string | undefined);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string | undefined;
    set webhook(value: string | undefined);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages?;
    get messages(): DialogflowCxPageEntryFulfillmentMessages[] | undefined;
    set messages(value: DialogflowCxPageEntryFulfillmentMessages[] | undefined);
    resetMessages(): void;
    get messagesInput(): DialogflowCxPageEntryFulfillmentMessages[] | undefined;
}
export interface DialogflowCxPageEventHandlersTriggerFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     */
    readonly text?: string[];
}
export declare class DialogflowCxPageEventHandlersTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _text?;
    get text(): string[] | undefined;
    set text(value: string[] | undefined);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface DialogflowCxPageEventHandlersTriggerFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     */
    readonly text?: DialogflowCxPageEventHandlersTriggerFulfillmentMessagesText;
}
export interface DialogflowCxPageEventHandlersTriggerFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#return_partial_responses DialogflowCxPage#return_partial_responses}
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#tag DialogflowCxPage#tag}
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#webhook DialogflowCxPage#webhook}
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#messages DialogflowCxPage#messages}
     */
    readonly messages?: DialogflowCxPageEventHandlersTriggerFulfillmentMessages[];
}
export declare class DialogflowCxPageEventHandlersTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable | undefined;
    set returnPartialResponses(value: boolean | cdktf.IResolvable | undefined);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string | undefined;
    set tag(value: string | undefined);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string | undefined;
    set webhook(value: string | undefined);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages?;
    get messages(): DialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | undefined;
    set messages(value: DialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | undefined);
    resetMessages(): void;
    get messagesInput(): DialogflowCxPageEventHandlersTriggerFulfillmentMessages[] | undefined;
}
export interface DialogflowCxPageEventHandlers {
    /**
     * The name of the event to handle.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#event DialogflowCxPage#event}
     */
    readonly event?: string;
    /**
     * The target flow to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#target_flow DialogflowCxPage#target_flow}
     */
    readonly targetFlow?: string;
    /**
     * The target page to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#target_page DialogflowCxPage#target_page}
     */
    readonly targetPage?: string;
    /**
     * trigger_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#trigger_fulfillment DialogflowCxPage#trigger_fulfillment}
     */
    readonly triggerFulfillment?: DialogflowCxPageEventHandlersTriggerFulfillment;
}
export interface DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     */
    readonly text?: string[];
}
export declare class DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _text?;
    get text(): string[] | undefined;
    set text(value: string[] | undefined);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     */
    readonly text?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessagesText;
}
export interface DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#return_partial_responses DialogflowCxPage#return_partial_responses}
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#tag DialogflowCxPage#tag}
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#webhook DialogflowCxPage#webhook}
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#messages DialogflowCxPage#messages}
     */
    readonly messages?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[];
}
export declare class DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable | undefined;
    set returnPartialResponses(value: boolean | cdktf.IResolvable | undefined);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string | undefined;
    set tag(value: string | undefined);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string | undefined;
    set webhook(value: string | undefined);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages?;
    get messages(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | undefined;
    set messages(value: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | undefined);
    resetMessages(): void;
    get messagesInput(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentMessages[] | undefined;
}
export interface DialogflowCxPageFormParametersFillBehavior {
    /**
     * initial_prompt_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#initial_prompt_fulfillment DialogflowCxPage#initial_prompt_fulfillment}
     */
    readonly initialPromptFulfillment?: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment;
}
export declare class DialogflowCxPageFormParametersFillBehaviorOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _initialPromptFulfillment?;
    private __initialPromptFulfillmentOutput;
    get initialPromptFulfillment(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillmentOutputReference;
    putInitialPromptFulfillment(value: DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined): void;
    resetInitialPromptFulfillment(): void;
    get initialPromptFulfillmentInput(): DialogflowCxPageFormParametersFillBehaviorInitialPromptFulfillment | undefined;
}
export interface DialogflowCxPageFormParameters {
    /**
     * The human-readable name of the parameter, unique within the form.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#display_name DialogflowCxPage#display_name}
     */
    readonly displayName?: string;
    /**
     * The entity type of the parameter.
     *
     * Format: projects/-/locations/-/agents/-/entityTypes/<System Entity Type ID> for system entity types (for example, projects/-/locations/-/agents/-/entityTypes/sys.date), or projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/entityTypes/<Entity Type ID> for developer entity types.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#entity_type DialogflowCxPage#entity_type}
     */
    readonly entityType?: string;
    /**
     * Indicates whether the parameter represents a list of values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#is_list DialogflowCxPage#is_list}
     */
    readonly isList?: boolean | cdktf.IResolvable;
    /**
     * Indicates whether the parameter content should be redacted in log.
     *
     * If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#redact DialogflowCxPage#redact}
     */
    readonly redact?: boolean | cdktf.IResolvable;
    /**
     * Indicates whether the parameter is required.
     *
     * Optional parameters will not trigger prompts; however, they are filled if the user specifies them.
     * Required parameters must be filled before form filling concludes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#required DialogflowCxPage#required}
     */
    readonly required?: boolean | cdktf.IResolvable;
    /**
     * fill_behavior block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#fill_behavior DialogflowCxPage#fill_behavior}
     */
    readonly fillBehavior?: DialogflowCxPageFormParametersFillBehavior;
}
export interface DialogflowCxPageForm {
    /**
     * parameters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#parameters DialogflowCxPage#parameters}
     */
    readonly parameters?: DialogflowCxPageFormParameters[];
}
export declare class DialogflowCxPageFormOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _parameters?;
    get parameters(): DialogflowCxPageFormParameters[] | undefined;
    set parameters(value: DialogflowCxPageFormParameters[] | undefined);
    resetParameters(): void;
    get parametersInput(): DialogflowCxPageFormParameters[] | undefined;
}
export interface DialogflowCxPageTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#create DialogflowCxPage#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#delete DialogflowCxPage#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#update DialogflowCxPage#update}.
     */
    readonly update?: string;
}
export declare class DialogflowCxPageTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     */
    readonly text?: string[];
}
export declare class DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _text?;
    get text(): string[] | undefined;
    set text(value: string[] | undefined);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#text DialogflowCxPage#text}
     */
    readonly text?: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessagesText;
}
export interface DialogflowCxPageTransitionRoutesTriggerFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#return_partial_responses DialogflowCxPage#return_partial_responses}
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#tag DialogflowCxPage#tag}
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#webhook DialogflowCxPage#webhook}
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#messages DialogflowCxPage#messages}
     */
    readonly messages?: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[];
}
export declare class DialogflowCxPageTransitionRoutesTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable | undefined;
    set returnPartialResponses(value: boolean | cdktf.IResolvable | undefined);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string | undefined;
    set tag(value: string | undefined);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string | undefined;
    set webhook(value: string | undefined);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages?;
    get messages(): DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | undefined;
    set messages(value: DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | undefined);
    resetMessages(): void;
    get messagesInput(): DialogflowCxPageTransitionRoutesTriggerFulfillmentMessages[] | undefined;
}
export interface DialogflowCxPageTransitionRoutes {
    /**
     * The condition to evaluate against form parameters or session parameters.
     *
     * At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#condition DialogflowCxPage#condition}
     */
    readonly condition?: string;
    /**
     * The unique identifier of an Intent.
     *
     * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>. Indicates that the transition can only happen when the given intent is matched. At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#intent DialogflowCxPage#intent}
     */
    readonly intent?: string;
    /**
     * The target flow to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#target_flow DialogflowCxPage#target_flow}
     */
    readonly targetFlow?: string;
    /**
     * The target page to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#target_page DialogflowCxPage#target_page}
     */
    readonly targetPage?: string;
    /**
     * trigger_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html#trigger_fulfillment DialogflowCxPage#trigger_fulfillment}
     */
    readonly triggerFulfillment?: DialogflowCxPageTransitionRoutesTriggerFulfillment;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html google_dialogflow_cx_page}.
 */
export declare class DialogflowCxPage extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_page.html google_dialogflow_cx_page} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DialogflowCxPageConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _languageCode?;
    get languageCode(): string | undefined;
    set languageCode(value: string | undefined);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string | undefined;
    set parent(value: string | undefined);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _transitionRouteGroups?;
    get transitionRouteGroups(): string[] | undefined;
    set transitionRouteGroups(value: string[] | undefined);
    resetTransitionRouteGroups(): void;
    get transitionRouteGroupsInput(): string[] | undefined;
    private _entryFulfillment?;
    private __entryFulfillmentOutput;
    get entryFulfillment(): DialogflowCxPageEntryFulfillmentOutputReference;
    putEntryFulfillment(value: DialogflowCxPageEntryFulfillment | undefined): void;
    resetEntryFulfillment(): void;
    get entryFulfillmentInput(): DialogflowCxPageEntryFulfillment | undefined;
    private _eventHandlers?;
    get eventHandlers(): DialogflowCxPageEventHandlers[] | undefined;
    set eventHandlers(value: DialogflowCxPageEventHandlers[] | undefined);
    resetEventHandlers(): void;
    get eventHandlersInput(): DialogflowCxPageEventHandlers[] | undefined;
    private _form?;
    private __formOutput;
    get form(): DialogflowCxPageFormOutputReference;
    putForm(value: DialogflowCxPageForm | undefined): void;
    resetForm(): void;
    get formInput(): DialogflowCxPageForm | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DialogflowCxPageTimeoutsOutputReference;
    putTimeouts(value: DialogflowCxPageTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DialogflowCxPageTimeouts | undefined;
    private _transitionRoutes?;
    get transitionRoutes(): DialogflowCxPageTransitionRoutes[] | undefined;
    set transitionRoutes(value: DialogflowCxPageTransitionRoutes[] | undefined);
    resetTransitionRoutes(): void;
    get transitionRoutesInput(): DialogflowCxPageTransitionRoutes[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
