import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowCxFlowConfig extends cdktf.TerraformMetaArguments {
    /**
     * The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#description DialogflowCxFlow#description}
     */
    readonly description?: string;
    /**
     * The human-readable name of the flow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#display_name DialogflowCxFlow#display_name}
     */
    readonly displayName: string;
    /**
     * The language of the following fields in flow: Flow.event_handlers.trigger_fulfillment.messages Flow.event_handlers.trigger_fulfillment.conditional_cases Flow.transition_routes.trigger_fulfillment.messages Flow.transition_routes.trigger_fulfillment.conditional_cases If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#language_code DialogflowCxFlow#language_code}
     */
    readonly languageCode?: string;
    /**
     * The agent to create a flow for.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#parent DialogflowCxFlow#parent}
     */
    readonly parent?: string;
    /**
     * A flow's transition route group serve two purposes: They are responsible for matching the user's first utterances in the flow.
     *
     * They are inherited by every page's [transition route groups][Page.transition_route_groups]. Transition route groups defined in the page have higher priority than those defined in the flow.
     * Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#transition_route_groups DialogflowCxFlow#transition_route_groups}
     */
    readonly transitionRouteGroups?: string[];
    /**
     * event_handlers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#event_handlers DialogflowCxFlow#event_handlers}
     */
    readonly eventHandlers?: DialogflowCxFlowEventHandlers[];
    /**
     * nlu_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#nlu_settings DialogflowCxFlow#nlu_settings}
     */
    readonly nluSettings?: DialogflowCxFlowNluSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#timeouts DialogflowCxFlow#timeouts}
     */
    readonly timeouts?: DialogflowCxFlowTimeouts;
    /**
     * transition_routes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#transition_routes DialogflowCxFlow#transition_routes}
     */
    readonly transitionRoutes?: DialogflowCxFlowTransitionRoutes[];
}
export interface DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#text DialogflowCxFlow#text}
     */
    readonly text?: string[];
}
export declare class DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _text?;
    get text(): string[] | undefined;
    set text(value: string[] | undefined);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface DialogflowCxFlowEventHandlersTriggerFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#text DialogflowCxFlow#text}
     */
    readonly text?: DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText;
}
export interface DialogflowCxFlowEventHandlersTriggerFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#return_partial_responses DialogflowCxFlow#return_partial_responses}
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#tag DialogflowCxFlow#tag}
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#webhook DialogflowCxFlow#webhook}
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#messages DialogflowCxFlow#messages}
     */
    readonly messages?: DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[];
}
export declare class DialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable | undefined;
    set returnPartialResponses(value: boolean | cdktf.IResolvable | undefined);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string | undefined;
    set tag(value: string | undefined);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string | undefined;
    set webhook(value: string | undefined);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages?;
    get messages(): DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | undefined;
    set messages(value: DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | undefined);
    resetMessages(): void;
    get messagesInput(): DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | undefined;
}
export interface DialogflowCxFlowEventHandlers {
    /**
     * The name of the event to handle.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#event DialogflowCxFlow#event}
     */
    readonly event?: string;
    /**
     * The target flow to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#target_flow DialogflowCxFlow#target_flow}
     */
    readonly targetFlow?: string;
    /**
     * The target page to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#target_page DialogflowCxFlow#target_page}
     */
    readonly targetPage?: string;
    /**
     * trigger_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#trigger_fulfillment DialogflowCxFlow#trigger_fulfillment}
     */
    readonly triggerFulfillment?: DialogflowCxFlowEventHandlersTriggerFulfillment;
}
export interface DialogflowCxFlowNluSettings {
    /**
     * To filter out false positive results and still get variety in matched natural language inputs for your agent, you can tune the machine learning classification threshold.
     *
     * If the returned score value is less than the threshold value, then a no-match event will be triggered. The score values range from 0.0 (completely uncertain) to 1.0 (completely certain). If set to 0.0, the default of 0.3 is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#classification_threshold DialogflowCxFlow#classification_threshold}
     */
    readonly classificationThreshold?: number;
    /**
     * Indicates NLU model training mode.
     *
     * MODEL_TRAINING_MODE_AUTOMATIC: NLU model training is automatically triggered when a flow gets modified. User can also manually trigger model training in this mode.
     * MODEL_TRAINING_MODE_MANUAL: User needs to manually trigger NLU model training. Best for large flows whose models take long time to train. Possible values: ["MODEL_TRAINING_MODE_AUTOMATIC", "MODEL_TRAINING_MODE_MANUAL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#model_training_mode DialogflowCxFlow#model_training_mode}
     */
    readonly modelTrainingMode?: string;
    /**
     * Indicates the type of NLU model. MODEL_TYPE_STANDARD: Use standard NLU model. MODEL_TYPE_ADVANCED: Use advanced NLU model. Possible values: ["MODEL_TYPE_STANDARD", "MODEL_TYPE_ADVANCED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#model_type DialogflowCxFlow#model_type}
     */
    readonly modelType?: string;
}
export declare class DialogflowCxFlowNluSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _classificationThreshold?;
    get classificationThreshold(): number | undefined;
    set classificationThreshold(value: number | undefined);
    resetClassificationThreshold(): void;
    get classificationThresholdInput(): number | undefined;
    private _modelTrainingMode?;
    get modelTrainingMode(): string | undefined;
    set modelTrainingMode(value: string | undefined);
    resetModelTrainingMode(): void;
    get modelTrainingModeInput(): string | undefined;
    private _modelType?;
    get modelType(): string | undefined;
    set modelType(value: string | undefined);
    resetModelType(): void;
    get modelTypeInput(): string | undefined;
}
export interface DialogflowCxFlowTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#create DialogflowCxFlow#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#delete DialogflowCxFlow#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#update DialogflowCxFlow#update}.
     */
    readonly update?: string;
}
export declare class DialogflowCxFlowTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#text DialogflowCxFlow#text}
     */
    readonly text?: string[];
}
export declare class DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _text?;
    get text(): string[] | undefined;
    set text(value: string[] | undefined);
    resetText(): void;
    get textInput(): string[] | undefined;
}
export interface DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#text DialogflowCxFlow#text}
     */
    readonly text?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText;
}
export interface DialogflowCxFlowTransitionRoutesTriggerFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#return_partial_responses DialogflowCxFlow#return_partial_responses}
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#tag DialogflowCxFlow#tag}
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#webhook DialogflowCxFlow#webhook}
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#messages DialogflowCxFlow#messages}
     */
    readonly messages?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[];
}
export declare class DialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _returnPartialResponses?;
    get returnPartialResponses(): boolean | cdktf.IResolvable | undefined;
    set returnPartialResponses(value: boolean | cdktf.IResolvable | undefined);
    resetReturnPartialResponses(): void;
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string | undefined;
    set tag(value: string | undefined);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _webhook?;
    get webhook(): string | undefined;
    set webhook(value: string | undefined);
    resetWebhook(): void;
    get webhookInput(): string | undefined;
    private _messages?;
    get messages(): DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | undefined;
    set messages(value: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | undefined);
    resetMessages(): void;
    get messagesInput(): DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | undefined;
}
export interface DialogflowCxFlowTransitionRoutes {
    /**
     * The condition to evaluate against form parameters or session parameters.
     *
     * At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#condition DialogflowCxFlow#condition}
     */
    readonly condition?: string;
    /**
     * The unique identifier of an Intent.
     *
     * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>. Indicates that the transition can only happen when the given intent is matched. At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#intent DialogflowCxFlow#intent}
     */
    readonly intent?: string;
    /**
     * The target flow to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#target_flow DialogflowCxFlow#target_flow}
     */
    readonly targetFlow?: string;
    /**
     * The target page to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#target_page DialogflowCxFlow#target_page}
     */
    readonly targetPage?: string;
    /**
     * trigger_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#trigger_fulfillment DialogflowCxFlow#trigger_fulfillment}
     */
    readonly triggerFulfillment?: DialogflowCxFlowTransitionRoutesTriggerFulfillment;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html google_dialogflow_cx_flow}.
 */
export declare class DialogflowCxFlow extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html google_dialogflow_cx_flow} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DialogflowCxFlowConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _languageCode?;
    get languageCode(): string | undefined;
    set languageCode(value: string | undefined);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string | undefined;
    set parent(value: string | undefined);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _transitionRouteGroups?;
    get transitionRouteGroups(): string[] | undefined;
    set transitionRouteGroups(value: string[] | undefined);
    resetTransitionRouteGroups(): void;
    get transitionRouteGroupsInput(): string[] | undefined;
    private _eventHandlers?;
    get eventHandlers(): DialogflowCxFlowEventHandlers[] | undefined;
    set eventHandlers(value: DialogflowCxFlowEventHandlers[] | undefined);
    resetEventHandlers(): void;
    get eventHandlersInput(): DialogflowCxFlowEventHandlers[] | undefined;
    private _nluSettings?;
    private __nluSettingsOutput;
    get nluSettings(): DialogflowCxFlowNluSettingsOutputReference;
    putNluSettings(value: DialogflowCxFlowNluSettings | undefined): void;
    resetNluSettings(): void;
    get nluSettingsInput(): DialogflowCxFlowNluSettings | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DialogflowCxFlowTimeoutsOutputReference;
    putTimeouts(value: DialogflowCxFlowTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DialogflowCxFlowTimeouts | undefined;
    private _transitionRoutes?;
    get transitionRoutes(): DialogflowCxFlowTransitionRoutes[] | undefined;
    set transitionRoutes(value: DialogflowCxFlowTransitionRoutes[] | undefined);
    resetTransitionRoutes(): void;
    get transitionRoutesInput(): DialogflowCxFlowTransitionRoutes[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
