import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowCxEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The human-readable description of the environment. The maximum length is 500 characters. If exceeded, the request is rejected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#description DialogflowCxEnvironment#description}
     */
    readonly description?: string;
    /**
     * The human-readable name of the environment (unique in an agent). Limit of 64 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#display_name DialogflowCxEnvironment#display_name}
     */
    readonly displayName: string;
    /**
     * The Agent to create an Environment for.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#parent DialogflowCxEnvironment#parent}
     */
    readonly parent?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#timeouts DialogflowCxEnvironment#timeouts}
     */
    readonly timeouts?: DialogflowCxEnvironmentTimeouts;
    /**
     * version_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#version_configs DialogflowCxEnvironment#version_configs}
     */
    readonly versionConfigs: DialogflowCxEnvironmentVersionConfigs[];
}
export interface DialogflowCxEnvironmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#create DialogflowCxEnvironment#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#delete DialogflowCxEnvironment#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#update DialogflowCxEnvironment#update}.
     */
    readonly update?: string;
}
export declare class DialogflowCxEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DialogflowCxEnvironmentVersionConfigs {
    /**
     * Format: projects/{{project}}/locations/{{location}}/agents/{{agent}}/flows/{{flow}}/versions/{{version}}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html#version DialogflowCxEnvironment#version}
     */
    readonly version: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html google_dialogflow_cx_environment}.
 */
export declare class DialogflowCxEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_environment.html google_dialogflow_cx_environment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DialogflowCxEnvironmentConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _parent?;
    get parent(): string | undefined;
    set parent(value: string | undefined);
    resetParent(): void;
    get parentInput(): string | undefined;
    get updateTime(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DialogflowCxEnvironmentTimeoutsOutputReference;
    putTimeouts(value: DialogflowCxEnvironmentTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DialogflowCxEnvironmentTimeouts | undefined;
    private _versionConfigs?;
    get versionConfigs(): DialogflowCxEnvironmentVersionConfigs[];
    set versionConfigs(value: DialogflowCxEnvironmentVersionConfigs[]);
    get versionConfigsInput(): DialogflowCxEnvironmentVersionConfigs[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
