import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowCxAgentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The URI of the agent's avatar.
     *
     * Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#avatar_uri DialogflowCxAgent#avatar_uri}
     */
    readonly avatarUri?: string;
    /**
     * The default language of the agent as a language tag.
     *
     * [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be updated after creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#default_language_code DialogflowCxAgent#default_language_code}
     */
    readonly defaultLanguageCode: string;
    /**
     * The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#description DialogflowCxAgent#description}
     */
    readonly description?: string;
    /**
     * The human-readable name of the agent, unique within the location.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#display_name DialogflowCxAgent#display_name}
     */
    readonly displayName: string;
    /**
     * Indicates if automatic spell correction is enabled in detect intent requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#enable_spell_correction DialogflowCxAgent#enable_spell_correction}
     */
    readonly enableSpellCorrection?: boolean | cdktf.IResolvable;
    /**
     * Determines whether this agent should log conversation queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#enable_stackdriver_logging DialogflowCxAgent#enable_stackdriver_logging}
     */
    readonly enableStackdriverLogging?: boolean | cdktf.IResolvable;
    /**
     * The name of the location this agent is located in.
     *
     * ~> **Note:** The first time you are deploying an Agent in your project you must configure location settings.
     * This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
     * Another options is to use global location so you don't need to manually configure location settings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#location DialogflowCxAgent#location}
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#project DialogflowCxAgent#project}.
     */
    readonly project?: string;
    /**
     * Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#security_settings DialogflowCxAgent#security_settings}
     */
    readonly securitySettings?: string;
    /**
     * The list of all languages supported by this agent (except for the default_language_code).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#supported_language_codes DialogflowCxAgent#supported_language_codes}
     */
    readonly supportedLanguageCodes?: string[];
    /**
     * The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#time_zone DialogflowCxAgent#time_zone}
     */
    readonly timeZone: string;
    /**
     * speech_to_text_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#speech_to_text_settings DialogflowCxAgent#speech_to_text_settings}
     */
    readonly speechToTextSettings?: DialogflowCxAgentSpeechToTextSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#timeouts DialogflowCxAgent#timeouts}
     */
    readonly timeouts?: DialogflowCxAgentTimeouts;
}
export interface DialogflowCxAgentSpeechToTextSettings {
    /**
     * Whether to use speech adaptation for speech recognition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#enable_speech_adaptation DialogflowCxAgent#enable_speech_adaptation}
     */
    readonly enableSpeechAdaptation?: boolean | cdktf.IResolvable;
}
export declare class DialogflowCxAgentSpeechToTextSettingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableSpeechAdaptation?;
    get enableSpeechAdaptation(): boolean | cdktf.IResolvable | undefined;
    set enableSpeechAdaptation(value: boolean | cdktf.IResolvable | undefined);
    resetEnableSpeechAdaptation(): void;
    get enableSpeechAdaptationInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DialogflowCxAgentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#create DialogflowCxAgent#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#delete DialogflowCxAgent#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html#update DialogflowCxAgent#update}.
     */
    readonly update?: string;
}
export declare class DialogflowCxAgentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html google_dialogflow_cx_agent}.
 */
export declare class DialogflowCxAgent extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_agent.html google_dialogflow_cx_agent} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DialogflowCxAgentConfig);
    private _avatarUri?;
    get avatarUri(): string | undefined;
    set avatarUri(value: string | undefined);
    resetAvatarUri(): void;
    get avatarUriInput(): string | undefined;
    private _defaultLanguageCode?;
    get defaultLanguageCode(): string;
    set defaultLanguageCode(value: string);
    get defaultLanguageCodeInput(): string | undefined;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enableSpellCorrection?;
    get enableSpellCorrection(): boolean | cdktf.IResolvable | undefined;
    set enableSpellCorrection(value: boolean | cdktf.IResolvable | undefined);
    resetEnableSpellCorrection(): void;
    get enableSpellCorrectionInput(): boolean | cdktf.IResolvable | undefined;
    private _enableStackdriverLogging?;
    get enableStackdriverLogging(): boolean | cdktf.IResolvable | undefined;
    set enableStackdriverLogging(value: boolean | cdktf.IResolvable | undefined);
    resetEnableStackdriverLogging(): void;
    get enableStackdriverLoggingInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _securitySettings?;
    get securitySettings(): string | undefined;
    set securitySettings(value: string | undefined);
    resetSecuritySettings(): void;
    get securitySettingsInput(): string | undefined;
    get startFlow(): string;
    private _supportedLanguageCodes?;
    get supportedLanguageCodes(): string[] | undefined;
    set supportedLanguageCodes(value: string[] | undefined);
    resetSupportedLanguageCodes(): void;
    get supportedLanguageCodesInput(): string[] | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
    private _speechToTextSettings?;
    private __speechToTextSettingsOutput;
    get speechToTextSettings(): DialogflowCxAgentSpeechToTextSettingsOutputReference;
    putSpeechToTextSettings(value: DialogflowCxAgentSpeechToTextSettings | undefined): void;
    resetSpeechToTextSettings(): void;
    get speechToTextSettingsInput(): DialogflowCxAgentSpeechToTextSettings | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DialogflowCxAgentTimeoutsOutputReference;
    putTimeouts(value: DialogflowCxAgentTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DialogflowCxAgentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
