import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DeploymentManagerDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Set the policy to use for creating new resources.
     *
     * Only used on
     * create and update. Valid values are 'CREATE_OR_ACQUIRE' (default) or
     * 'ACQUIRE'. If set to 'ACQUIRE' and resources do not already exist,
     * the deployment will fail. Note that updating this field does not
     * actually affect the deployment, just how it is updated. Default value: "CREATE_OR_ACQUIRE" Possible values: ["ACQUIRE", "CREATE_OR_ACQUIRE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#create_policy DeploymentManagerDeployment#create_policy}
     */
    readonly createPolicy?: string;
    /**
     * Set the policy to use for deleting new resources on update/delete.
     *
     * Valid values are 'DELETE' (default) or 'ABANDON'. If 'DELETE',
     * resource is deleted after removal from Deployment Manager. If
     * 'ABANDON', the resource is only removed from Deployment Manager
     * and is not actually deleted. Note that updating this field does not
     * actually change the deployment, just how it is updated. Default value: "DELETE" Possible values: ["ABANDON", "DELETE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#delete_policy DeploymentManagerDeployment#delete_policy}
     */
    readonly deletePolicy?: string;
    /**
     * Optional user-provided description of deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#description DeploymentManagerDeployment#description}
     */
    readonly description?: string;
    /**
     * Unique name for the deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#name DeploymentManagerDeployment#name}
     */
    readonly name: string;
    /**
     * If set to true, a deployment is created with "shell" resources that are not actually instantiated.
     *
     * This allows you to preview a
     * deployment. It can be updated to false to actually deploy
     * with real resources.
     * ~>**NOTE:** Deployment Manager does not allow update
     * of a deployment in preview (unless updating to preview=false). Thus,
     * Terraform will force-recreate deployments if either preview is updated
     * to true or if other fields are updated while preview is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#preview DeploymentManagerDeployment#preview}
     */
    readonly preview?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#project DeploymentManagerDeployment#project}.
     */
    readonly project?: string;
    /**
     * labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#labels DeploymentManagerDeployment#labels}
     */
    readonly labels?: DeploymentManagerDeploymentLabels[];
    /**
     * target block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#target DeploymentManagerDeployment#target}
     */
    readonly target: DeploymentManagerDeploymentTarget;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#timeouts DeploymentManagerDeployment#timeouts}
     */
    readonly timeouts?: DeploymentManagerDeploymentTimeouts;
}
export interface DeploymentManagerDeploymentLabels {
    /**
     * Key for label.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#key DeploymentManagerDeployment#key}
     */
    readonly key?: string;
    /**
     * Value of label.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#value DeploymentManagerDeployment#value}
     */
    readonly value?: string;
}
export interface DeploymentManagerDeploymentTargetConfig {
    /**
     * The full YAML contents of your configuration file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#content DeploymentManagerDeployment#content}
     */
    readonly content: string;
}
export declare class DeploymentManagerDeploymentTargetConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
}
export interface DeploymentManagerDeploymentTargetImports {
    /**
     * The full contents of the template that you want to import.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#content DeploymentManagerDeployment#content}
     */
    readonly content?: string;
    /**
     * The name of the template to import, as declared in the YAML configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#name DeploymentManagerDeployment#name}
     */
    readonly name?: string;
}
export interface DeploymentManagerDeploymentTarget {
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#config DeploymentManagerDeployment#config}
     */
    readonly config: DeploymentManagerDeploymentTargetConfig;
    /**
     * imports block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#imports DeploymentManagerDeployment#imports}
     */
    readonly imports?: DeploymentManagerDeploymentTargetImports[];
}
export declare class DeploymentManagerDeploymentTargetOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _config?;
    private __configOutput;
    get config(): DeploymentManagerDeploymentTargetConfigOutputReference;
    putConfig(value: DeploymentManagerDeploymentTargetConfig): void;
    get configInput(): DeploymentManagerDeploymentTargetConfig | undefined;
    private _imports?;
    get imports(): DeploymentManagerDeploymentTargetImports[] | undefined;
    set imports(value: DeploymentManagerDeploymentTargetImports[] | undefined);
    resetImports(): void;
    get importsInput(): DeploymentManagerDeploymentTargetImports[] | undefined;
}
export interface DeploymentManagerDeploymentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#create DeploymentManagerDeployment#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#delete DeploymentManagerDeployment#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html#update DeploymentManagerDeployment#update}.
     */
    readonly update?: string;
}
export declare class DeploymentManagerDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html google_deployment_manager_deployment}.
 */
export declare class DeploymentManagerDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/deployment_manager_deployment.html google_deployment_manager_deployment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DeploymentManagerDeploymentConfig);
    private _createPolicy?;
    get createPolicy(): string | undefined;
    set createPolicy(value: string | undefined);
    resetCreatePolicy(): void;
    get createPolicyInput(): string | undefined;
    private _deletePolicy?;
    get deletePolicy(): string | undefined;
    set deletePolicy(value: string | undefined);
    resetDeletePolicy(): void;
    get deletePolicyInput(): string | undefined;
    get deploymentId(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    get manifest(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _preview?;
    get preview(): boolean | cdktf.IResolvable | undefined;
    set preview(value: boolean | cdktf.IResolvable | undefined);
    resetPreview(): void;
    get previewInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _labels?;
    get labels(): DeploymentManagerDeploymentLabels[] | undefined;
    set labels(value: DeploymentManagerDeploymentLabels[] | undefined);
    resetLabels(): void;
    get labelsInput(): DeploymentManagerDeploymentLabels[] | undefined;
    private _target?;
    private __targetOutput;
    get target(): DeploymentManagerDeploymentTargetOutputReference;
    putTarget(value: DeploymentManagerDeploymentTarget): void;
    get targetInput(): DeploymentManagerDeploymentTarget | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DeploymentManagerDeploymentTimeoutsOutputReference;
    putTimeouts(value: DeploymentManagerDeploymentTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DeploymentManagerDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
