import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatastoreIndexConfig extends cdktf.TerraformMetaArguments {
    /**
     * Policy for including ancestors in the index. Default value: "NONE" Possible values: ["NONE", "ALL_ANCESTORS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#ancestor DatastoreIndex#ancestor}
     */
    readonly ancestor?: string;
    /**
     * The entity kind which the index applies to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#kind DatastoreIndex#kind}
     */
    readonly kind: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#project DatastoreIndex#project}.
     */
    readonly project?: string;
    /**
     * properties block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#properties DatastoreIndex#properties}
     */
    readonly properties?: DatastoreIndexProperties[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#timeouts DatastoreIndex#timeouts}
     */
    readonly timeouts?: DatastoreIndexTimeouts;
}
export interface DatastoreIndexProperties {
    /**
     * The direction the index should optimize for sorting. Possible values: ["ASCENDING", "DESCENDING"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#direction DatastoreIndex#direction}
     */
    readonly direction: string;
    /**
     * The property name to index.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#name DatastoreIndex#name}
     */
    readonly name: string;
}
export interface DatastoreIndexTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#create DatastoreIndex#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html#delete DatastoreIndex#delete}.
     */
    readonly delete?: string;
}
export declare class DatastoreIndexTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html google_datastore_index}.
 */
export declare class DatastoreIndex extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/datastore_index.html google_datastore_index} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DatastoreIndexConfig);
    private _ancestor?;
    get ancestor(): string | undefined;
    set ancestor(value: string | undefined);
    resetAncestor(): void;
    get ancestorInput(): string | undefined;
    get id(): string;
    get indexId(): string;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _properties?;
    get properties(): DatastoreIndexProperties[] | undefined;
    set properties(value: DatastoreIndexProperties[] | undefined);
    resetProperties(): void;
    get propertiesInput(): DatastoreIndexProperties[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DatastoreIndexTimeoutsOutputReference;
    putTimeouts(value: DatastoreIndexTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DatastoreIndexTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
