import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataprocWorkflowTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Optional.
     *
     * Timeout duration for the DAG of jobs, expressed in seconds (see [JSON representation of duration](https://developers.google.com/protocol-buffers/docs/proto3#json)). The timeout duration must be from 10 minutes ("600s") to 24 hours ("86400s"). The timer begins when the first job is submitted. If the workflow is running at the end of the timeout period, any remaining jobs are cancelled, the workflow is ended, and if the workflow was running on a [managed cluster](/dataproc/docs/concepts/workflows/using-workflows#configuring_or_selecting_a_cluster), the cluster is deleted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#dag_timeout DataprocWorkflowTemplate#dag_timeout}
     */
    readonly dagTimeout?: string;
    /**
     * Optional.
     *
     * The labels to associate with this template. These labels will be propagated to all jobs and clusters created by the workflow instance. Label **keys** must contain 1 to 63 characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be empty, but, if present, must contain 1 to 63 characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#labels DataprocWorkflowTemplate#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The location for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#location DataprocWorkflowTemplate#location}
     */
    readonly location: string;
    /**
     * Output only.
     *
     * The resource name of the workflow template, as described in https://cloud.google.com/apis/design/resource_names. * For `projects.regions.workflowTemplates`, the resource name of the template has the following format: `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}` * For `projects.locations.workflowTemplates`, the resource name of the template has the following format: `projects/{project_id}/locations/{location}/workflowTemplates/{template_id}`
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#name DataprocWorkflowTemplate#name}
     */
    readonly name: string;
    /**
     * The project for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#project DataprocWorkflowTemplate#project}
     */
    readonly project?: string;
    /**
     * Output only. The current version of this workflow template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#version DataprocWorkflowTemplate#version}
     */
    readonly version?: number;
    /**
     * jobs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jobs DataprocWorkflowTemplate#jobs}
     */
    readonly jobs: DataprocWorkflowTemplateJobs[];
    /**
     * parameters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#parameters DataprocWorkflowTemplate#parameters}
     */
    readonly parameters?: DataprocWorkflowTemplateParameters[];
    /**
     * placement block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#placement DataprocWorkflowTemplate#placement}
     */
    readonly placement: DataprocWorkflowTemplatePlacement;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#timeouts DataprocWorkflowTemplate#timeouts}
     */
    readonly timeouts?: DataprocWorkflowTemplateTimeouts;
}
export interface DataprocWorkflowTemplateJobsHadoopJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocWorkflowTemplateJobsHadoopJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set driverLogLevels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsHadoopJob {
    /**
     * Optional.
     *
     * HCFS URIs of archives to be extracted in the working directory of Hadoop drivers and tasks. Supported file types: .jar, .tar, .tar.gz, .tgz, or .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#archive_uris DataprocWorkflowTemplate#archive_uris}
     */
    readonly archiveUris?: string[];
    /**
     * Optional.
     *
     * The arguments to pass to the driver. Do not include arguments, such as `-libjars` or `-Dfoo=bar`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#args DataprocWorkflowTemplate#args}
     */
    readonly args?: string[];
    /**
     * Optional.
     *
     * HCFS (Hadoop Compatible Filesystem) URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#file_uris DataprocWorkflowTemplate#file_uris}
     */
    readonly fileUris?: string[];
    /**
     * Optional. Jar file URIs to add to the CLASSPATHs of the Hadoop driver and tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
     */
    readonly jarFileUris?: string[];
    /**
     * The name of the driver's main class.
     *
     * The jar file containing the class must be in the default CLASSPATH or specified in `jar_file_uris`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#main_class DataprocWorkflowTemplate#main_class}
     */
    readonly mainClass?: string;
    /**
     * The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#main_jar_file_uri DataprocWorkflowTemplate#main_jar_file_uri}
     */
    readonly mainJarFileUri?: string;
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsHadoopJobLoggingConfig;
}
export declare class DataprocWorkflowTemplateJobsHadoopJobOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _archiveUris?;
    get archiveUris(): string[] | undefined;
    set archiveUris(value: string[] | undefined);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[] | undefined;
    set args(value: string[] | undefined);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[] | undefined;
    set fileUris(value: string[] | undefined);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[] | undefined;
    set jarFileUris(value: string[] | undefined);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainClass?;
    get mainClass(): string | undefined;
    set mainClass(value: string | undefined);
    resetMainClass(): void;
    get mainClassInput(): string | undefined;
    private _mainJarFileUri?;
    get mainJarFileUri(): string | undefined;
    set mainJarFileUri(value: string | undefined);
    resetMainJarFileUri(): void;
    get mainJarFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _loggingConfig?;
    private __loggingConfigOutput;
    get loggingConfig(): DataprocWorkflowTemplateJobsHadoopJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsHadoopJobLoggingConfig | undefined): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsHadoopJobLoggingConfig | undefined;
}
export interface DataprocWorkflowTemplateJobsHiveJobQueryList {
    /**
     * Required.
     *
     * The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#queries DataprocWorkflowTemplate#queries}
     */
    readonly queries: string[];
}
export declare class DataprocWorkflowTemplateJobsHiveJobQueryListOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _queries?;
    get queries(): string[];
    set queries(value: string[]);
    get queriesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplateJobsHiveJob {
    /**
     * Optional.
     *
     * Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#continue_on_failure DataprocWorkflowTemplate#continue_on_failure}
     */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
     * Optional.
     *
     * HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
     */
    readonly jarFileUris?: string[];
    /**
     * Optional.
     *
     * A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The HCFS URI of the script that contains Hive queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_file_uri DataprocWorkflowTemplate#query_file_uri}
     */
    readonly queryFileUri?: string;
    /**
     * Optional. Mapping of query variable names to values (equivalent to the Hive command: `SET name="value";`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#script_variables DataprocWorkflowTemplate#script_variables}
     */
    readonly scriptVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * query_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_list DataprocWorkflowTemplate#query_list}
     */
    readonly queryList?: DataprocWorkflowTemplateJobsHiveJobQueryList;
}
export declare class DataprocWorkflowTemplateJobsHiveJobOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable | undefined;
    set continueOnFailure(value: boolean | cdktf.IResolvable | undefined);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[] | undefined;
    set jarFileUris(value: string[] | undefined);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string | undefined;
    set queryFileUri(value: string | undefined);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set scriptVariables(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetScriptVariables(): void;
    get scriptVariablesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _queryList?;
    private __queryListOutput;
    get queryList(): DataprocWorkflowTemplateJobsHiveJobQueryListOutputReference;
    putQueryList(value: DataprocWorkflowTemplateJobsHiveJobQueryList | undefined): void;
    resetQueryList(): void;
    get queryListInput(): DataprocWorkflowTemplateJobsHiveJobQueryList | undefined;
}
export interface DataprocWorkflowTemplateJobsPigJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocWorkflowTemplateJobsPigJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set driverLogLevels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsPigJobQueryList {
    /**
     * Required.
     *
     * The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#queries DataprocWorkflowTemplate#queries}
     */
    readonly queries: string[];
}
export declare class DataprocWorkflowTemplateJobsPigJobQueryListOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _queries?;
    get queries(): string[];
    set queries(value: string[]);
    get queriesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplateJobsPigJob {
    /**
     * Optional.
     *
     * Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#continue_on_failure DataprocWorkflowTemplate#continue_on_failure}
     */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
     * Optional.
     *
     * HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
     */
    readonly jarFileUris?: string[];
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The HCFS URI of the script that contains the Pig queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_file_uri DataprocWorkflowTemplate#query_file_uri}
     */
    readonly queryFileUri?: string;
    /**
     * Optional. Mapping of query variable names to values (equivalent to the Pig command: `name=[value]`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#script_variables DataprocWorkflowTemplate#script_variables}
     */
    readonly scriptVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsPigJobLoggingConfig;
    /**
     * query_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_list DataprocWorkflowTemplate#query_list}
     */
    readonly queryList?: DataprocWorkflowTemplateJobsPigJobQueryList;
}
export declare class DataprocWorkflowTemplateJobsPigJobOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable | undefined;
    set continueOnFailure(value: boolean | cdktf.IResolvable | undefined);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[] | undefined;
    set jarFileUris(value: string[] | undefined);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string | undefined;
    set queryFileUri(value: string | undefined);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set scriptVariables(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetScriptVariables(): void;
    get scriptVariablesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _loggingConfig?;
    private __loggingConfigOutput;
    get loggingConfig(): DataprocWorkflowTemplateJobsPigJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsPigJobLoggingConfig | undefined): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsPigJobLoggingConfig | undefined;
    private _queryList?;
    private __queryListOutput;
    get queryList(): DataprocWorkflowTemplateJobsPigJobQueryListOutputReference;
    putQueryList(value: DataprocWorkflowTemplateJobsPigJobQueryList | undefined): void;
    resetQueryList(): void;
    get queryListInput(): DataprocWorkflowTemplateJobsPigJobQueryList | undefined;
}
export interface DataprocWorkflowTemplateJobsPrestoJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocWorkflowTemplateJobsPrestoJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set driverLogLevels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsPrestoJobQueryList {
    /**
     * Required.
     *
     * The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#queries DataprocWorkflowTemplate#queries}
     */
    readonly queries: string[];
}
export declare class DataprocWorkflowTemplateJobsPrestoJobQueryListOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _queries?;
    get queries(): string[];
    set queries(value: string[]);
    get queriesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplateJobsPrestoJob {
    /**
     * Optional. Presto client tags to attach to this query.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#client_tags DataprocWorkflowTemplate#client_tags}
     */
    readonly clientTags?: string[];
    /**
     * Optional.
     *
     * Whether to continue executing queries if a query fails. The default value is `false`. Setting to `true` can be useful when executing independent parallel queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#continue_on_failure DataprocWorkflowTemplate#continue_on_failure}
     */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
     * Optional. The format in which query output will be displayed. See the Presto documentation for supported output formats.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#output_format DataprocWorkflowTemplate#output_format}
     */
    readonly outputFormat?: string;
    /**
     * Optional.
     *
     * A mapping of property names to values. Used to set Presto [session properties](https://prestodb.io/docs/current/sql/set-session.html) Equivalent to using the --session flag in the Presto CLI
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The HCFS URI of the script that contains SQL queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_file_uri DataprocWorkflowTemplate#query_file_uri}
     */
    readonly queryFileUri?: string;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsPrestoJobLoggingConfig;
    /**
     * query_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_list DataprocWorkflowTemplate#query_list}
     */
    readonly queryList?: DataprocWorkflowTemplateJobsPrestoJobQueryList;
}
export declare class DataprocWorkflowTemplateJobsPrestoJobOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _clientTags?;
    get clientTags(): string[] | undefined;
    set clientTags(value: string[] | undefined);
    resetClientTags(): void;
    get clientTagsInput(): string[] | undefined;
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable | undefined;
    set continueOnFailure(value: boolean | cdktf.IResolvable | undefined);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _outputFormat?;
    get outputFormat(): string | undefined;
    set outputFormat(value: string | undefined);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string | undefined;
    set queryFileUri(value: string | undefined);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _loggingConfig?;
    private __loggingConfigOutput;
    get loggingConfig(): DataprocWorkflowTemplateJobsPrestoJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsPrestoJobLoggingConfig | undefined): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsPrestoJobLoggingConfig | undefined;
    private _queryList?;
    private __queryListOutput;
    get queryList(): DataprocWorkflowTemplateJobsPrestoJobQueryListOutputReference;
    putQueryList(value: DataprocWorkflowTemplateJobsPrestoJobQueryList | undefined): void;
    resetQueryList(): void;
    get queryListInput(): DataprocWorkflowTemplateJobsPrestoJobQueryList | undefined;
}
export interface DataprocWorkflowTemplateJobsPysparkJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocWorkflowTemplateJobsPysparkJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set driverLogLevels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsPysparkJob {
    /**
     * Optional.
     *
     * HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#archive_uris DataprocWorkflowTemplate#archive_uris}
     */
    readonly archiveUris?: string[];
    /**
     * Optional.
     *
     * The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#args DataprocWorkflowTemplate#args}
     */
    readonly args?: string[];
    /**
     * Optional.
     *
     * HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#file_uris DataprocWorkflowTemplate#file_uris}
     */
    readonly fileUris?: string[];
    /**
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
     */
    readonly jarFileUris?: string[];
    /**
     * Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#main_python_file_uri DataprocWorkflowTemplate#main_python_file_uri}
     */
    readonly mainPythonFileUri: string;
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Optional.
     *
     * HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#python_file_uris DataprocWorkflowTemplate#python_file_uris}
     */
    readonly pythonFileUris?: string[];
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsPysparkJobLoggingConfig;
}
export declare class DataprocWorkflowTemplateJobsPysparkJobOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _archiveUris?;
    get archiveUris(): string[] | undefined;
    set archiveUris(value: string[] | undefined);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[] | undefined;
    set args(value: string[] | undefined);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[] | undefined;
    set fileUris(value: string[] | undefined);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[] | undefined;
    set jarFileUris(value: string[] | undefined);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainPythonFileUri?;
    get mainPythonFileUri(): string;
    set mainPythonFileUri(value: string);
    get mainPythonFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _pythonFileUris?;
    get pythonFileUris(): string[] | undefined;
    set pythonFileUris(value: string[] | undefined);
    resetPythonFileUris(): void;
    get pythonFileUrisInput(): string[] | undefined;
    private _loggingConfig?;
    private __loggingConfigOutput;
    get loggingConfig(): DataprocWorkflowTemplateJobsPysparkJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsPysparkJobLoggingConfig | undefined): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsPysparkJobLoggingConfig | undefined;
}
export interface DataprocWorkflowTemplateJobsScheduling {
    /**
     * Optional.
     *
     * Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window. Maximum value is 10.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#max_failures_per_hour DataprocWorkflowTemplate#max_failures_per_hour}
     */
    readonly maxFailuresPerHour?: number;
    /**
     * Optional.
     *
     * Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#max_failures_total DataprocWorkflowTemplate#max_failures_total}
     */
    readonly maxFailuresTotal?: number;
}
export declare class DataprocWorkflowTemplateJobsSchedulingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxFailuresPerHour?;
    get maxFailuresPerHour(): number | undefined;
    set maxFailuresPerHour(value: number | undefined);
    resetMaxFailuresPerHour(): void;
    get maxFailuresPerHourInput(): number | undefined;
    private _maxFailuresTotal?;
    get maxFailuresTotal(): number | undefined;
    set maxFailuresTotal(value: number | undefined);
    resetMaxFailuresTotal(): void;
    get maxFailuresTotalInput(): number | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocWorkflowTemplateJobsSparkJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set driverLogLevels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkJob {
    /**
     * Optional.
     *
     * HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#archive_uris DataprocWorkflowTemplate#archive_uris}
     */
    readonly archiveUris?: string[];
    /**
     * Optional.
     *
     * The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#args DataprocWorkflowTemplate#args}
     */
    readonly args?: string[];
    /**
     * Optional.
     *
     * HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#file_uris DataprocWorkflowTemplate#file_uris}
     */
    readonly fileUris?: string[];
    /**
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
     */
    readonly jarFileUris?: string[];
    /**
     * The name of the driver's main class.
     *
     * The jar file that contains the class must be in the default CLASSPATH or specified in `jar_file_uris`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#main_class DataprocWorkflowTemplate#main_class}
     */
    readonly mainClass?: string;
    /**
     * The HCFS URI of the jar file that contains the main class.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#main_jar_file_uri DataprocWorkflowTemplate#main_jar_file_uri}
     */
    readonly mainJarFileUri?: string;
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsSparkJobLoggingConfig;
}
export declare class DataprocWorkflowTemplateJobsSparkJobOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _archiveUris?;
    get archiveUris(): string[] | undefined;
    set archiveUris(value: string[] | undefined);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[] | undefined;
    set args(value: string[] | undefined);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[] | undefined;
    set fileUris(value: string[] | undefined);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[] | undefined;
    set jarFileUris(value: string[] | undefined);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainClass?;
    get mainClass(): string | undefined;
    set mainClass(value: string | undefined);
    resetMainClass(): void;
    get mainClassInput(): string | undefined;
    private _mainJarFileUri?;
    get mainJarFileUri(): string | undefined;
    set mainJarFileUri(value: string | undefined);
    resetMainJarFileUri(): void;
    get mainJarFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _loggingConfig?;
    private __loggingConfigOutput;
    get loggingConfig(): DataprocWorkflowTemplateJobsSparkJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsSparkJobLoggingConfig | undefined): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsSparkJobLoggingConfig | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkRJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocWorkflowTemplateJobsSparkRJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set driverLogLevels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkRJob {
    /**
     * Optional.
     *
     * HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#archive_uris DataprocWorkflowTemplate#archive_uris}
     */
    readonly archiveUris?: string[];
    /**
     * Optional.
     *
     * The arguments to pass to the driver. Do not include arguments, such as `--conf`, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#args DataprocWorkflowTemplate#args}
     */
    readonly args?: string[];
    /**
     * Optional.
     *
     * HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#file_uris DataprocWorkflowTemplate#file_uris}
     */
    readonly fileUris?: string[];
    /**
     * Required. The HCFS URI of the main R file to use as the driver. Must be a .R file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#main_r_file_uri DataprocWorkflowTemplate#main_r_file_uri}
     */
    readonly mainRFileUri: string;
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure SparkR. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsSparkRJobLoggingConfig;
}
export declare class DataprocWorkflowTemplateJobsSparkRJobOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _archiveUris?;
    get archiveUris(): string[] | undefined;
    set archiveUris(value: string[] | undefined);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[] | undefined;
    set args(value: string[] | undefined);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[] | undefined;
    set fileUris(value: string[] | undefined);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _mainRFileUri?;
    get mainRFileUri(): string;
    set mainRFileUri(value: string);
    get mainRFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _loggingConfig?;
    private __loggingConfigOutput;
    get loggingConfig(): DataprocWorkflowTemplateJobsSparkRJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsSparkRJobLoggingConfig | undefined): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsSparkRJobLoggingConfig | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig {
    /**
     * The per-package log levels for the driver.
     *
     * This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#driver_log_levels DataprocWorkflowTemplate#driver_log_levels}
     */
    readonly driverLogLevels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set driverLogLevels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetDriverLogLevels(): void;
    get driverLogLevelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkSqlJobQueryList {
    /**
     * Required.
     *
     * The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#queries DataprocWorkflowTemplate#queries}
     */
    readonly queries: string[];
}
export declare class DataprocWorkflowTemplateJobsSparkSqlJobQueryListOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _queries?;
    get queries(): string[];
    set queries(value: string[]);
    get queriesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplateJobsSparkSqlJob {
    /**
     * Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#jar_file_uris DataprocWorkflowTemplate#jar_file_uris}
     */
    readonly jarFileUris?: string[];
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Dataproc API may be overwritten.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The HCFS URI of the script that contains SQL queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_file_uri DataprocWorkflowTemplate#query_file_uri}
     */
    readonly queryFileUri?: string;
    /**
     * Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET `name="value";`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#script_variables DataprocWorkflowTemplate#script_variables}
     */
    readonly scriptVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#logging_config DataprocWorkflowTemplate#logging_config}
     */
    readonly loggingConfig?: DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig;
    /**
     * query_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#query_list DataprocWorkflowTemplate#query_list}
     */
    readonly queryList?: DataprocWorkflowTemplateJobsSparkSqlJobQueryList;
}
export declare class DataprocWorkflowTemplateJobsSparkSqlJobOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _jarFileUris?;
    get jarFileUris(): string[] | undefined;
    set jarFileUris(value: string[] | undefined);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string | undefined;
    set queryFileUri(value: string | undefined);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set scriptVariables(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetScriptVariables(): void;
    get scriptVariablesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _loggingConfig?;
    private __loggingConfigOutput;
    get loggingConfig(): DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig | undefined): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocWorkflowTemplateJobsSparkSqlJobLoggingConfig | undefined;
    private _queryList?;
    private __queryListOutput;
    get queryList(): DataprocWorkflowTemplateJobsSparkSqlJobQueryListOutputReference;
    putQueryList(value: DataprocWorkflowTemplateJobsSparkSqlJobQueryList | undefined): void;
    resetQueryList(): void;
    get queryListInput(): DataprocWorkflowTemplateJobsSparkSqlJobQueryList | undefined;
}
export interface DataprocWorkflowTemplateJobs {
    /**
     * Optional.
     *
     * The labels to associate with this job. Label keys must be between 1 and 63 characters long, and must conform to the following regular expression: p{Ll}p{Lo}{0,62} Label values must be between 1 and 63 characters long, and must conform to the following regular expression: [p{Ll}p{Lo}p{N}_-]{0,63} No more than 32 labels can be associated with a given job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#labels DataprocWorkflowTemplate#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Optional.
     *
     * The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#prerequisite_step_ids DataprocWorkflowTemplate#prerequisite_step_ids}
     */
    readonly prerequisiteStepIds?: string[];
    /**
     * Required.
     *
     * The step id. The id must be unique among all jobs within the template. The step id is used as prefix for job id, as job `goog-dataproc-workflow-step-id` label, and in prerequisiteStepIds field from other steps. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#step_id DataprocWorkflowTemplate#step_id}
     */
    readonly stepId: string;
    /**
     * hadoop_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#hadoop_job DataprocWorkflowTemplate#hadoop_job}
     */
    readonly hadoopJob?: DataprocWorkflowTemplateJobsHadoopJob;
    /**
     * hive_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#hive_job DataprocWorkflowTemplate#hive_job}
     */
    readonly hiveJob?: DataprocWorkflowTemplateJobsHiveJob;
    /**
     * pig_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#pig_job DataprocWorkflowTemplate#pig_job}
     */
    readonly pigJob?: DataprocWorkflowTemplateJobsPigJob;
    /**
     * presto_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#presto_job DataprocWorkflowTemplate#presto_job}
     */
    readonly prestoJob?: DataprocWorkflowTemplateJobsPrestoJob;
    /**
     * pyspark_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#pyspark_job DataprocWorkflowTemplate#pyspark_job}
     */
    readonly pysparkJob?: DataprocWorkflowTemplateJobsPysparkJob;
    /**
     * scheduling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#scheduling DataprocWorkflowTemplate#scheduling}
     */
    readonly scheduling?: DataprocWorkflowTemplateJobsScheduling;
    /**
     * spark_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#spark_job DataprocWorkflowTemplate#spark_job}
     */
    readonly sparkJob?: DataprocWorkflowTemplateJobsSparkJob;
    /**
     * spark_r_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#spark_r_job DataprocWorkflowTemplate#spark_r_job}
     */
    readonly sparkRJob?: DataprocWorkflowTemplateJobsSparkRJob;
    /**
     * spark_sql_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#spark_sql_job DataprocWorkflowTemplate#spark_sql_job}
     */
    readonly sparkSqlJob?: DataprocWorkflowTemplateJobsSparkSqlJob;
}
export interface DataprocWorkflowTemplateParametersValidationRegex {
    /**
     * Required.
     *
     * RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#regexes DataprocWorkflowTemplate#regexes}
     */
    readonly regexes: string[];
}
export declare class DataprocWorkflowTemplateParametersValidationRegexOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _regexes?;
    get regexes(): string[];
    set regexes(value: string[]);
    get regexesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplateParametersValidationValues {
    /**
     * Required. List of allowed values for the parameter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#values DataprocWorkflowTemplate#values}
     */
    readonly values: string[];
}
export declare class DataprocWorkflowTemplateParametersValidationValuesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplateParametersValidation {
    /**
     * regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#regex DataprocWorkflowTemplate#regex}
     */
    readonly regex?: DataprocWorkflowTemplateParametersValidationRegex;
    /**
     * values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#values DataprocWorkflowTemplate#values}
     */
    readonly values?: DataprocWorkflowTemplateParametersValidationValues;
}
export declare class DataprocWorkflowTemplateParametersValidationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _regex?;
    private __regexOutput;
    get regex(): DataprocWorkflowTemplateParametersValidationRegexOutputReference;
    putRegex(value: DataprocWorkflowTemplateParametersValidationRegex | undefined): void;
    resetRegex(): void;
    get regexInput(): DataprocWorkflowTemplateParametersValidationRegex | undefined;
    private _values?;
    private __valuesOutput;
    get values(): DataprocWorkflowTemplateParametersValidationValuesOutputReference;
    putValues(value: DataprocWorkflowTemplateParametersValidationValues | undefined): void;
    resetValues(): void;
    get valuesInput(): DataprocWorkflowTemplateParametersValidationValues | undefined;
}
export interface DataprocWorkflowTemplateParameters {
    /**
     * Optional. Brief description of the parameter. Must not exceed 1024 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#description DataprocWorkflowTemplate#description}
     */
    readonly description?: string;
    /**
     * Required.
     *
     * Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths. A field path is similar in syntax to a google.protobuf.FieldMask. For example, a field path that references the zone field of a workflow template's cluster selector would be specified as `placement.clusterSelector.zone`. Also, field paths can reference fields using the following syntax: * Values in maps can be referenced by key: * labels['key'] * placement.clusterSelector.clusterLabels['key'] * placement.managedCluster.labels['key'] * placement.clusterSelector.clusterLabels['key'] * jobs['step-id'].labels['key'] * Jobs in the jobs list can be referenced by step-id: * jobs['step-id'].hadoopJob.mainJarFileUri * jobs['step-id'].hiveJob.queryFileUri * jobs['step-id'].pySparkJob.mainPythonFileUri * jobs['step-id'].hadoopJob.jarFileUris[0] * jobs['step-id'].hadoopJob.archiveUris[0] * jobs['step-id'].hadoopJob.fileUris[0] * jobs['step-id'].pySparkJob.pythonFileUris[0] * Items in repeated fields can be referenced by a zero-based index: * jobs['step-id'].sparkJob.args[0] * Other examples: * jobs['step-id'].hadoopJob.properties['key'] * jobs['step-id'].hadoopJob.args[0] * jobs['step-id'].hiveJob.scriptVariables['key'] * jobs['step-id'].hadoopJob.mainJarFileUri * placement.clusterSelector.zone It may not be possible to parameterize maps and repeated fields in their entirety since only individual map values and individual items in repeated fields can be referenced. For example, the following field paths are invalid: - placement.clusterSelector.clusterLabels - jobs['step-id'].sparkJob.args
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#fields DataprocWorkflowTemplate#fields}
     */
    readonly fields: string[];
    /**
     * Required.
     *
     * Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#name DataprocWorkflowTemplate#name}
     */
    readonly name: string;
    /**
     * validation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#validation DataprocWorkflowTemplate#validation}
     */
    readonly validation?: DataprocWorkflowTemplateParametersValidation;
}
export interface DataprocWorkflowTemplatePlacementClusterSelector {
    /**
     * Required. The cluster labels. Cluster must have all labels to match.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cluster_labels DataprocWorkflowTemplate#cluster_labels}
     */
    readonly clusterLabels: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Optional.
     *
     * The zone where workflow process executes. This parameter does not affect the selection of the cluster. If unspecified, the zone of the first cluster matching the selector is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#zone DataprocWorkflowTemplate#zone}
     */
    readonly zone?: string;
}
export declare class DataprocWorkflowTemplatePlacementClusterSelectorOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _clusterLabels?;
    get clusterLabels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set clusterLabels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    get clusterLabelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig {
    /**
     * Optional.
     *
     * The autoscaling policy used by the cluster. Only resource names including projectid and location (region) are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]` * `projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]` Note that the policy must be in the same project and Dataproc region.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#policy DataprocWorkflowTemplate#policy}
     */
    readonly policy?: string;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _policy?;
    get policy(): string | undefined;
    set policy(value: string | undefined);
    resetPolicy(): void;
    get policyInput(): string | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig {
    /**
     * Optional. The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#gce_pd_kms_key_name DataprocWorkflowTemplate#gce_pd_kms_key_name}
     */
    readonly gcePdKmsKeyName?: string;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _gcePdKmsKeyName?;
    get gcePdKmsKeyName(): string | undefined;
    set gcePdKmsKeyName(value: string | undefined);
    resetGcePdKmsKeyName(): void;
    get gcePdKmsKeyNameInput(): string | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig {
    /**
     * Optional. If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#enable_http_port_access DataprocWorkflowTemplate#enable_http_port_access}
     */
    readonly enableHttpPortAccess?: boolean | cdktf.IResolvable;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableHttpPortAccess?;
    get enableHttpPortAccess(): boolean | cdktf.IResolvable | undefined;
    set enableHttpPortAccess(value: boolean | cdktf.IResolvable | undefined);
    resetEnableHttpPortAccess(): void;
    get enableHttpPortAccessInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity {
    /**
     * Required.
     *
     * The URI of a sole-tenant [node group resource](https://cloud.google.com/compute/docs/reference/rest/v1/nodeGroups) that the cluster will be created on. A full URL, partial URI, or node group name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1` * `projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1` * `node-group-1`
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#node_group DataprocWorkflowTemplate#node_group}
     */
    readonly nodeGroup: string;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _nodeGroup?;
    get nodeGroup(): string;
    set nodeGroup(value: string);
    get nodeGroupInput(): string | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity {
    /**
     * Optional. Type of reservation to consume Possible values: TYPE_UNSPECIFIED, NO_RESERVATION, ANY_RESERVATION, SPECIFIC_RESERVATION.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#consume_reservation_type DataprocWorkflowTemplate#consume_reservation_type}
     */
    readonly consumeReservationType?: string;
    /**
     * Optional. Corresponds to the label key of reservation resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#key DataprocWorkflowTemplate#key}
     */
    readonly key?: string;
    /**
     * Optional. Corresponds to the label values of reservation resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#values DataprocWorkflowTemplate#values}
     */
    readonly values?: string[];
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _consumeReservationType?;
    get consumeReservationType(): string | undefined;
    set consumeReservationType(value: string | undefined);
    resetConsumeReservationType(): void;
    get consumeReservationTypeInput(): string | undefined;
    private _key?;
    get key(): string | undefined;
    set key(value: string | undefined);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[] | undefined;
    set values(value: string[] | undefined);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig {
    /**
     * Optional.
     *
     * If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This `internal_ip_only` restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#internal_ip_only DataprocWorkflowTemplate#internal_ip_only}
     */
    readonly internalIpOnly?: boolean | cdktf.IResolvable;
    /**
     * The Compute Engine metadata entries to add to all instances (see [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#metadata DataprocWorkflowTemplate#metadata}
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Optional.
     *
     * The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither `network_uri` nor `subnetwork_uri` is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see [Using Subnetworks](https://cloud.google.com/compute/docs/subnetworks) for more information). A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default` * `projects/[project_id]/regions/global/default` * `default`
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#network DataprocWorkflowTemplate#network}
     */
    readonly network?: string;
    /**
     * Optional. The type of IPv6 access for a cluster. Possible values: PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED, INHERIT_FROM_SUBNETWORK, OUTBOUND, BIDIRECTIONAL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#private_ipv6_google_access DataprocWorkflowTemplate#private_ipv6_google_access}
     */
    readonly privateIpv6GoogleAccess?: string;
    /**
     * Optional.
     *
     * The [Dataproc service account](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc) (also see [VM Data Plane identity](https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity)) used by Dataproc cluster VM instances to access Google Cloud Platform services. If not specified, the [Compute Engine default service account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#service_account DataprocWorkflowTemplate#service_account}
     */
    readonly serviceAccount?: string;
    /**
     * Optional.
     *
     * The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: * https://www.googleapis.com/auth/cloud.useraccounts.readonly * https://www.googleapis.com/auth/devstorage.read_write * https://www.googleapis.com/auth/logging.write If no scopes are specified, the following defaults are also provided: * https://www.googleapis.com/auth/bigquery * https://www.googleapis.com/auth/bigtable.admin.table * https://www.googleapis.com/auth/bigtable.data * https://www.googleapis.com/auth/devstorage.full_control
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#service_account_scopes DataprocWorkflowTemplate#service_account_scopes}
     */
    readonly serviceAccountScopes?: string[];
    /**
     * Optional.
     *
     * The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0` * `projects/[project_id]/regions/us-east1/subnetworks/sub0` * `sub0`
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#subnetwork DataprocWorkflowTemplate#subnetwork}
     */
    readonly subnetwork?: string;
    /**
     * The Compute Engine tags to add to all instances (see [Tagging instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#tags DataprocWorkflowTemplate#tags}
     */
    readonly tags?: string[];
    /**
     * Optional.
     *
     * The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]` * `projects/[project_id]/zones/[zone]` * `us-central1-f`
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#zone DataprocWorkflowTemplate#zone}
     */
    readonly zone?: string;
    /**
     * node_group_affinity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#node_group_affinity DataprocWorkflowTemplate#node_group_affinity}
     */
    readonly nodeGroupAffinity?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity;
    /**
     * reservation_affinity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#reservation_affinity DataprocWorkflowTemplate#reservation_affinity}
     */
    readonly reservationAffinity?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _internalIpOnly?;
    get internalIpOnly(): boolean | cdktf.IResolvable | undefined;
    set internalIpOnly(value: boolean | cdktf.IResolvable | undefined);
    resetInternalIpOnly(): void;
    get internalIpOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _network?;
    get network(): string | undefined;
    set network(value: string | undefined);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _privateIpv6GoogleAccess?;
    get privateIpv6GoogleAccess(): string | undefined;
    set privateIpv6GoogleAccess(value: string | undefined);
    resetPrivateIpv6GoogleAccess(): void;
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string | undefined;
    set serviceAccount(value: string | undefined);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _serviceAccountScopes?;
    get serviceAccountScopes(): string[] | undefined;
    set serviceAccountScopes(value: string[] | undefined);
    resetServiceAccountScopes(): void;
    get serviceAccountScopesInput(): string[] | undefined;
    private _subnetwork?;
    get subnetwork(): string | undefined;
    set subnetwork(value: string | undefined);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tags?;
    get tags(): string[] | undefined;
    set tags(value: string[] | undefined);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _nodeGroupAffinity?;
    private __nodeGroupAffinityOutput;
    get nodeGroupAffinity(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinityOutputReference;
    putNodeGroupAffinity(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity | undefined): void;
    resetNodeGroupAffinity(): void;
    get nodeGroupAffinityInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigNodeGroupAffinity | undefined;
    private _reservationAffinity?;
    private __reservationAffinityOutput;
    get reservationAffinity(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinityOutputReference;
    putReservationAffinity(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity | undefined): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigReservationAffinity | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions {
    /**
     * Required. Cloud Storage URI of executable file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#executable_file DataprocWorkflowTemplate#executable_file}
     */
    readonly executableFile?: string;
    /**
     * Optional.
     *
     * Amount of time executable has to complete. Default is 10 minutes (see JSON representation of [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)). Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#execution_timeout DataprocWorkflowTemplate#execution_timeout}
     */
    readonly executionTimeout?: string;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig {
    /**
     * Optional. The time when cluster will be auto-deleted (see JSON representation of [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#auto_delete_time DataprocWorkflowTemplate#auto_delete_time}
     */
    readonly autoDeleteTime?: string;
    /**
     * Optional.
     *
     * The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#auto_delete_ttl DataprocWorkflowTemplate#auto_delete_ttl}
     */
    readonly autoDeleteTtl?: string;
    /**
     * Optional.
     *
     * The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#idle_delete_ttl DataprocWorkflowTemplate#idle_delete_ttl}
     */
    readonly idleDeleteTtl?: string;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _autoDeleteTime?;
    get autoDeleteTime(): string | undefined;
    set autoDeleteTime(value: string | undefined);
    resetAutoDeleteTime(): void;
    get autoDeleteTimeInput(): string | undefined;
    private _autoDeleteTtl?;
    get autoDeleteTtl(): string | undefined;
    set autoDeleteTtl(value: string | undefined);
    resetAutoDeleteTtl(): void;
    get autoDeleteTtlInput(): string | undefined;
    private _idleDeleteTtl?;
    get idleDeleteTtl(): string | undefined;
    set idleDeleteTtl(value: string | undefined);
    resetIdleDeleteTtl(): void;
    get idleDeleteTtlInput(): string | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators {
    /**
     * The number of the accelerator cards of this type exposed to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerator_count DataprocWorkflowTemplate#accelerator_count}
     */
    readonly acceleratorCount?: number;
    /**
     * Full URL, partial URI, or short name of the accelerator type resource to expose to this instance.
     *
     * See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `nvidia-tesla-k80` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerator_type DataprocWorkflowTemplate#accelerator_type}
     */
    readonly acceleratorType?: string;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig {
    /**
     * Optional. Size in GB of the boot disk (default is 500GB).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#boot_disk_size_gb DataprocWorkflowTemplate#boot_disk_size_gb}
     */
    readonly bootDiskSizeGb?: number;
    /**
     * Optional.
     *
     * Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#boot_disk_type DataprocWorkflowTemplate#boot_disk_type}
     */
    readonly bootDiskType?: string;
    /**
     * Optional.
     *
     * Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#num_local_ssds DataprocWorkflowTemplate#num_local_ssds}
     */
    readonly numLocalSsds?: number;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number | undefined;
    set bootDiskSizeGb(value: number | undefined);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string | undefined;
    set bootDiskType(value: string | undefined);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number | undefined;
    set numLocalSsds(value: number | undefined);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig {
    /**
     * Optional.
     *
     * The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#image DataprocWorkflowTemplate#image}
     */
    readonly image?: string;
    /**
     * Optional.
     *
     * The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#machine_type DataprocWorkflowTemplate#machine_type}
     */
    readonly machineType?: string;
    /**
     * Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc -> Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#min_cpu_platform DataprocWorkflowTemplate#min_cpu_platform}
     */
    readonly minCpuPlatform?: string;
    /**
     * Optional.
     *
     * The number of VM instances in the instance group. For [HA cluster](/dataproc/docs/concepts/configuring-clusters/high-availability) [master_config](#FIELDS.master_config) groups, **must be set to 3**. For standard cluster [master_config](#FIELDS.master_config) groups, **must be set to 1**.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#num_instances DataprocWorkflowTemplate#num_instances}
     */
    readonly numInstances?: number;
    /**
     * Optional.
     *
     * Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#preemptibility DataprocWorkflowTemplate#preemptibility}
     */
    readonly preemptibility?: string;
    /**
     * accelerators block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerators DataprocWorkflowTemplate#accelerators}
     */
    readonly accelerators?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[];
    /**
     * disk_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#disk_config DataprocWorkflowTemplate#disk_config}
     */
    readonly diskConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _image?;
    get image(): string | undefined;
    set image(value: string | undefined);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _machineType?;
    get machineType(): string | undefined;
    set machineType(value: string | undefined);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string | undefined;
    set minCpuPlatform(value: string | undefined);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number | undefined;
    set numInstances(value: number | undefined);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    get preemptibility(): string | undefined;
    set preemptibility(value: string | undefined);
    resetPreemptibility(): void;
    get preemptibilityInput(): string | undefined;
    private _accelerators?;
    get accelerators(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | undefined;
    set accelerators(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | undefined);
    resetAccelerators(): void;
    get acceleratorsInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigAccelerators[] | undefined;
    private _diskConfig?;
    private __diskConfigOutput;
    get diskConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig | undefined): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigDiskConfig | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators {
    /**
     * The number of the accelerator cards of this type exposed to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerator_count DataprocWorkflowTemplate#accelerator_count}
     */
    readonly acceleratorCount?: number;
    /**
     * Full URL, partial URI, or short name of the accelerator type resource to expose to this instance.
     *
     * See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `nvidia-tesla-k80` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerator_type DataprocWorkflowTemplate#accelerator_type}
     */
    readonly acceleratorType?: string;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig {
    /**
     * Optional. Size in GB of the boot disk (default is 500GB).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#boot_disk_size_gb DataprocWorkflowTemplate#boot_disk_size_gb}
     */
    readonly bootDiskSizeGb?: number;
    /**
     * Optional.
     *
     * Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#boot_disk_type DataprocWorkflowTemplate#boot_disk_type}
     */
    readonly bootDiskType?: string;
    /**
     * Optional.
     *
     * Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#num_local_ssds DataprocWorkflowTemplate#num_local_ssds}
     */
    readonly numLocalSsds?: number;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number | undefined;
    set bootDiskSizeGb(value: number | undefined);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string | undefined;
    set bootDiskType(value: string | undefined);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number | undefined;
    set numLocalSsds(value: number | undefined);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig {
    /**
     * Optional.
     *
     * The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#image DataprocWorkflowTemplate#image}
     */
    readonly image?: string;
    /**
     * Optional.
     *
     * The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#machine_type DataprocWorkflowTemplate#machine_type}
     */
    readonly machineType?: string;
    /**
     * Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc -> Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#min_cpu_platform DataprocWorkflowTemplate#min_cpu_platform}
     */
    readonly minCpuPlatform?: string;
    /**
     * Optional.
     *
     * The number of VM instances in the instance group. For [HA cluster](/dataproc/docs/concepts/configuring-clusters/high-availability) [master_config](#FIELDS.master_config) groups, **must be set to 3**. For standard cluster [master_config](#FIELDS.master_config) groups, **must be set to 1**.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#num_instances DataprocWorkflowTemplate#num_instances}
     */
    readonly numInstances?: number;
    /**
     * Optional.
     *
     * Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#preemptibility DataprocWorkflowTemplate#preemptibility}
     */
    readonly preemptibility?: string;
    /**
     * accelerators block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerators DataprocWorkflowTemplate#accelerators}
     */
    readonly accelerators?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[];
    /**
     * disk_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#disk_config DataprocWorkflowTemplate#disk_config}
     */
    readonly diskConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _image?;
    get image(): string | undefined;
    set image(value: string | undefined);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _machineType?;
    get machineType(): string | undefined;
    set machineType(value: string | undefined);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string | undefined;
    set minCpuPlatform(value: string | undefined);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number | undefined;
    set numInstances(value: number | undefined);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    get preemptibility(): string | undefined;
    set preemptibility(value: string | undefined);
    resetPreemptibility(): void;
    get preemptibilityInput(): string | undefined;
    private _accelerators?;
    get accelerators(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | undefined;
    set accelerators(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | undefined);
    resetAccelerators(): void;
    get acceleratorsInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigAccelerators[] | undefined;
    private _diskConfig?;
    private __diskConfigOutput;
    get diskConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig | undefined): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigDiskConfig | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig {
    /**
     * Optional. The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cross_realm_trust_admin_server DataprocWorkflowTemplate#cross_realm_trust_admin_server}
     */
    readonly crossRealmTrustAdminServer?: string;
    /**
     * Optional. The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cross_realm_trust_kdc DataprocWorkflowTemplate#cross_realm_trust_kdc}
     */
    readonly crossRealmTrustKdc?: string;
    /**
     * Optional. The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cross_realm_trust_realm DataprocWorkflowTemplate#cross_realm_trust_realm}
     */
    readonly crossRealmTrustRealm?: string;
    /**
     * Optional.
     *
     * The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cross_realm_trust_shared_password DataprocWorkflowTemplate#cross_realm_trust_shared_password}
     */
    readonly crossRealmTrustSharedPassword?: string;
    /**
     * Optional.
     *
     * Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#enable_kerberos DataprocWorkflowTemplate#enable_kerberos}
     */
    readonly enableKerberos?: boolean | cdktf.IResolvable;
    /**
     * Optional. The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#kdc_db_key DataprocWorkflowTemplate#kdc_db_key}
     */
    readonly kdcDbKey?: string;
    /**
     * Optional.
     *
     * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#key_password DataprocWorkflowTemplate#key_password}
     */
    readonly keyPassword?: string;
    /**
     * Optional.
     *
     * The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#keystore DataprocWorkflowTemplate#keystore}
     */
    readonly keystore?: string;
    /**
     * Optional.
     *
     * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#keystore_password DataprocWorkflowTemplate#keystore_password}
     */
    readonly keystorePassword?: string;
    /**
     * Optional. The uri of the KMS key used to encrypt various sensitive files.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#kms_key DataprocWorkflowTemplate#kms_key}
     */
    readonly kmsKey?: string;
    /**
     * Optional.
     *
     * The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#realm DataprocWorkflowTemplate#realm}
     */
    readonly realm?: string;
    /**
     * Optional. The Cloud Storage URI of a KMS encrypted file containing the root principal password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#root_principal_password DataprocWorkflowTemplate#root_principal_password}
     */
    readonly rootPrincipalPassword?: string;
    /**
     * Optional.
     *
     * The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#tgt_lifetime_hours DataprocWorkflowTemplate#tgt_lifetime_hours}
     */
    readonly tgtLifetimeHours?: number;
    /**
     * Optional.
     *
     * The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#truststore DataprocWorkflowTemplate#truststore}
     */
    readonly truststore?: string;
    /**
     * Optional.
     *
     * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#truststore_password DataprocWorkflowTemplate#truststore_password}
     */
    readonly truststorePassword?: string;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _crossRealmTrustAdminServer?;
    get crossRealmTrustAdminServer(): string | undefined;
    set crossRealmTrustAdminServer(value: string | undefined);
    resetCrossRealmTrustAdminServer(): void;
    get crossRealmTrustAdminServerInput(): string | undefined;
    private _crossRealmTrustKdc?;
    get crossRealmTrustKdc(): string | undefined;
    set crossRealmTrustKdc(value: string | undefined);
    resetCrossRealmTrustKdc(): void;
    get crossRealmTrustKdcInput(): string | undefined;
    private _crossRealmTrustRealm?;
    get crossRealmTrustRealm(): string | undefined;
    set crossRealmTrustRealm(value: string | undefined);
    resetCrossRealmTrustRealm(): void;
    get crossRealmTrustRealmInput(): string | undefined;
    private _crossRealmTrustSharedPassword?;
    get crossRealmTrustSharedPassword(): string | undefined;
    set crossRealmTrustSharedPassword(value: string | undefined);
    resetCrossRealmTrustSharedPassword(): void;
    get crossRealmTrustSharedPasswordInput(): string | undefined;
    private _enableKerberos?;
    get enableKerberos(): boolean | cdktf.IResolvable | undefined;
    set enableKerberos(value: boolean | cdktf.IResolvable | undefined);
    resetEnableKerberos(): void;
    get enableKerberosInput(): boolean | cdktf.IResolvable | undefined;
    private _kdcDbKey?;
    get kdcDbKey(): string | undefined;
    set kdcDbKey(value: string | undefined);
    resetKdcDbKey(): void;
    get kdcDbKeyInput(): string | undefined;
    private _keyPassword?;
    get keyPassword(): string | undefined;
    set keyPassword(value: string | undefined);
    resetKeyPassword(): void;
    get keyPasswordInput(): string | undefined;
    private _keystore?;
    get keystore(): string | undefined;
    set keystore(value: string | undefined);
    resetKeystore(): void;
    get keystoreInput(): string | undefined;
    private _keystorePassword?;
    get keystorePassword(): string | undefined;
    set keystorePassword(value: string | undefined);
    resetKeystorePassword(): void;
    get keystorePasswordInput(): string | undefined;
    private _kmsKey?;
    get kmsKey(): string | undefined;
    set kmsKey(value: string | undefined);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _realm?;
    get realm(): string | undefined;
    set realm(value: string | undefined);
    resetRealm(): void;
    get realmInput(): string | undefined;
    private _rootPrincipalPassword?;
    get rootPrincipalPassword(): string | undefined;
    set rootPrincipalPassword(value: string | undefined);
    resetRootPrincipalPassword(): void;
    get rootPrincipalPasswordInput(): string | undefined;
    private _tgtLifetimeHours?;
    get tgtLifetimeHours(): number | undefined;
    set tgtLifetimeHours(value: number | undefined);
    resetTgtLifetimeHours(): void;
    get tgtLifetimeHoursInput(): number | undefined;
    private _truststore?;
    get truststore(): string | undefined;
    set truststore(value: string | undefined);
    resetTruststore(): void;
    get truststoreInput(): string | undefined;
    private _truststorePassword?;
    get truststorePassword(): string | undefined;
    set truststorePassword(value: string | undefined);
    resetTruststorePassword(): void;
    get truststorePasswordInput(): string | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig {
    /**
     * kerberos_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#kerberos_config DataprocWorkflowTemplate#kerberos_config}
     */
    readonly kerberosConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kerberosConfig?;
    private __kerberosConfigOutput;
    get kerberosConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfigOutputReference;
    putKerberosConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig | undefined): void;
    resetKerberosConfig(): void;
    get kerberosConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigKerberosConfig | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig {
    /**
     * Optional.
     *
     * The version of software inside the cluster. It must be one of the supported [Dataproc Versions](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported_dataproc_versions), such as "1.2" (including a subminor version, such as "1.2.29"), or the ["preview" version](https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#image_version DataprocWorkflowTemplate#image_version}
     */
    readonly imageVersion?: string;
    /**
     * Optional. The set of components to activate on the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#optional_components DataprocWorkflowTemplate#optional_components}
     */
    readonly optionalComponents?: string[];
    /**
     * Optional.
     *
     * The properties to set on daemon config files. Property keys are specified in `prefix:property` format, for example `core:hadoop.tmp.dir`. The following are supported prefixes and their mappings: * capacity-scheduler: `capacity-scheduler.xml` * core: `core-site.xml` * distcp: `distcp-default.xml` * hdfs: `hdfs-site.xml` * hive: `hive-site.xml` * mapred: `mapred-site.xml` * pig: `pig.properties` * spark: `spark-defaults.conf` * yarn: `yarn-site.xml` For more information, see [Cluster properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#properties DataprocWorkflowTemplate#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _imageVersion?;
    get imageVersion(): string | undefined;
    set imageVersion(value: string | undefined);
    resetImageVersion(): void;
    get imageVersionInput(): string | undefined;
    private _optionalComponents?;
    get optionalComponents(): string[] | undefined;
    set optionalComponents(value: string[] | undefined);
    resetOptionalComponents(): void;
    get optionalComponentsInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators {
    /**
     * The number of the accelerator cards of this type exposed to this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerator_count DataprocWorkflowTemplate#accelerator_count}
     */
    readonly acceleratorCount?: number;
    /**
     * Full URL, partial URI, or short name of the accelerator type resource to expose to this instance.
     *
     * See [Compute Engine AcceleratorTypes](https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes). Examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80` * `nvidia-tesla-k80` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, `nvidia-tesla-k80`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerator_type DataprocWorkflowTemplate#accelerator_type}
     */
    readonly acceleratorType?: string;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig {
    /**
     * Optional. Size in GB of the boot disk (default is 500GB).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#boot_disk_size_gb DataprocWorkflowTemplate#boot_disk_size_gb}
     */
    readonly bootDiskSizeGb?: number;
    /**
     * Optional.
     *
     * Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See [Disk types](https://cloud.google.com/compute/docs/disks#disk-types).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#boot_disk_type DataprocWorkflowTemplate#boot_disk_type}
     */
    readonly bootDiskType?: string;
    /**
     * Optional.
     *
     * Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#num_local_ssds DataprocWorkflowTemplate#num_local_ssds}
     */
    readonly numLocalSsds?: number;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number | undefined;
    set bootDiskSizeGb(value: number | undefined);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string | undefined;
    set bootDiskType(value: string | undefined);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number | undefined;
    set numLocalSsds(value: number | undefined);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig {
    /**
     * Optional.
     *
     * The Compute Engine image resource used for cluster instances. The URI can represent an image or image family. Image examples: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id]` * `projects/[project_id]/global/images/[image-id]` * `image-id` Image family examples. Dataproc will use the most recent image from the family: * `https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name]` * `projects/[project_id]/global/images/family/[custom-image-family-name]` If the URI is unspecified, it will be inferred from `SoftwareConfig.image_version` or the system default.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#image DataprocWorkflowTemplate#image}
     */
    readonly image?: string;
    /**
     * Optional.
     *
     * The Compute Engine machine type used for cluster instances. A full URL, partial URI, or short name are valid. Examples: * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2` * `n1-standard-2` **Auto Zone Exception**: If you are using the Dataproc [Auto Zone Placement](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, `n1-standard-2`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#machine_type DataprocWorkflowTemplate#machine_type}
     */
    readonly machineType?: string;
    /**
     * Optional. Specifies the minimum cpu platform for the Instance Group. See [Dataproc -> Minimum CPU Platform](https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#min_cpu_platform DataprocWorkflowTemplate#min_cpu_platform}
     */
    readonly minCpuPlatform?: string;
    /**
     * Optional.
     *
     * The number of VM instances in the instance group. For [HA cluster](/dataproc/docs/concepts/configuring-clusters/high-availability) [master_config](#FIELDS.master_config) groups, **must be set to 3**. For standard cluster [master_config](#FIELDS.master_config) groups, **must be set to 1**.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#num_instances DataprocWorkflowTemplate#num_instances}
     */
    readonly numInstances?: number;
    /**
     * Optional.
     *
     * Specifies the preemptibility of the instance group. The default value for master and worker groups is `NON_PREEMPTIBLE`. This default cannot be changed. The default value for secondary instances is `PREEMPTIBLE`. Possible values: PREEMPTIBILITY_UNSPECIFIED, NON_PREEMPTIBLE, PREEMPTIBLE
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#preemptibility DataprocWorkflowTemplate#preemptibility}
     */
    readonly preemptibility?: string;
    /**
     * accelerators block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#accelerators DataprocWorkflowTemplate#accelerators}
     */
    readonly accelerators?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[];
    /**
     * disk_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#disk_config DataprocWorkflowTemplate#disk_config}
     */
    readonly diskConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _image?;
    get image(): string | undefined;
    set image(value: string | undefined);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _machineType?;
    get machineType(): string | undefined;
    set machineType(value: string | undefined);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string | undefined;
    set minCpuPlatform(value: string | undefined);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number | undefined;
    set numInstances(value: number | undefined);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    get preemptibility(): string | undefined;
    set preemptibility(value: string | undefined);
    resetPreemptibility(): void;
    get preemptibilityInput(): string | undefined;
    private _accelerators?;
    get accelerators(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | undefined;
    set accelerators(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | undefined);
    resetAccelerators(): void;
    get acceleratorsInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigAccelerators[] | undefined;
    private _diskConfig?;
    private __diskConfigOutput;
    get diskConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig | undefined): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigDiskConfig | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedClusterConfig {
    /**
     * Optional.
     *
     * A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see [Dataproc staging bucket](https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)). **This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.**
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#staging_bucket DataprocWorkflowTemplate#staging_bucket}
     */
    readonly stagingBucket?: string;
    /**
     * Optional.
     *
     * A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket. **This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.**
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#temp_bucket DataprocWorkflowTemplate#temp_bucket}
     */
    readonly tempBucket?: string;
    /**
     * autoscaling_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#autoscaling_config DataprocWorkflowTemplate#autoscaling_config}
     */
    readonly autoscalingConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig;
    /**
     * encryption_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#encryption_config DataprocWorkflowTemplate#encryption_config}
     */
    readonly encryptionConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig;
    /**
     * endpoint_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#endpoint_config DataprocWorkflowTemplate#endpoint_config}
     */
    readonly endpointConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig;
    /**
     * gce_cluster_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#gce_cluster_config DataprocWorkflowTemplate#gce_cluster_config}
     */
    readonly gceClusterConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig;
    /**
     * initialization_actions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#initialization_actions DataprocWorkflowTemplate#initialization_actions}
     */
    readonly initializationActions?: DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[];
    /**
     * lifecycle_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#lifecycle_config DataprocWorkflowTemplate#lifecycle_config}
     */
    readonly lifecycleConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig;
    /**
     * master_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#master_config DataprocWorkflowTemplate#master_config}
     */
    readonly masterConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig;
    /**
     * secondary_worker_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#secondary_worker_config DataprocWorkflowTemplate#secondary_worker_config}
     */
    readonly secondaryWorkerConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig;
    /**
     * security_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#security_config DataprocWorkflowTemplate#security_config}
     */
    readonly securityConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig;
    /**
     * software_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#software_config DataprocWorkflowTemplate#software_config}
     */
    readonly softwareConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig;
    /**
     * worker_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#worker_config DataprocWorkflowTemplate#worker_config}
     */
    readonly workerConfig?: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _stagingBucket?;
    get stagingBucket(): string | undefined;
    set stagingBucket(value: string | undefined);
    resetStagingBucket(): void;
    get stagingBucketInput(): string | undefined;
    private _tempBucket?;
    get tempBucket(): string | undefined;
    set tempBucket(value: string | undefined);
    resetTempBucket(): void;
    get tempBucketInput(): string | undefined;
    private _autoscalingConfig?;
    private __autoscalingConfigOutput;
    get autoscalingConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfigOutputReference;
    putAutoscalingConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig | undefined): void;
    resetAutoscalingConfig(): void;
    get autoscalingConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigAutoscalingConfig | undefined;
    private _encryptionConfig?;
    private __encryptionConfigOutput;
    get encryptionConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfigOutputReference;
    putEncryptionConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig | undefined): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigEncryptionConfig | undefined;
    private _endpointConfig?;
    private __endpointConfigOutput;
    get endpointConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfigOutputReference;
    putEndpointConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig | undefined): void;
    resetEndpointConfig(): void;
    get endpointConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigEndpointConfig | undefined;
    private _gceClusterConfig?;
    private __gceClusterConfigOutput;
    get gceClusterConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfigOutputReference;
    putGceClusterConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig | undefined): void;
    resetGceClusterConfig(): void;
    get gceClusterConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigGceClusterConfig | undefined;
    private _initializationActions?;
    get initializationActions(): DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | undefined;
    set initializationActions(value: DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | undefined);
    resetInitializationActions(): void;
    get initializationActionsInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigInitializationActions[] | undefined;
    private _lifecycleConfig?;
    private __lifecycleConfigOutput;
    get lifecycleConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfigOutputReference;
    putLifecycleConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig | undefined): void;
    resetLifecycleConfig(): void;
    get lifecycleConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigLifecycleConfig | undefined;
    private _masterConfig?;
    private __masterConfigOutput;
    get masterConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfigOutputReference;
    putMasterConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig | undefined): void;
    resetMasterConfig(): void;
    get masterConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigMasterConfig | undefined;
    private _secondaryWorkerConfig?;
    private __secondaryWorkerConfigOutput;
    get secondaryWorkerConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfigOutputReference;
    putSecondaryWorkerConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig | undefined): void;
    resetSecondaryWorkerConfig(): void;
    get secondaryWorkerConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecondaryWorkerConfig | undefined;
    private _securityConfig?;
    private __securityConfigOutput;
    get securityConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfigOutputReference;
    putSecurityConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig | undefined): void;
    resetSecurityConfig(): void;
    get securityConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSecurityConfig | undefined;
    private _softwareConfig?;
    private __softwareConfigOutput;
    get softwareConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfigOutputReference;
    putSoftwareConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig | undefined): void;
    resetSoftwareConfig(): void;
    get softwareConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigSoftwareConfig | undefined;
    private _workerConfig?;
    private __workerConfigOutput;
    get workerConfig(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfigOutputReference;
    putWorkerConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig | undefined): void;
    resetWorkerConfig(): void;
    get workerConfigInput(): DataprocWorkflowTemplatePlacementManagedClusterConfigWorkerConfig | undefined;
}
export interface DataprocWorkflowTemplatePlacementManagedCluster {
    /**
     * Required.
     *
     * The cluster name prefix. A unique cluster name will be formed by appending a random suffix. The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cluster_name DataprocWorkflowTemplate#cluster_name}
     */
    readonly clusterName: string;
    /**
     * Optional.
     *
     * The labels to associate with this cluster. Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: p{Ll}p{Lo}{0,62} Label values must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: [p{Ll}p{Lo}p{N}_-]{0,63} No more than 32 labels can be associated with a given cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#labels DataprocWorkflowTemplate#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#config DataprocWorkflowTemplate#config}
     */
    readonly config: DataprocWorkflowTemplatePlacementManagedClusterConfig;
}
export declare class DataprocWorkflowTemplatePlacementManagedClusterOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _config?;
    private __configOutput;
    get config(): DataprocWorkflowTemplatePlacementManagedClusterConfigOutputReference;
    putConfig(value: DataprocWorkflowTemplatePlacementManagedClusterConfig): void;
    get configInput(): DataprocWorkflowTemplatePlacementManagedClusterConfig | undefined;
}
export interface DataprocWorkflowTemplatePlacement {
    /**
     * cluster_selector block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#cluster_selector DataprocWorkflowTemplate#cluster_selector}
     */
    readonly clusterSelector?: DataprocWorkflowTemplatePlacementClusterSelector;
    /**
     * managed_cluster block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#managed_cluster DataprocWorkflowTemplate#managed_cluster}
     */
    readonly managedCluster?: DataprocWorkflowTemplatePlacementManagedCluster;
}
export declare class DataprocWorkflowTemplatePlacementOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _clusterSelector?;
    private __clusterSelectorOutput;
    get clusterSelector(): DataprocWorkflowTemplatePlacementClusterSelectorOutputReference;
    putClusterSelector(value: DataprocWorkflowTemplatePlacementClusterSelector | undefined): void;
    resetClusterSelector(): void;
    get clusterSelectorInput(): DataprocWorkflowTemplatePlacementClusterSelector | undefined;
    private _managedCluster?;
    private __managedClusterOutput;
    get managedCluster(): DataprocWorkflowTemplatePlacementManagedClusterOutputReference;
    putManagedCluster(value: DataprocWorkflowTemplatePlacementManagedCluster | undefined): void;
    resetManagedCluster(): void;
    get managedClusterInput(): DataprocWorkflowTemplatePlacementManagedCluster | undefined;
}
export interface DataprocWorkflowTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#create DataprocWorkflowTemplate#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html#delete DataprocWorkflowTemplate#delete}.
     */
    readonly delete?: string;
}
export declare class DataprocWorkflowTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html google_dataproc_workflow_template}.
 */
export declare class DataprocWorkflowTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_workflow_template.html google_dataproc_workflow_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataprocWorkflowTemplateConfig);
    get createTime(): string;
    private _dagTimeout?;
    get dagTimeout(): string | undefined;
    set dagTimeout(value: string | undefined);
    resetDagTimeout(): void;
    get dagTimeoutInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _version?;
    get version(): number | undefined;
    set version(value: number | undefined);
    resetVersion(): void;
    get versionInput(): number | undefined;
    private _jobs?;
    get jobs(): DataprocWorkflowTemplateJobs[];
    set jobs(value: DataprocWorkflowTemplateJobs[]);
    get jobsInput(): DataprocWorkflowTemplateJobs[] | undefined;
    private _parameters?;
    get parameters(): DataprocWorkflowTemplateParameters[] | undefined;
    set parameters(value: DataprocWorkflowTemplateParameters[] | undefined);
    resetParameters(): void;
    get parametersInput(): DataprocWorkflowTemplateParameters[] | undefined;
    private _placement?;
    private __placementOutput;
    get placement(): DataprocWorkflowTemplatePlacementOutputReference;
    putPlacement(value: DataprocWorkflowTemplatePlacement): void;
    get placementInput(): DataprocWorkflowTemplatePlacement | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DataprocWorkflowTemplateTimeoutsOutputReference;
    putTimeouts(value: DataprocWorkflowTemplateTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataprocWorkflowTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
