import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataprocJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * By default, you can only delete inactive jobs within Dataproc.
     *
     * Setting this to true, and calling destroy, will ensure that the job is first cancelled before issuing the delete.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#force_delete DataprocJob#force_delete}
     */
    readonly forceDelete?: boolean | cdktf.IResolvable;
    /**
     * Optional. The labels to associate with this job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#labels DataprocJob#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The project in which the cluster can be found and jobs subsequently run against.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#project DataprocJob#project}
     */
    readonly project?: string;
    /**
     * The Cloud Dataproc region.
     *
     * This essentially determines which clusters are available for this job to be submitted to. If not specified, defaults to global.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#region DataprocJob#region}
     */
    readonly region?: string;
    /**
     * hadoop_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#hadoop_config DataprocJob#hadoop_config}
     */
    readonly hadoopConfig?: DataprocJobHadoopConfig;
    /**
     * hive_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#hive_config DataprocJob#hive_config}
     */
    readonly hiveConfig?: DataprocJobHiveConfig;
    /**
     * pig_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#pig_config DataprocJob#pig_config}
     */
    readonly pigConfig?: DataprocJobPigConfig;
    /**
     * placement block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#placement DataprocJob#placement}
     */
    readonly placement: DataprocJobPlacement;
    /**
     * pyspark_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#pyspark_config DataprocJob#pyspark_config}
     */
    readonly pysparkConfig?: DataprocJobPysparkConfig;
    /**
     * reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#reference DataprocJob#reference}
     */
    readonly reference?: DataprocJobReference;
    /**
     * scheduling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#scheduling DataprocJob#scheduling}
     */
    readonly scheduling?: DataprocJobScheduling;
    /**
     * spark_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#spark_config DataprocJob#spark_config}
     */
    readonly sparkConfig?: DataprocJobSparkConfig;
    /**
     * sparksql_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#sparksql_config DataprocJob#sparksql_config}
     */
    readonly sparksqlConfig?: DataprocJobSparksqlConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#timeouts DataprocJob#timeouts}
     */
    readonly timeouts?: DataprocJobTimeouts;
}
export declare class DataprocJobStatus extends cdktf.ComplexComputedList {
    get details(): string;
    get state(): string;
    get stateStartTime(): string;
    get substate(): string;
}
export interface DataprocJobHadoopConfigLoggingConfig {
    /**
     * Optional.
     *
     * The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#driver_log_levels DataprocJob#driver_log_levels}
     */
    readonly driverLogLevels: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocJobHadoopConfigLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set driverLogLevels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    get driverLogLevelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocJobHadoopConfig {
    /**
     * HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#archive_uris DataprocJob#archive_uris}
     */
    readonly archiveUris?: string[];
    /**
     * The arguments to pass to the driver.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#args DataprocJob#args}
     */
    readonly args?: string[];
    /**
     * HCFS URIs of files to be copied to the working directory of Spark drivers and distributed tasks.
     *
     * Useful for naively parallel tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#file_uris DataprocJob#file_uris}
     */
    readonly fileUris?: string[];
    /**
     * HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#jar_file_uris DataprocJob#jar_file_uris}
     */
    readonly jarFileUris?: string[];
    /**
     * The class containing the main method of the driver.
     *
     * Must be in a provided jar or jar that is already on the classpath. Conflicts with main_jar_file_uri
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#main_class DataprocJob#main_class}
     */
    readonly mainClass?: string;
    /**
     * The HCFS URI of jar file containing the driver jar. Conflicts with main_class.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#main_jar_file_uri DataprocJob#main_jar_file_uri}
     */
    readonly mainJarFileUri?: string;
    /**
     * A mapping of property names to values, used to configure Spark.
     *
     * Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#properties DataprocJob#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#logging_config DataprocJob#logging_config}
     */
    readonly loggingConfig?: DataprocJobHadoopConfigLoggingConfig;
}
export declare class DataprocJobHadoopConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _archiveUris?;
    get archiveUris(): string[] | undefined;
    set archiveUris(value: string[] | undefined);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[] | undefined;
    set args(value: string[] | undefined);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[] | undefined;
    set fileUris(value: string[] | undefined);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[] | undefined;
    set jarFileUris(value: string[] | undefined);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainClass?;
    get mainClass(): string | undefined;
    set mainClass(value: string | undefined);
    resetMainClass(): void;
    get mainClassInput(): string | undefined;
    private _mainJarFileUri?;
    get mainJarFileUri(): string | undefined;
    set mainJarFileUri(value: string | undefined);
    resetMainJarFileUri(): void;
    get mainJarFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _loggingConfig?;
    private __loggingConfigOutput;
    get loggingConfig(): DataprocJobHadoopConfigLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocJobHadoopConfigLoggingConfig | undefined): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocJobHadoopConfigLoggingConfig | undefined;
}
export interface DataprocJobHiveConfig {
    /**
     * Whether to continue executing queries if a query fails.
     *
     * The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#continue_on_failure DataprocJob#continue_on_failure}
     */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
     * HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks.
     *
     * Can contain Hive SerDes and UDFs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#jar_file_uris DataprocJob#jar_file_uris}
     */
    readonly jarFileUris?: string[];
    /**
     * A mapping of property names and values, used to configure Hive.
     *
     * Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#properties DataprocJob#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * HCFS URI of file containing Hive script to execute as the job. Conflicts with query_list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#query_file_uri DataprocJob#query_file_uri}
     */
    readonly queryFileUri?: string;
    /**
     * The list of Hive queries or statements to execute as part of the job. Conflicts with query_file_uri.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#query_list DataprocJob#query_list}
     */
    readonly queryList?: string[];
    /**
     * Mapping of query variable names to values (equivalent to the Hive command: SET name="value";).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#script_variables DataprocJob#script_variables}
     */
    readonly scriptVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocJobHiveConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable | undefined;
    set continueOnFailure(value: boolean | cdktf.IResolvable | undefined);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[] | undefined;
    set jarFileUris(value: string[] | undefined);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string | undefined;
    set queryFileUri(value: string | undefined);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _queryList?;
    get queryList(): string[] | undefined;
    set queryList(value: string[] | undefined);
    resetQueryList(): void;
    get queryListInput(): string[] | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set scriptVariables(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetScriptVariables(): void;
    get scriptVariablesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocJobPigConfigLoggingConfig {
    /**
     * Optional.
     *
     * The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#driver_log_levels DataprocJob#driver_log_levels}
     */
    readonly driverLogLevels: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocJobPigConfigLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set driverLogLevels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    get driverLogLevelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocJobPigConfig {
    /**
     * Whether to continue executing queries if a query fails.
     *
     * The default value is false. Setting to true can be useful when executing independent parallel queries. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#continue_on_failure DataprocJob#continue_on_failure}
     */
    readonly continueOnFailure?: boolean | cdktf.IResolvable;
    /**
     * HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks.
     *
     * Can contain Pig UDFs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#jar_file_uris DataprocJob#jar_file_uris}
     */
    readonly jarFileUris?: string[];
    /**
     * A mapping of property names to values, used to configure Pig.
     *
     * Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#properties DataprocJob#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * HCFS URI of file containing Hive script to execute as the job. Conflicts with query_list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#query_file_uri DataprocJob#query_file_uri}
     */
    readonly queryFileUri?: string;
    /**
     * The list of Hive queries or statements to execute as part of the job. Conflicts with query_file_uri.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#query_list DataprocJob#query_list}
     */
    readonly queryList?: string[];
    /**
     * Mapping of query variable names to values (equivalent to the Pig command: name=[value]).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#script_variables DataprocJob#script_variables}
     */
    readonly scriptVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#logging_config DataprocJob#logging_config}
     */
    readonly loggingConfig?: DataprocJobPigConfigLoggingConfig;
}
export declare class DataprocJobPigConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _continueOnFailure?;
    get continueOnFailure(): boolean | cdktf.IResolvable | undefined;
    set continueOnFailure(value: boolean | cdktf.IResolvable | undefined);
    resetContinueOnFailure(): void;
    get continueOnFailureInput(): boolean | cdktf.IResolvable | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[] | undefined;
    set jarFileUris(value: string[] | undefined);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string | undefined;
    set queryFileUri(value: string | undefined);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _queryList?;
    get queryList(): string[] | undefined;
    set queryList(value: string[] | undefined);
    resetQueryList(): void;
    get queryListInput(): string[] | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set scriptVariables(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetScriptVariables(): void;
    get scriptVariablesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _loggingConfig?;
    private __loggingConfigOutput;
    get loggingConfig(): DataprocJobPigConfigLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocJobPigConfigLoggingConfig | undefined): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocJobPigConfigLoggingConfig | undefined;
}
export interface DataprocJobPlacement {
    /**
     * The name of the cluster where the job will be submitted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#cluster_name DataprocJob#cluster_name}
     */
    readonly clusterName: string;
}
export declare class DataprocJobPlacementOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
}
export interface DataprocJobPysparkConfigLoggingConfig {
    /**
     * Optional.
     *
     * The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#driver_log_levels DataprocJob#driver_log_levels}
     */
    readonly driverLogLevels: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocJobPysparkConfigLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set driverLogLevels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    get driverLogLevelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocJobPysparkConfig {
    /**
     * Optional. HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#archive_uris DataprocJob#archive_uris}
     */
    readonly archiveUris?: string[];
    /**
     * Optional.
     *
     * The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#args DataprocJob#args}
     */
    readonly args?: string[];
    /**
     * Optional.
     *
     * HCFS URIs of files to be copied to the working directory of Python drivers and distributed tasks. Useful for naively parallel tasks
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#file_uris DataprocJob#file_uris}
     */
    readonly fileUris?: string[];
    /**
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#jar_file_uris DataprocJob#jar_file_uris}
     */
    readonly jarFileUris?: string[];
    /**
     * Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#main_python_file_uri DataprocJob#main_python_file_uri}
     */
    readonly mainPythonFileUri: string;
    /**
     * Optional.
     *
     * A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#properties DataprocJob#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Optional.
     *
     * HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#python_file_uris DataprocJob#python_file_uris}
     */
    readonly pythonFileUris?: string[];
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#logging_config DataprocJob#logging_config}
     */
    readonly loggingConfig?: DataprocJobPysparkConfigLoggingConfig;
}
export declare class DataprocJobPysparkConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _archiveUris?;
    get archiveUris(): string[] | undefined;
    set archiveUris(value: string[] | undefined);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[] | undefined;
    set args(value: string[] | undefined);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[] | undefined;
    set fileUris(value: string[] | undefined);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[] | undefined;
    set jarFileUris(value: string[] | undefined);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainPythonFileUri?;
    get mainPythonFileUri(): string;
    set mainPythonFileUri(value: string);
    get mainPythonFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _pythonFileUris?;
    get pythonFileUris(): string[] | undefined;
    set pythonFileUris(value: string[] | undefined);
    resetPythonFileUris(): void;
    get pythonFileUrisInput(): string[] | undefined;
    private _loggingConfig?;
    private __loggingConfigOutput;
    get loggingConfig(): DataprocJobPysparkConfigLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocJobPysparkConfigLoggingConfig | undefined): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocJobPysparkConfigLoggingConfig | undefined;
}
export interface DataprocJobReference {
    /**
     * The job ID, which must be unique within the project.
     *
     * The job ID is generated by the server upon job submission or provided by the user as a means to perform retries without creating duplicate jobs
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#job_id DataprocJob#job_id}
     */
    readonly jobId?: string;
}
export declare class DataprocJobReferenceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _jobId?;
    get jobId(): string | undefined;
    set jobId(value: string | undefined);
    resetJobId(): void;
    get jobIdInput(): string | undefined;
}
export interface DataprocJobScheduling {
    /**
     * Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#max_failures_per_hour DataprocJob#max_failures_per_hour}
     */
    readonly maxFailuresPerHour: number;
    /**
     * Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#max_failures_total DataprocJob#max_failures_total}
     */
    readonly maxFailuresTotal: number;
}
export declare class DataprocJobSchedulingOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxFailuresPerHour?;
    get maxFailuresPerHour(): number;
    set maxFailuresPerHour(value: number);
    get maxFailuresPerHourInput(): number | undefined;
    private _maxFailuresTotal?;
    get maxFailuresTotal(): number;
    set maxFailuresTotal(value: number);
    get maxFailuresTotalInput(): number | undefined;
}
export interface DataprocJobSparkConfigLoggingConfig {
    /**
     * Optional.
     *
     * The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#driver_log_levels DataprocJob#driver_log_levels}
     */
    readonly driverLogLevels: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocJobSparkConfigLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set driverLogLevels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    get driverLogLevelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocJobSparkConfig {
    /**
     * HCFS URIs of archives to be extracted in the working directory of .jar, .tar, .tar.gz, .tgz, and .zip.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#archive_uris DataprocJob#archive_uris}
     */
    readonly archiveUris?: string[];
    /**
     * The arguments to pass to the driver.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#args DataprocJob#args}
     */
    readonly args?: string[];
    /**
     * HCFS URIs of files to be copied to the working directory of Spark drivers and distributed tasks.
     *
     * Useful for naively parallel tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#file_uris DataprocJob#file_uris}
     */
    readonly fileUris?: string[];
    /**
     * HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#jar_file_uris DataprocJob#jar_file_uris}
     */
    readonly jarFileUris?: string[];
    /**
     * The class containing the main method of the driver.
     *
     * Must be in a provided jar or jar that is already on the classpath. Conflicts with main_jar_file_uri
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#main_class DataprocJob#main_class}
     */
    readonly mainClass?: string;
    /**
     * The HCFS URI of jar file containing the driver jar. Conflicts with main_class.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#main_jar_file_uri DataprocJob#main_jar_file_uri}
     */
    readonly mainJarFileUri?: string;
    /**
     * A mapping of property names to values, used to configure Spark.
     *
     * Properties that conflict with values set by the Cloud Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#properties DataprocJob#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#logging_config DataprocJob#logging_config}
     */
    readonly loggingConfig?: DataprocJobSparkConfigLoggingConfig;
}
export declare class DataprocJobSparkConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _archiveUris?;
    get archiveUris(): string[] | undefined;
    set archiveUris(value: string[] | undefined);
    resetArchiveUris(): void;
    get archiveUrisInput(): string[] | undefined;
    private _args?;
    get args(): string[] | undefined;
    set args(value: string[] | undefined);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _fileUris?;
    get fileUris(): string[] | undefined;
    set fileUris(value: string[] | undefined);
    resetFileUris(): void;
    get fileUrisInput(): string[] | undefined;
    private _jarFileUris?;
    get jarFileUris(): string[] | undefined;
    set jarFileUris(value: string[] | undefined);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _mainClass?;
    get mainClass(): string | undefined;
    set mainClass(value: string | undefined);
    resetMainClass(): void;
    get mainClassInput(): string | undefined;
    private _mainJarFileUri?;
    get mainJarFileUri(): string | undefined;
    set mainJarFileUri(value: string | undefined);
    resetMainJarFileUri(): void;
    get mainJarFileUriInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _loggingConfig?;
    private __loggingConfigOutput;
    get loggingConfig(): DataprocJobSparkConfigLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocJobSparkConfigLoggingConfig | undefined): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocJobSparkConfigLoggingConfig | undefined;
}
export interface DataprocJobSparksqlConfigLoggingConfig {
    /**
     * Optional.
     *
     * The per-package log levels for the driver. This may include 'root' package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#driver_log_levels DataprocJob#driver_log_levels}
     */
    readonly driverLogLevels: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocJobSparksqlConfigLoggingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _driverLogLevels?;
    get driverLogLevels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    set driverLogLevels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    get driverLogLevelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocJobSparksqlConfig {
    /**
     * HCFS URIs of jar files to be added to the Spark CLASSPATH.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#jar_file_uris DataprocJob#jar_file_uris}
     */
    readonly jarFileUris?: string[];
    /**
     * A mapping of property names to values, used to configure Spark SQL's SparkConf.
     *
     * Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#properties DataprocJob#properties}
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The HCFS URI of the script that contains SQL queries. Conflicts with query_list.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#query_file_uri DataprocJob#query_file_uri}
     */
    readonly queryFileUri?: string;
    /**
     * The list of SQL queries or statements to execute as part of the job. Conflicts with query_file_uri.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#query_list DataprocJob#query_list}
     */
    readonly queryList?: string[];
    /**
     * Mapping of query variable names to values (equivalent to the Spark SQL command: SET name="value";).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#script_variables DataprocJob#script_variables}
     */
    readonly scriptVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#logging_config DataprocJob#logging_config}
     */
    readonly loggingConfig?: DataprocJobSparksqlConfigLoggingConfig;
}
export declare class DataprocJobSparksqlConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _jarFileUris?;
    get jarFileUris(): string[] | undefined;
    set jarFileUris(value: string[] | undefined);
    resetJarFileUris(): void;
    get jarFileUrisInput(): string[] | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _queryFileUri?;
    get queryFileUri(): string | undefined;
    set queryFileUri(value: string | undefined);
    resetQueryFileUri(): void;
    get queryFileUriInput(): string | undefined;
    private _queryList?;
    get queryList(): string[] | undefined;
    set queryList(value: string[] | undefined);
    resetQueryList(): void;
    get queryListInput(): string[] | undefined;
    private _scriptVariables?;
    get scriptVariables(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set scriptVariables(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetScriptVariables(): void;
    get scriptVariablesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _loggingConfig?;
    private __loggingConfigOutput;
    get loggingConfig(): DataprocJobSparksqlConfigLoggingConfigOutputReference;
    putLoggingConfig(value: DataprocJobSparksqlConfigLoggingConfig | undefined): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): DataprocJobSparksqlConfigLoggingConfig | undefined;
}
export interface DataprocJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#create DataprocJob#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html#delete DataprocJob#delete}.
     */
    readonly delete?: string;
}
export declare class DataprocJobTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html google_dataproc_job}.
 */
export declare class DataprocJob extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_job.html google_dataproc_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataprocJobConfig);
    get driverControlsFilesUri(): string;
    get driverOutputResourceUri(): string;
    private _forceDelete?;
    get forceDelete(): boolean | cdktf.IResolvable | undefined;
    set forceDelete(value: boolean | cdktf.IResolvable | undefined);
    resetForceDelete(): void;
    get forceDeleteInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    status(index: string): DataprocJobStatus;
    private _hadoopConfig?;
    private __hadoopConfigOutput;
    get hadoopConfig(): DataprocJobHadoopConfigOutputReference;
    putHadoopConfig(value: DataprocJobHadoopConfig | undefined): void;
    resetHadoopConfig(): void;
    get hadoopConfigInput(): DataprocJobHadoopConfig | undefined;
    private _hiveConfig?;
    private __hiveConfigOutput;
    get hiveConfig(): DataprocJobHiveConfigOutputReference;
    putHiveConfig(value: DataprocJobHiveConfig | undefined): void;
    resetHiveConfig(): void;
    get hiveConfigInput(): DataprocJobHiveConfig | undefined;
    private _pigConfig?;
    private __pigConfigOutput;
    get pigConfig(): DataprocJobPigConfigOutputReference;
    putPigConfig(value: DataprocJobPigConfig | undefined): void;
    resetPigConfig(): void;
    get pigConfigInput(): DataprocJobPigConfig | undefined;
    private _placement?;
    private __placementOutput;
    get placement(): DataprocJobPlacementOutputReference;
    putPlacement(value: DataprocJobPlacement): void;
    get placementInput(): DataprocJobPlacement | undefined;
    private _pysparkConfig?;
    private __pysparkConfigOutput;
    get pysparkConfig(): DataprocJobPysparkConfigOutputReference;
    putPysparkConfig(value: DataprocJobPysparkConfig | undefined): void;
    resetPysparkConfig(): void;
    get pysparkConfigInput(): DataprocJobPysparkConfig | undefined;
    private _reference?;
    private __referenceOutput;
    get reference(): DataprocJobReferenceOutputReference;
    putReference(value: DataprocJobReference | undefined): void;
    resetReference(): void;
    get referenceInput(): DataprocJobReference | undefined;
    private _scheduling?;
    private __schedulingOutput;
    get scheduling(): DataprocJobSchedulingOutputReference;
    putScheduling(value: DataprocJobScheduling | undefined): void;
    resetScheduling(): void;
    get schedulingInput(): DataprocJobScheduling | undefined;
    private _sparkConfig?;
    private __sparkConfigOutput;
    get sparkConfig(): DataprocJobSparkConfigOutputReference;
    putSparkConfig(value: DataprocJobSparkConfig | undefined): void;
    resetSparkConfig(): void;
    get sparkConfigInput(): DataprocJobSparkConfig | undefined;
    private _sparksqlConfig?;
    private __sparksqlConfigOutput;
    get sparksqlConfig(): DataprocJobSparksqlConfigOutputReference;
    putSparksqlConfig(value: DataprocJobSparksqlConfig | undefined): void;
    resetSparksqlConfig(): void;
    get sparksqlConfigInput(): DataprocJobSparksqlConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DataprocJobTimeoutsOutputReference;
    putTimeouts(value: DataprocJobTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataprocJobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
