import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataprocClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * The timeout duration which allows graceful decomissioning when you change the number of worker nodes directly through a terraform apply.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#graceful_decommission_timeout DataprocCluster#graceful_decommission_timeout}
     */
    readonly gracefulDecommissionTimeout?: string;
    /**
     * The list of labels (key/value pairs) to be applied to instances in the cluster.
     *
     * GCP generates some itself including goog-dataproc-cluster-name which is the name of the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#labels DataprocCluster#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The name of the cluster, unique within the project and zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#name DataprocCluster#name}
     */
    readonly name: string;
    /**
     * The ID of the project in which the cluster will exist.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#project DataprocCluster#project}
     */
    readonly project?: string;
    /**
     * The region in which the cluster and associated nodes will be created in. Defaults to global.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#region DataprocCluster#region}
     */
    readonly region?: string;
    /**
     * cluster_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#cluster_config DataprocCluster#cluster_config}
     */
    readonly clusterConfig?: DataprocClusterClusterConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#timeouts DataprocCluster#timeouts}
     */
    readonly timeouts?: DataprocClusterTimeouts;
}
export interface DataprocClusterClusterConfigAutoscalingConfig {
    /**
     * The autoscaling policy used by the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#policy_uri DataprocCluster#policy_uri}
     */
    readonly policyUri: string;
}
export declare class DataprocClusterClusterConfigAutoscalingConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _policyUri?;
    get policyUri(): string;
    set policyUri(value: string);
    get policyUriInput(): string | undefined;
}
export interface DataprocClusterClusterConfigEncryptionConfig {
    /**
     * The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#kms_key_name DataprocCluster#kms_key_name}
     */
    readonly kmsKeyName: string;
}
export declare class DataprocClusterClusterConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig {
    /**
     * Defines whether instances have integrity monitoring enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#enable_integrity_monitoring DataprocCluster#enable_integrity_monitoring}
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Defines whether instances have Secure Boot enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#enable_secure_boot DataprocCluster#enable_secure_boot}
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
     * Defines whether instances have the vTPM enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#enable_vtpm DataprocCluster#enable_vtpm}
     */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare class DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable | undefined;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable | undefined);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable | undefined;
    set enableSecureBoot(value: boolean | cdktf.IResolvable | undefined);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable | undefined;
    set enableVtpm(value: boolean | cdktf.IResolvable | undefined);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataprocClusterClusterConfigGceClusterConfig {
    /**
     * By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance.
     *
     * If set to true, all instances in the cluster will only have internal IP addresses. Note: Private Google Access (also known as privateIpGoogleAccess) must be enabled on the subnetwork that the cluster will be launched in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#internal_ip_only DataprocCluster#internal_ip_only}
     */
    readonly internalIpOnly?: boolean | cdktf.IResolvable;
    /**
     * A map of the Compute Engine metadata entries to add to all instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#metadata DataprocCluster#metadata}
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The name or self_link of the Google Compute Engine network to the cluster will be part of.
     *
     * Conflicts with subnetwork. If neither is specified, this defaults to the "default" network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#network DataprocCluster#network}
     */
    readonly network?: string;
    /**
     * The service account to be used by the Node VMs. If not specified, the "default" service account is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#service_account DataprocCluster#service_account}
     */
    readonly serviceAccount?: string;
    /**
     * The set of Google API scopes to be made available on all of the node VMs under the service_account specified.
     *
     * These can be either FQDNs, or scope aliases.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#service_account_scopes DataprocCluster#service_account_scopes}
     */
    readonly serviceAccountScopes?: string[];
    /**
     * The name or self_link of the Google Compute Engine subnetwork the cluster will be part of. Conflicts with network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#subnetwork DataprocCluster#subnetwork}
     */
    readonly subnetwork?: string;
    /**
     * The list of instance tags applied to instances in the cluster.
     *
     * Tags are used to identify valid sources or targets for network firewalls.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#tags DataprocCluster#tags}
     */
    readonly tags?: string[];
    /**
     * The GCP zone where your data is stored and used (i.e. where the master and the worker nodes will be created in). If region is set to 'global' (default) then zone is mandatory, otherwise GCP is able to make use of Auto Zone Placement to determine this automatically for you. Note: This setting additionally determines and restricts which computing resources are available for use with other configs such as cluster_config.master_config.machine_type and cluster_config.worker_config.machine_type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#zone DataprocCluster#zone}
     */
    readonly zone?: string;
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#shielded_instance_config DataprocCluster#shielded_instance_config}
     */
    readonly shieldedInstanceConfig?: DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig;
}
export declare class DataprocClusterClusterConfigGceClusterConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _internalIpOnly?;
    get internalIpOnly(): boolean | cdktf.IResolvable | undefined;
    set internalIpOnly(value: boolean | cdktf.IResolvable | undefined);
    resetInternalIpOnly(): void;
    get internalIpOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetMetadata(): void;
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _network?;
    get network(): string | undefined;
    set network(value: string | undefined);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string | undefined;
    set serviceAccount(value: string | undefined);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _serviceAccountScopes?;
    get serviceAccountScopes(): string[] | undefined;
    set serviceAccountScopes(value: string[] | undefined);
    resetServiceAccountScopes(): void;
    get serviceAccountScopesInput(): string[] | undefined;
    private _subnetwork?;
    get subnetwork(): string | undefined;
    set subnetwork(value: string | undefined);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tags?;
    get tags(): string[] | undefined;
    set tags(value: string[] | undefined);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _shieldedInstanceConfig?;
    private __shieldedInstanceConfigOutput;
    get shieldedInstanceConfig(): DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig | undefined): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig | undefined;
}
export interface DataprocClusterClusterConfigInitializationAction {
    /**
     * The script to be executed during initialization of the cluster.
     *
     * The script must be a GCS file with a gs:// prefix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#script DataprocCluster#script}
     */
    readonly script: string;
    /**
     * The maximum duration (in seconds) which script is allowed to take to execute its action.
     *
     * GCP will default to a predetermined computed value if not set (currently 300).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#timeout_sec DataprocCluster#timeout_sec}
     */
    readonly timeoutSec?: number;
}
export interface DataprocClusterClusterConfigMasterConfigAccelerators {
    /**
     * The number of the accelerator cards of this type exposed to this instance.
     *
     * Often restricted to one of 1, 2, 4, or 8.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#accelerator_count DataprocCluster#accelerator_count}
     */
    readonly acceleratorCount: number;
    /**
     * The short name of the accelerator type to expose to this instance. For example, nvidia-tesla-k80.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#accelerator_type DataprocCluster#accelerator_type}
     */
    readonly acceleratorType: string;
}
export interface DataprocClusterClusterConfigMasterConfigDiskConfig {
    /**
     * Size of the primary disk attached to each node, specified in GB.
     *
     * The primary disk contains the boot volume and system libraries, and the smallest allowed disk size is 10GB. GCP will default to a predetermined computed value if not set (currently 500GB). Note: If SSDs are not attached, it also contains the HDFS data blocks and Hadoop working directories.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#boot_disk_size_gb DataprocCluster#boot_disk_size_gb}
     */
    readonly bootDiskSizeGb?: number;
    /**
     * The disk type of the primary disk attached to each node. One of "pd-ssd" or "pd-standard". Defaults to "pd-standard".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#boot_disk_type DataprocCluster#boot_disk_type}
     */
    readonly bootDiskType?: string;
    /**
     * The amount of local SSD disks that will be attached to each master cluster node. Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#num_local_ssds DataprocCluster#num_local_ssds}
     */
    readonly numLocalSsds?: number;
}
export declare class DataprocClusterClusterConfigMasterConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number | undefined;
    set bootDiskSizeGb(value: number | undefined);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string | undefined;
    set bootDiskType(value: string | undefined);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number | undefined;
    set numLocalSsds(value: number | undefined);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocClusterClusterConfigMasterConfig {
    /**
     * The URI for the image to use for this master/worker.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#image_uri DataprocCluster#image_uri}
     */
    readonly imageUri?: string;
    /**
     * The name of a Google Compute Engine machine type to create for the master/worker.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#machine_type DataprocCluster#machine_type}
     */
    readonly machineType?: string;
    /**
     * The name of a minimum generation of CPU family for the master/worker.
     *
     * If not specified, GCP will default to a predetermined computed value for each zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#min_cpu_platform DataprocCluster#min_cpu_platform}
     */
    readonly minCpuPlatform?: string;
    /**
     * Specifies the number of master/worker nodes to create. If not specified, GCP will default to a predetermined computed value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#num_instances DataprocCluster#num_instances}
     */
    readonly numInstances?: number;
    /**
     * accelerators block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#accelerators DataprocCluster#accelerators}
     */
    readonly accelerators?: DataprocClusterClusterConfigMasterConfigAccelerators[];
    /**
     * disk_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#disk_config DataprocCluster#disk_config}
     */
    readonly diskConfig?: DataprocClusterClusterConfigMasterConfigDiskConfig;
}
export declare class DataprocClusterClusterConfigMasterConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _imageUri?;
    get imageUri(): string | undefined;
    set imageUri(value: string | undefined);
    resetImageUri(): void;
    get imageUriInput(): string | undefined;
    private _machineType?;
    get machineType(): string | undefined;
    set machineType(value: string | undefined);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string | undefined;
    set minCpuPlatform(value: string | undefined);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number | undefined;
    set numInstances(value: number | undefined);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _accelerators?;
    get accelerators(): DataprocClusterClusterConfigMasterConfigAccelerators[] | undefined;
    set accelerators(value: DataprocClusterClusterConfigMasterConfigAccelerators[] | undefined);
    resetAccelerators(): void;
    get acceleratorsInput(): DataprocClusterClusterConfigMasterConfigAccelerators[] | undefined;
    private _diskConfig?;
    private __diskConfigOutput;
    get diskConfig(): DataprocClusterClusterConfigMasterConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocClusterClusterConfigMasterConfigDiskConfig | undefined): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocClusterClusterConfigMasterConfigDiskConfig | undefined;
}
export interface DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig {
    /**
     * Size of the primary disk attached to each preemptible worker node, specified in GB.
     *
     * The smallest allowed disk size is 10GB. GCP will default to a predetermined computed value if not set (currently 500GB). Note: If SSDs are not attached, it also contains the HDFS data blocks and Hadoop working directories.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#boot_disk_size_gb DataprocCluster#boot_disk_size_gb}
     */
    readonly bootDiskSizeGb?: number;
    /**
     * The disk type of the primary disk attached to each preemptible worker node.
     *
     * One of "pd-ssd" or "pd-standard". Defaults to "pd-standard".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#boot_disk_type DataprocCluster#boot_disk_type}
     */
    readonly bootDiskType?: string;
    /**
     * The amount of local SSD disks that will be attached to each preemptible worker node. Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#num_local_ssds DataprocCluster#num_local_ssds}
     */
    readonly numLocalSsds?: number;
}
export declare class DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number | undefined;
    set bootDiskSizeGb(value: number | undefined);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string | undefined;
    set bootDiskType(value: string | undefined);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number | undefined;
    set numLocalSsds(value: number | undefined);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocClusterClusterConfigPreemptibleWorkerConfig {
    /**
     * Specifies the number of preemptible nodes to create. Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#num_instances DataprocCluster#num_instances}
     */
    readonly numInstances?: number;
    /**
     * disk_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#disk_config DataprocCluster#disk_config}
     */
    readonly diskConfig?: DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig;
}
export declare class DataprocClusterClusterConfigPreemptibleWorkerConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _numInstances?;
    get numInstances(): number | undefined;
    set numInstances(value: number | undefined);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _diskConfig?;
    private __diskConfigOutput;
    get diskConfig(): DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig | undefined): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig | undefined;
}
export interface DataprocClusterClusterConfigSecurityConfigKerberosConfig {
    /**
     * The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#cross_realm_trust_admin_server DataprocCluster#cross_realm_trust_admin_server}
     */
    readonly crossRealmTrustAdminServer?: string;
    /**
     * The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#cross_realm_trust_kdc DataprocCluster#cross_realm_trust_kdc}
     */
    readonly crossRealmTrustKdc?: string;
    /**
     * The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#cross_realm_trust_realm DataprocCluster#cross_realm_trust_realm}
     */
    readonly crossRealmTrustRealm?: string;
    /**
     * The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#cross_realm_trust_shared_password_uri DataprocCluster#cross_realm_trust_shared_password_uri}
     */
    readonly crossRealmTrustSharedPasswordUri?: string;
    /**
     * Flag to indicate whether to Kerberize the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#enable_kerberos DataprocCluster#enable_kerberos}
     */
    readonly enableKerberos?: boolean | cdktf.IResolvable;
    /**
     * The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#kdc_db_key_uri DataprocCluster#kdc_db_key_uri}
     */
    readonly kdcDbKeyUri?: string;
    /**
     * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key.
     *
     * For the self-signed certificate, this password is generated by Dataproc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#key_password_uri DataprocCluster#key_password_uri}
     */
    readonly keyPasswordUri?: string;
    /**
     * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore.
     *
     * For the self-signed certificate, this password is generated
     * by Dataproc
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#keystore_password_uri DataprocCluster#keystore_password_uri}
     */
    readonly keystorePasswordUri?: string;
    /**
     * The Cloud Storage URI of the keystore file used for SSL encryption.
     *
     * If not provided, Dataproc will provide a self-signed certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#keystore_uri DataprocCluster#keystore_uri}
     */
    readonly keystoreUri?: string;
    /**
     * The uri of the KMS key used to encrypt various sensitive files.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#kms_key_uri DataprocCluster#kms_key_uri}
     */
    readonly kmsKeyUri: string;
    /**
     * The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#realm DataprocCluster#realm}
     */
    readonly realm?: string;
    /**
     * The cloud Storage URI of a KMS encrypted file containing the root principal password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#root_principal_password_uri DataprocCluster#root_principal_password_uri}
     */
    readonly rootPrincipalPasswordUri: string;
    /**
     * The lifetime of the ticket granting ticket, in hours.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#tgt_lifetime_hours DataprocCluster#tgt_lifetime_hours}
     */
    readonly tgtLifetimeHours?: number;
    /**
     * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore.
     *
     * For the self-signed certificate, this password is generated by Dataproc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#truststore_password_uri DataprocCluster#truststore_password_uri}
     */
    readonly truststorePasswordUri?: string;
    /**
     * The Cloud Storage URI of the truststore file used for SSL encryption.
     *
     * If not provided, Dataproc will provide a self-signed certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#truststore_uri DataprocCluster#truststore_uri}
     */
    readonly truststoreUri?: string;
}
export declare class DataprocClusterClusterConfigSecurityConfigKerberosConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _crossRealmTrustAdminServer?;
    get crossRealmTrustAdminServer(): string | undefined;
    set crossRealmTrustAdminServer(value: string | undefined);
    resetCrossRealmTrustAdminServer(): void;
    get crossRealmTrustAdminServerInput(): string | undefined;
    private _crossRealmTrustKdc?;
    get crossRealmTrustKdc(): string | undefined;
    set crossRealmTrustKdc(value: string | undefined);
    resetCrossRealmTrustKdc(): void;
    get crossRealmTrustKdcInput(): string | undefined;
    private _crossRealmTrustRealm?;
    get crossRealmTrustRealm(): string | undefined;
    set crossRealmTrustRealm(value: string | undefined);
    resetCrossRealmTrustRealm(): void;
    get crossRealmTrustRealmInput(): string | undefined;
    private _crossRealmTrustSharedPasswordUri?;
    get crossRealmTrustSharedPasswordUri(): string | undefined;
    set crossRealmTrustSharedPasswordUri(value: string | undefined);
    resetCrossRealmTrustSharedPasswordUri(): void;
    get crossRealmTrustSharedPasswordUriInput(): string | undefined;
    private _enableKerberos?;
    get enableKerberos(): boolean | cdktf.IResolvable | undefined;
    set enableKerberos(value: boolean | cdktf.IResolvable | undefined);
    resetEnableKerberos(): void;
    get enableKerberosInput(): boolean | cdktf.IResolvable | undefined;
    private _kdcDbKeyUri?;
    get kdcDbKeyUri(): string | undefined;
    set kdcDbKeyUri(value: string | undefined);
    resetKdcDbKeyUri(): void;
    get kdcDbKeyUriInput(): string | undefined;
    private _keyPasswordUri?;
    get keyPasswordUri(): string | undefined;
    set keyPasswordUri(value: string | undefined);
    resetKeyPasswordUri(): void;
    get keyPasswordUriInput(): string | undefined;
    private _keystorePasswordUri?;
    get keystorePasswordUri(): string | undefined;
    set keystorePasswordUri(value: string | undefined);
    resetKeystorePasswordUri(): void;
    get keystorePasswordUriInput(): string | undefined;
    private _keystoreUri?;
    get keystoreUri(): string | undefined;
    set keystoreUri(value: string | undefined);
    resetKeystoreUri(): void;
    get keystoreUriInput(): string | undefined;
    private _kmsKeyUri?;
    get kmsKeyUri(): string;
    set kmsKeyUri(value: string);
    get kmsKeyUriInput(): string | undefined;
    private _realm?;
    get realm(): string | undefined;
    set realm(value: string | undefined);
    resetRealm(): void;
    get realmInput(): string | undefined;
    private _rootPrincipalPasswordUri?;
    get rootPrincipalPasswordUri(): string;
    set rootPrincipalPasswordUri(value: string);
    get rootPrincipalPasswordUriInput(): string | undefined;
    private _tgtLifetimeHours?;
    get tgtLifetimeHours(): number | undefined;
    set tgtLifetimeHours(value: number | undefined);
    resetTgtLifetimeHours(): void;
    get tgtLifetimeHoursInput(): number | undefined;
    private _truststorePasswordUri?;
    get truststorePasswordUri(): string | undefined;
    set truststorePasswordUri(value: string | undefined);
    resetTruststorePasswordUri(): void;
    get truststorePasswordUriInput(): string | undefined;
    private _truststoreUri?;
    get truststoreUri(): string | undefined;
    set truststoreUri(value: string | undefined);
    resetTruststoreUri(): void;
    get truststoreUriInput(): string | undefined;
}
export interface DataprocClusterClusterConfigSecurityConfig {
    /**
     * kerberos_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#kerberos_config DataprocCluster#kerberos_config}
     */
    readonly kerberosConfig: DataprocClusterClusterConfigSecurityConfigKerberosConfig;
}
export declare class DataprocClusterClusterConfigSecurityConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kerberosConfig?;
    private __kerberosConfigOutput;
    get kerberosConfig(): DataprocClusterClusterConfigSecurityConfigKerberosConfigOutputReference;
    putKerberosConfig(value: DataprocClusterClusterConfigSecurityConfigKerberosConfig): void;
    get kerberosConfigInput(): DataprocClusterClusterConfigSecurityConfigKerberosConfig | undefined;
}
export interface DataprocClusterClusterConfigSoftwareConfig {
    /**
     * The Cloud Dataproc image version to use for the cluster - this controls the sets of software versions installed onto the nodes when you create clusters.
     *
     * If not specified, defaults to the latest version.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#image_version DataprocCluster#image_version}
     */
    readonly imageVersion?: string;
    /**
     * The set of optional components to activate on the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#optional_components DataprocCluster#optional_components}
     */
    readonly optionalComponents?: string[];
    /**
     * A list of override and additional properties (key/value pairs) used to modify various aspects of the common configuration files used when creating a cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#override_properties DataprocCluster#override_properties}
     */
    readonly overrideProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare class DataprocClusterClusterConfigSoftwareConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _imageVersion?;
    get imageVersion(): string | undefined;
    set imageVersion(value: string | undefined);
    resetImageVersion(): void;
    get imageVersionInput(): string | undefined;
    private _optionalComponents?;
    get optionalComponents(): string[] | undefined;
    set optionalComponents(value: string[] | undefined);
    resetOptionalComponents(): void;
    get optionalComponentsInput(): string[] | undefined;
    private _overrideProperties?;
    get overrideProperties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set overrideProperties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetOverrideProperties(): void;
    get overridePropertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
export interface DataprocClusterClusterConfigWorkerConfigAccelerators {
    /**
     * The number of the accelerator cards of this type exposed to this instance.
     *
     * Often restricted to one of 1, 2, 4, or 8.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#accelerator_count DataprocCluster#accelerator_count}
     */
    readonly acceleratorCount: number;
    /**
     * The short name of the accelerator type to expose to this instance. For example, nvidia-tesla-k80.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#accelerator_type DataprocCluster#accelerator_type}
     */
    readonly acceleratorType: string;
}
export interface DataprocClusterClusterConfigWorkerConfigDiskConfig {
    /**
     * Size of the primary disk attached to each node, specified in GB.
     *
     * The primary disk contains the boot volume and system libraries, and the smallest allowed disk size is 10GB. GCP will default to a predetermined computed value if not set (currently 500GB). Note: If SSDs are not attached, it also contains the HDFS data blocks and Hadoop working directories.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#boot_disk_size_gb DataprocCluster#boot_disk_size_gb}
     */
    readonly bootDiskSizeGb?: number;
    /**
     * The disk type of the primary disk attached to each node. One of "pd-ssd" or "pd-standard". Defaults to "pd-standard".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#boot_disk_type DataprocCluster#boot_disk_type}
     */
    readonly bootDiskType?: string;
    /**
     * The amount of local SSD disks that will be attached to each master cluster node. Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#num_local_ssds DataprocCluster#num_local_ssds}
     */
    readonly numLocalSsds?: number;
}
export declare class DataprocClusterClusterConfigWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number | undefined;
    set bootDiskSizeGb(value: number | undefined);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string | undefined;
    set bootDiskType(value: string | undefined);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number | undefined;
    set numLocalSsds(value: number | undefined);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocClusterClusterConfigWorkerConfig {
    /**
     * The URI for the image to use for this master/worker.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#image_uri DataprocCluster#image_uri}
     */
    readonly imageUri?: string;
    /**
     * The name of a Google Compute Engine machine type to create for the master/worker.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#machine_type DataprocCluster#machine_type}
     */
    readonly machineType?: string;
    /**
     * The name of a minimum generation of CPU family for the master/worker.
     *
     * If not specified, GCP will default to a predetermined computed value for each zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#min_cpu_platform DataprocCluster#min_cpu_platform}
     */
    readonly minCpuPlatform?: string;
    /**
     * Specifies the number of master/worker nodes to create. If not specified, GCP will default to a predetermined computed value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#num_instances DataprocCluster#num_instances}
     */
    readonly numInstances?: number;
    /**
     * accelerators block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#accelerators DataprocCluster#accelerators}
     */
    readonly accelerators?: DataprocClusterClusterConfigWorkerConfigAccelerators[];
    /**
     * disk_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#disk_config DataprocCluster#disk_config}
     */
    readonly diskConfig?: DataprocClusterClusterConfigWorkerConfigDiskConfig;
}
export declare class DataprocClusterClusterConfigWorkerConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _imageUri?;
    get imageUri(): string | undefined;
    set imageUri(value: string | undefined);
    resetImageUri(): void;
    get imageUriInput(): string | undefined;
    private _machineType?;
    get machineType(): string | undefined;
    set machineType(value: string | undefined);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string | undefined;
    set minCpuPlatform(value: string | undefined);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number | undefined;
    set numInstances(value: number | undefined);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _accelerators?;
    get accelerators(): DataprocClusterClusterConfigWorkerConfigAccelerators[] | undefined;
    set accelerators(value: DataprocClusterClusterConfigWorkerConfigAccelerators[] | undefined);
    resetAccelerators(): void;
    get acceleratorsInput(): DataprocClusterClusterConfigWorkerConfigAccelerators[] | undefined;
    private _diskConfig?;
    private __diskConfigOutput;
    get diskConfig(): DataprocClusterClusterConfigWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocClusterClusterConfigWorkerConfigDiskConfig | undefined): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocClusterClusterConfigWorkerConfigDiskConfig | undefined;
}
export interface DataprocClusterClusterConfig {
    /**
     * The Cloud Storage staging bucket used to stage files, such as Hadoop jars, between client machines and the cluster.
     *
     * Note: If you don't explicitly specify a staging_bucket then GCP will auto create / assign one for you. However, you are not guaranteed an auto generated bucket which is solely dedicated to your cluster; it may be shared with other clusters in the same region/zone also choosing to use the auto generation option.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#staging_bucket DataprocCluster#staging_bucket}
     */
    readonly stagingBucket?: string;
    /**
     * The Cloud Storage temp bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files.
     *
     * Note: If you don't explicitly specify a temp_bucket then GCP will auto create / assign one for you.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#temp_bucket DataprocCluster#temp_bucket}
     */
    readonly tempBucket?: string;
    /**
     * autoscaling_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#autoscaling_config DataprocCluster#autoscaling_config}
     */
    readonly autoscalingConfig?: DataprocClusterClusterConfigAutoscalingConfig;
    /**
     * encryption_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#encryption_config DataprocCluster#encryption_config}
     */
    readonly encryptionConfig?: DataprocClusterClusterConfigEncryptionConfig;
    /**
     * gce_cluster_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#gce_cluster_config DataprocCluster#gce_cluster_config}
     */
    readonly gceClusterConfig?: DataprocClusterClusterConfigGceClusterConfig;
    /**
     * initialization_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#initialization_action DataprocCluster#initialization_action}
     */
    readonly initializationAction?: DataprocClusterClusterConfigInitializationAction[];
    /**
     * master_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#master_config DataprocCluster#master_config}
     */
    readonly masterConfig?: DataprocClusterClusterConfigMasterConfig;
    /**
     * preemptible_worker_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#preemptible_worker_config DataprocCluster#preemptible_worker_config}
     */
    readonly preemptibleWorkerConfig?: DataprocClusterClusterConfigPreemptibleWorkerConfig;
    /**
     * security_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#security_config DataprocCluster#security_config}
     */
    readonly securityConfig?: DataprocClusterClusterConfigSecurityConfig;
    /**
     * software_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#software_config DataprocCluster#software_config}
     */
    readonly softwareConfig?: DataprocClusterClusterConfigSoftwareConfig;
    /**
     * worker_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#worker_config DataprocCluster#worker_config}
     */
    readonly workerConfig?: DataprocClusterClusterConfigWorkerConfig;
}
export declare class DataprocClusterClusterConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _stagingBucket?;
    get stagingBucket(): string | undefined;
    set stagingBucket(value: string | undefined);
    resetStagingBucket(): void;
    get stagingBucketInput(): string | undefined;
    private _tempBucket?;
    get tempBucket(): string | undefined;
    set tempBucket(value: string | undefined);
    resetTempBucket(): void;
    get tempBucketInput(): string | undefined;
    private _autoscalingConfig?;
    private __autoscalingConfigOutput;
    get autoscalingConfig(): DataprocClusterClusterConfigAutoscalingConfigOutputReference;
    putAutoscalingConfig(value: DataprocClusterClusterConfigAutoscalingConfig | undefined): void;
    resetAutoscalingConfig(): void;
    get autoscalingConfigInput(): DataprocClusterClusterConfigAutoscalingConfig | undefined;
    private _encryptionConfig?;
    private __encryptionConfigOutput;
    get encryptionConfig(): DataprocClusterClusterConfigEncryptionConfigOutputReference;
    putEncryptionConfig(value: DataprocClusterClusterConfigEncryptionConfig | undefined): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): DataprocClusterClusterConfigEncryptionConfig | undefined;
    private _gceClusterConfig?;
    private __gceClusterConfigOutput;
    get gceClusterConfig(): DataprocClusterClusterConfigGceClusterConfigOutputReference;
    putGceClusterConfig(value: DataprocClusterClusterConfigGceClusterConfig | undefined): void;
    resetGceClusterConfig(): void;
    get gceClusterConfigInput(): DataprocClusterClusterConfigGceClusterConfig | undefined;
    private _initializationAction?;
    get initializationAction(): DataprocClusterClusterConfigInitializationAction[] | undefined;
    set initializationAction(value: DataprocClusterClusterConfigInitializationAction[] | undefined);
    resetInitializationAction(): void;
    get initializationActionInput(): DataprocClusterClusterConfigInitializationAction[] | undefined;
    private _masterConfig?;
    private __masterConfigOutput;
    get masterConfig(): DataprocClusterClusterConfigMasterConfigOutputReference;
    putMasterConfig(value: DataprocClusterClusterConfigMasterConfig | undefined): void;
    resetMasterConfig(): void;
    get masterConfigInput(): DataprocClusterClusterConfigMasterConfig | undefined;
    private _preemptibleWorkerConfig?;
    private __preemptibleWorkerConfigOutput;
    get preemptibleWorkerConfig(): DataprocClusterClusterConfigPreemptibleWorkerConfigOutputReference;
    putPreemptibleWorkerConfig(value: DataprocClusterClusterConfigPreemptibleWorkerConfig | undefined): void;
    resetPreemptibleWorkerConfig(): void;
    get preemptibleWorkerConfigInput(): DataprocClusterClusterConfigPreemptibleWorkerConfig | undefined;
    private _securityConfig?;
    private __securityConfigOutput;
    get securityConfig(): DataprocClusterClusterConfigSecurityConfigOutputReference;
    putSecurityConfig(value: DataprocClusterClusterConfigSecurityConfig | undefined): void;
    resetSecurityConfig(): void;
    get securityConfigInput(): DataprocClusterClusterConfigSecurityConfig | undefined;
    private _softwareConfig?;
    private __softwareConfigOutput;
    get softwareConfig(): DataprocClusterClusterConfigSoftwareConfigOutputReference;
    putSoftwareConfig(value: DataprocClusterClusterConfigSoftwareConfig | undefined): void;
    resetSoftwareConfig(): void;
    get softwareConfigInput(): DataprocClusterClusterConfigSoftwareConfig | undefined;
    private _workerConfig?;
    private __workerConfigOutput;
    get workerConfig(): DataprocClusterClusterConfigWorkerConfigOutputReference;
    putWorkerConfig(value: DataprocClusterClusterConfigWorkerConfig | undefined): void;
    resetWorkerConfig(): void;
    get workerConfigInput(): DataprocClusterClusterConfigWorkerConfig | undefined;
}
export interface DataprocClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#create DataprocCluster#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#delete DataprocCluster#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html#update DataprocCluster#update}.
     */
    readonly update?: string;
}
export declare class DataprocClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html google_dataproc_cluster}.
 */
export declare class DataprocCluster extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster.html google_dataproc_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataprocClusterConfig);
    private _gracefulDecommissionTimeout?;
    get gracefulDecommissionTimeout(): string | undefined;
    set gracefulDecommissionTimeout(value: string | undefined);
    resetGracefulDecommissionTimeout(): void;
    get gracefulDecommissionTimeoutInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _clusterConfig?;
    private __clusterConfigOutput;
    get clusterConfig(): DataprocClusterClusterConfigOutputReference;
    putClusterConfig(value: DataprocClusterClusterConfig | undefined): void;
    resetClusterConfig(): void;
    get clusterConfigInput(): DataprocClusterClusterConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DataprocClusterTimeoutsOutputReference;
    putTimeouts(value: DataprocClusterTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataprocClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
