import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataprocAutoscalingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The  location where the autoscaling policy should reside. The default value is 'global'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#location DataprocAutoscalingPolicy#location}
     */
    readonly location?: string;
    /**
     * The policy id.
     *
     * The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
     * and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
     * 3 and 50 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#policy_id DataprocAutoscalingPolicy#policy_id}
     */
    readonly policyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#project DataprocAutoscalingPolicy#project}.
     */
    readonly project?: string;
    /**
     * basic_algorithm block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#basic_algorithm DataprocAutoscalingPolicy#basic_algorithm}
     */
    readonly basicAlgorithm?: DataprocAutoscalingPolicyBasicAlgorithm;
    /**
     * secondary_worker_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#secondary_worker_config DataprocAutoscalingPolicy#secondary_worker_config}
     */
    readonly secondaryWorkerConfig?: DataprocAutoscalingPolicySecondaryWorkerConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#timeouts DataprocAutoscalingPolicy#timeouts}
     */
    readonly timeouts?: DataprocAutoscalingPolicyTimeouts;
    /**
     * worker_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#worker_config DataprocAutoscalingPolicy#worker_config}
     */
    readonly workerConfig?: DataprocAutoscalingPolicyWorkerConfig;
}
export interface DataprocAutoscalingPolicyBasicAlgorithmYarnConfig {
    /**
     * Timeout for YARN graceful decommissioning of Node Managers.
     *
     * Specifies the
     * duration to wait for jobs to complete before forcefully removing workers
     * (and potentially interrupting jobs). Only applicable to downscaling operations.
     *
     * Bounds: [0s, 1d].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#graceful_decommission_timeout DataprocAutoscalingPolicy#graceful_decommission_timeout}
     */
    readonly gracefulDecommissionTimeout: string;
    /**
     * Fraction of average pending memory in the last cooldown period for which to remove workers.
     *
     * A scale-down factor of 1 will result in scaling down so that there
     * is no available memory remaining after the update (more aggressive scaling).
     * A scale-down factor of 0 disables removing workers, which can be beneficial for
     * autoscaling a single job.
     *
     * Bounds: [0.0, 1.0].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#scale_down_factor DataprocAutoscalingPolicy#scale_down_factor}
     */
    readonly scaleDownFactor: number;
    /**
     * Minimum scale-down threshold as a fraction of total cluster size before scaling occurs.
     *
     * For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must
     * recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0
     * means the autoscaler will scale down on any recommended change.
     *
     * Bounds: [0.0, 1.0]. Default: 0.0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#scale_down_min_worker_fraction DataprocAutoscalingPolicy#scale_down_min_worker_fraction}
     */
    readonly scaleDownMinWorkerFraction?: number;
    /**
     * Fraction of average pending memory in the last cooldown period for which to add workers.
     *
     * A scale-up factor of 1.0 will result in scaling up so that there
     * is no pending memory remaining after the update (more aggressive scaling).
     * A scale-up factor closer to 0 will result in a smaller magnitude of scaling up
     * (less aggressive scaling).
     *
     * Bounds: [0.0, 1.0].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#scale_up_factor DataprocAutoscalingPolicy#scale_up_factor}
     */
    readonly scaleUpFactor: number;
    /**
     * Minimum scale-up threshold as a fraction of total cluster size before scaling occurs.
     *
     * For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler
     * must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of
     * 0 means the autoscaler will scale up on any recommended change.
     *
     * Bounds: [0.0, 1.0]. Default: 0.0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#scale_up_min_worker_fraction DataprocAutoscalingPolicy#scale_up_min_worker_fraction}
     */
    readonly scaleUpMinWorkerFraction?: number;
}
export declare class DataprocAutoscalingPolicyBasicAlgorithmYarnConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _gracefulDecommissionTimeout?;
    get gracefulDecommissionTimeout(): string;
    set gracefulDecommissionTimeout(value: string);
    get gracefulDecommissionTimeoutInput(): string | undefined;
    private _scaleDownFactor?;
    get scaleDownFactor(): number;
    set scaleDownFactor(value: number);
    get scaleDownFactorInput(): number | undefined;
    private _scaleDownMinWorkerFraction?;
    get scaleDownMinWorkerFraction(): number | undefined;
    set scaleDownMinWorkerFraction(value: number | undefined);
    resetScaleDownMinWorkerFraction(): void;
    get scaleDownMinWorkerFractionInput(): number | undefined;
    private _scaleUpFactor?;
    get scaleUpFactor(): number;
    set scaleUpFactor(value: number);
    get scaleUpFactorInput(): number | undefined;
    private _scaleUpMinWorkerFraction?;
    get scaleUpMinWorkerFraction(): number | undefined;
    set scaleUpMinWorkerFraction(value: number | undefined);
    resetScaleUpMinWorkerFraction(): void;
    get scaleUpMinWorkerFractionInput(): number | undefined;
}
export interface DataprocAutoscalingPolicyBasicAlgorithm {
    /**
     * Duration between scaling events. A scaling period starts after the update operation from the previous event has completed.
     *
     * Bounds: [2m, 1d]. Default: 2m.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#cooldown_period DataprocAutoscalingPolicy#cooldown_period}
     */
    readonly cooldownPeriod?: string;
    /**
     * yarn_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#yarn_config DataprocAutoscalingPolicy#yarn_config}
     */
    readonly yarnConfig: DataprocAutoscalingPolicyBasicAlgorithmYarnConfig;
}
export declare class DataprocAutoscalingPolicyBasicAlgorithmOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cooldownPeriod?;
    get cooldownPeriod(): string | undefined;
    set cooldownPeriod(value: string | undefined);
    resetCooldownPeriod(): void;
    get cooldownPeriodInput(): string | undefined;
    private _yarnConfig?;
    private __yarnConfigOutput;
    get yarnConfig(): DataprocAutoscalingPolicyBasicAlgorithmYarnConfigOutputReference;
    putYarnConfig(value: DataprocAutoscalingPolicyBasicAlgorithmYarnConfig): void;
    get yarnConfigInput(): DataprocAutoscalingPolicyBasicAlgorithmYarnConfig | undefined;
}
export interface DataprocAutoscalingPolicySecondaryWorkerConfig {
    /**
     * Maximum number of instances for this group.
     *
     * Note that by default, clusters will not use
     * secondary workers. Required for secondary workers if the minimum secondary instances is set.
     * Bounds: [minInstances, ). Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#max_instances DataprocAutoscalingPolicy#max_instances}
     */
    readonly maxInstances?: number;
    /**
     * Minimum number of instances for this group. Bounds: [0, maxInstances]. Defaults to 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#min_instances DataprocAutoscalingPolicy#min_instances}
     */
    readonly minInstances?: number;
    /**
     * Weight for the instance group, which is used to determine the fraction of total workers in the cluster from this instance group.
     *
     * For example, if primary workers have weight 2,
     * and secondary workers have weight 1, the cluster will have approximately 2 primary workers
     * for each secondary worker.
     *
     * The cluster may not reach the specified balance if constrained by min/max bounds or other
     * autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
     * primary workers will be added. The cluster can also be out of balance when created.
     *
     * If weight is not set on any instance group, the cluster will default to equal weight for
     * all groups: the cluster will attempt to maintain an equal number of workers in each group
     * within the configured size bounds for each group. If weight is set for one group only,
     * the cluster will default to zero weight on the unset group. For example if weight is set
     * only on primary workers, the cluster will use primary workers only and no secondary workers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#weight DataprocAutoscalingPolicy#weight}
     */
    readonly weight?: number;
}
export declare class DataprocAutoscalingPolicySecondaryWorkerConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxInstances?;
    get maxInstances(): number | undefined;
    set maxInstances(value: number | undefined);
    resetMaxInstances(): void;
    get maxInstancesInput(): number | undefined;
    private _minInstances?;
    get minInstances(): number | undefined;
    set minInstances(value: number | undefined);
    resetMinInstances(): void;
    get minInstancesInput(): number | undefined;
    private _weight?;
    get weight(): number | undefined;
    set weight(value: number | undefined);
    resetWeight(): void;
    get weightInput(): number | undefined;
}
export interface DataprocAutoscalingPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#create DataprocAutoscalingPolicy#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#delete DataprocAutoscalingPolicy#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#update DataprocAutoscalingPolicy#update}.
     */
    readonly update?: string;
}
export declare class DataprocAutoscalingPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DataprocAutoscalingPolicyWorkerConfig {
    /**
     * Maximum number of instances for this group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#max_instances DataprocAutoscalingPolicy#max_instances}
     */
    readonly maxInstances: number;
    /**
     * Minimum number of instances for this group. Bounds: [2, maxInstances]. Defaults to 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#min_instances DataprocAutoscalingPolicy#min_instances}
     */
    readonly minInstances?: number;
    /**
     * Weight for the instance group, which is used to determine the fraction of total workers in the cluster from this instance group.
     *
     * For example, if primary workers have weight 2,
     * and secondary workers have weight 1, the cluster will have approximately 2 primary workers
     * for each secondary worker.
     *
     * The cluster may not reach the specified balance if constrained by min/max bounds or other
     * autoscaling settings. For example, if maxInstances for secondary workers is 0, then only
     * primary workers will be added. The cluster can also be out of balance when created.
     *
     * If weight is not set on any instance group, the cluster will default to equal weight for
     * all groups: the cluster will attempt to maintain an equal number of workers in each group
     * within the configured size bounds for each group. If weight is set for one group only,
     * the cluster will default to zero weight on the unset group. For example if weight is set
     * only on primary workers, the cluster will use primary workers only and no secondary workers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html#weight DataprocAutoscalingPolicy#weight}
     */
    readonly weight?: number;
}
export declare class DataprocAutoscalingPolicyWorkerConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxInstances?;
    get maxInstances(): number;
    set maxInstances(value: number);
    get maxInstancesInput(): number | undefined;
    private _minInstances?;
    get minInstances(): number | undefined;
    set minInstances(value: number | undefined);
    resetMinInstances(): void;
    get minInstancesInput(): number | undefined;
    private _weight?;
    get weight(): number | undefined;
    set weight(value: number | undefined);
    resetWeight(): void;
    get weightInput(): number | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html google_dataproc_autoscaling_policy}.
 */
export declare class DataprocAutoscalingPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy.html google_dataproc_autoscaling_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataprocAutoscalingPolicyConfig);
    get id(): string;
    private _location?;
    get location(): string | undefined;
    set location(value: string | undefined);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _basicAlgorithm?;
    private __basicAlgorithmOutput;
    get basicAlgorithm(): DataprocAutoscalingPolicyBasicAlgorithmOutputReference;
    putBasicAlgorithm(value: DataprocAutoscalingPolicyBasicAlgorithm | undefined): void;
    resetBasicAlgorithm(): void;
    get basicAlgorithmInput(): DataprocAutoscalingPolicyBasicAlgorithm | undefined;
    private _secondaryWorkerConfig?;
    private __secondaryWorkerConfigOutput;
    get secondaryWorkerConfig(): DataprocAutoscalingPolicySecondaryWorkerConfigOutputReference;
    putSecondaryWorkerConfig(value: DataprocAutoscalingPolicySecondaryWorkerConfig | undefined): void;
    resetSecondaryWorkerConfig(): void;
    get secondaryWorkerConfigInput(): DataprocAutoscalingPolicySecondaryWorkerConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DataprocAutoscalingPolicyTimeoutsOutputReference;
    putTimeouts(value: DataprocAutoscalingPolicyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataprocAutoscalingPolicyTimeouts | undefined;
    private _workerConfig?;
    private __workerConfigOutput;
    get workerConfig(): DataprocAutoscalingPolicyWorkerConfigOutputReference;
    putWorkerConfig(value: DataprocAutoscalingPolicyWorkerConfig | undefined): void;
    resetWorkerConfig(): void;
    get workerConfigInput(): DataprocAutoscalingPolicyWorkerConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
