import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataflowJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * List of experiments that should be used by the job. An example value is ["enable_stackdriver_agent_metrics"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#additional_experiments DataflowJob#additional_experiments}
     */
    readonly additionalExperiments?: string[];
    /**
     * Indicates if the job should use the streaming engine feature.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#enable_streaming_engine DataflowJob#enable_streaming_engine}
     */
    readonly enableStreamingEngine?: boolean | cdktf.IResolvable;
    /**
     * The configuration for VM IPs. Options are "WORKER_IP_PUBLIC" or "WORKER_IP_PRIVATE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#ip_configuration DataflowJob#ip_configuration}
     */
    readonly ipConfiguration?: string;
    /**
     * The name for the Cloud KMS key for the job. Key format is: projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#kms_key_name DataflowJob#kms_key_name}
     */
    readonly kmsKeyName?: string;
    /**
     * User labels to be specified for the job.
     *
     * Keys and values should follow the restrictions specified in the labeling restrictions page. NOTE: Google-provided Dataflow templates often provide default labels that begin with goog-dataflow-provided. Unless explicitly set in config, these labels will be ignored to prevent diffs on re-apply.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#labels DataflowJob#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The machine type to use for the job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#machine_type DataflowJob#machine_type}
     */
    readonly machineType?: string;
    /**
     * The number of workers permitted to work on the job. More workers may improve processing speed at additional cost.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#max_workers DataflowJob#max_workers}
     */
    readonly maxWorkers?: number;
    /**
     * A unique name for the resource, required by Dataflow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#name DataflowJob#name}
     */
    readonly name: string;
    /**
     * The network to which VMs will be assigned. If it is not provided, "default" will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#network DataflowJob#network}
     */
    readonly network?: string;
    /**
     * One of "drain" or "cancel". Specifies behavior of deletion during terraform destroy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#on_delete DataflowJob#on_delete}
     */
    readonly onDelete?: string;
    /**
     * Key/Value pairs to be passed to the Dataflow job (as used in the template).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#parameters DataflowJob#parameters}
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The project in which the resource belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#project DataflowJob#project}
     */
    readonly project?: string;
    /**
     * The region in which the created job should run.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#region DataflowJob#region}
     */
    readonly region?: string;
    /**
     * The Service Account email used to create the job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#service_account_email DataflowJob#service_account_email}
     */
    readonly serviceAccountEmail?: string;
    /**
     * The subnetwork to which VMs will be assigned. Should be of the form "regions/REGION/subnetworks/SUBNETWORK".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#subnetwork DataflowJob#subnetwork}
     */
    readonly subnetwork?: string;
    /**
     * A writeable location on Google Cloud Storage for the Dataflow job to dump its temporary data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#temp_gcs_location DataflowJob#temp_gcs_location}
     */
    readonly tempGcsLocation: string;
    /**
     * The Google Cloud Storage path to the Dataflow job template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#template_gcs_path DataflowJob#template_gcs_path}
     */
    readonly templateGcsPath: string;
    /**
     * Only applicable when updating a pipeline.
     *
     * Map of transform name prefixes of the job to be replaced with the corresponding name prefixes of the new job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#transform_name_mapping DataflowJob#transform_name_mapping}
     */
    readonly transformNameMapping?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The zone in which the created job should run. If it is not provided, the provider zone is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#zone DataflowJob#zone}
     */
    readonly zone?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#timeouts DataflowJob#timeouts}
     */
    readonly timeouts?: DataflowJobTimeouts;
}
export interface DataflowJobTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html#update DataflowJob#update}.
     */
    readonly update?: string;
}
export declare class DataflowJobTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html google_dataflow_job}.
 */
export declare class DataflowJob extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataflow_job.html google_dataflow_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataflowJobConfig);
    private _additionalExperiments?;
    get additionalExperiments(): string[] | undefined;
    set additionalExperiments(value: string[] | undefined);
    resetAdditionalExperiments(): void;
    get additionalExperimentsInput(): string[] | undefined;
    private _enableStreamingEngine?;
    get enableStreamingEngine(): boolean | cdktf.IResolvable | undefined;
    set enableStreamingEngine(value: boolean | cdktf.IResolvable | undefined);
    resetEnableStreamingEngine(): void;
    get enableStreamingEngineInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _ipConfiguration?;
    get ipConfiguration(): string | undefined;
    set ipConfiguration(value: string | undefined);
    resetIpConfiguration(): void;
    get ipConfigurationInput(): string | undefined;
    get jobId(): string;
    private _kmsKeyName?;
    get kmsKeyName(): string | undefined;
    set kmsKeyName(value: string | undefined);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    get machineType(): string | undefined;
    set machineType(value: string | undefined);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _maxWorkers?;
    get maxWorkers(): number | undefined;
    set maxWorkers(value: number | undefined);
    resetMaxWorkers(): void;
    get maxWorkersInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string | undefined;
    set network(value: string | undefined);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _onDelete?;
    get onDelete(): string | undefined;
    set onDelete(value: string | undefined);
    resetOnDelete(): void;
    get onDeleteInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetParameters(): void;
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string | undefined;
    set serviceAccountEmail(value: string | undefined);
    resetServiceAccountEmail(): void;
    get serviceAccountEmailInput(): string | undefined;
    get state(): string;
    private _subnetwork?;
    get subnetwork(): string | undefined;
    set subnetwork(value: string | undefined);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tempGcsLocation?;
    get tempGcsLocation(): string;
    set tempGcsLocation(value: string);
    get tempGcsLocationInput(): string | undefined;
    private _templateGcsPath?;
    get templateGcsPath(): string;
    set templateGcsPath(value: string);
    get templateGcsPathInput(): string | undefined;
    private _transformNameMapping?;
    get transformNameMapping(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set transformNameMapping(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetTransformNameMapping(): void;
    get transformNameMappingInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    get type(): string;
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DataflowJobTimeoutsOutputReference;
    putTimeouts(value: DataflowJobTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataflowJobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
