import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLossPreventionStoredInfoTypeConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of the info type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#description DataLossPreventionStoredInfoType#description}
     */
    readonly description?: string;
    /**
     * User set display name of the info type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#display_name DataLossPreventionStoredInfoType#display_name}
     */
    readonly displayName?: string;
    /**
     * The parent of the info type in any of the following formats:.
     *
     * 'projects/{{project}}'
     * 'projects/{{project}}/locations/{{location}}'
     * 'organizations/{{organization_id}}'
     * 'organizations/{{organization_id}}/locations/{{location}}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#parent DataLossPreventionStoredInfoType#parent}
     */
    readonly parent: string;
    /**
     * dictionary block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#dictionary DataLossPreventionStoredInfoType#dictionary}
     */
    readonly dictionary?: DataLossPreventionStoredInfoTypeDictionary;
    /**
     * large_custom_dictionary block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#large_custom_dictionary DataLossPreventionStoredInfoType#large_custom_dictionary}
     */
    readonly largeCustomDictionary?: DataLossPreventionStoredInfoTypeLargeCustomDictionary;
    /**
     * regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#regex DataLossPreventionStoredInfoType#regex}
     */
    readonly regex?: DataLossPreventionStoredInfoTypeRegex;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#timeouts DataLossPreventionStoredInfoType#timeouts}
     */
    readonly timeouts?: DataLossPreventionStoredInfoTypeTimeouts;
}
export interface DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath {
    /**
     * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#path DataLossPreventionStoredInfoType#path}
     */
    readonly path: string;
}
export declare class DataLossPreventionStoredInfoTypeDictionaryCloudStoragePathOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface DataLossPreventionStoredInfoTypeDictionaryWordList {
    /**
     * Words or phrases defining the dictionary.
     *
     * The dictionary must contain at least one
     * phrase and every phrase must contain at least 2 characters that are letters or digits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#words DataLossPreventionStoredInfoType#words}
     */
    readonly words: string[];
}
export declare class DataLossPreventionStoredInfoTypeDictionaryWordListOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _words?;
    get words(): string[];
    set words(value: string[]);
    get wordsInput(): string[] | undefined;
}
export interface DataLossPreventionStoredInfoTypeDictionary {
    /**
     * cloud_storage_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#cloud_storage_path DataLossPreventionStoredInfoType#cloud_storage_path}
     */
    readonly cloudStoragePath?: DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath;
    /**
     * word_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#word_list DataLossPreventionStoredInfoType#word_list}
     */
    readonly wordList?: DataLossPreventionStoredInfoTypeDictionaryWordList;
}
export declare class DataLossPreventionStoredInfoTypeDictionaryOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cloudStoragePath?;
    private __cloudStoragePathOutput;
    get cloudStoragePath(): DataLossPreventionStoredInfoTypeDictionaryCloudStoragePathOutputReference;
    putCloudStoragePath(value: DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath | undefined): void;
    resetCloudStoragePath(): void;
    get cloudStoragePathInput(): DataLossPreventionStoredInfoTypeDictionaryCloudStoragePath | undefined;
    private _wordList?;
    private __wordListOutput;
    get wordList(): DataLossPreventionStoredInfoTypeDictionaryWordListOutputReference;
    putWordList(value: DataLossPreventionStoredInfoTypeDictionaryWordList | undefined): void;
    resetWordList(): void;
    get wordListInput(): DataLossPreventionStoredInfoTypeDictionaryWordList | undefined;
}
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField {
    /**
     * Name describing the field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#name DataLossPreventionStoredInfoType#name}
     */
    readonly name: string;
}
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable {
    /**
     * The dataset ID of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#dataset_id DataLossPreventionStoredInfoType#dataset_id}
     */
    readonly datasetId: string;
    /**
     * The Google Cloud Platform project ID of the project containing the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#project_id DataLossPreventionStoredInfoType#project_id}
     */
    readonly projectId: string;
    /**
     * The name of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#table_id DataLossPreventionStoredInfoType#table_id}
     */
    readonly tableId: string;
}
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField {
    /**
     * field block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#field DataLossPreventionStoredInfoType#field}
     */
    readonly field: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField;
    /**
     * table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#table DataLossPreventionStoredInfoType#table}
     */
    readonly table: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable;
}
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _field?;
    private __fieldOutput;
    get field(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldFieldOutputReference;
    putField(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField): void;
    get fieldInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldField | undefined;
    private _table?;
    private __tableOutput;
    get table(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTableOutputReference;
    putTable(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable): void;
    get tableInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldTable | undefined;
}
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet {
    /**
     * The url, in the format 'gs://<bucket>/<path>'. Trailing wildcard in the path is allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#url DataLossPreventionStoredInfoType#url}
     */
    readonly url: string;
}
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath {
    /**
     * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#path DataLossPreventionStoredInfoType#path}
     */
    readonly path: string;
}
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface DataLossPreventionStoredInfoTypeLargeCustomDictionary {
    /**
     * big_query_field block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#big_query_field DataLossPreventionStoredInfoType#big_query_field}
     */
    readonly bigQueryField?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField;
    /**
     * cloud_storage_file_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#cloud_storage_file_set DataLossPreventionStoredInfoType#cloud_storage_file_set}
     */
    readonly cloudStorageFileSet?: DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet;
    /**
     * output_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#output_path DataLossPreventionStoredInfoType#output_path}
     */
    readonly outputPath: DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath;
}
export declare class DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bigQueryField?;
    private __bigQueryFieldOutput;
    get bigQueryField(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryFieldOutputReference;
    putBigQueryField(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField | undefined): void;
    resetBigQueryField(): void;
    get bigQueryFieldInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryBigQueryField | undefined;
    private _cloudStorageFileSet?;
    private __cloudStorageFileSetOutput;
    get cloudStorageFileSet(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSetOutputReference;
    putCloudStorageFileSet(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet | undefined): void;
    resetCloudStorageFileSet(): void;
    get cloudStorageFileSetInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryCloudStorageFileSet | undefined;
    private _outputPath?;
    private __outputPathOutput;
    get outputPath(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPathOutputReference;
    putOutputPath(value: DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath): void;
    get outputPathInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputPath | undefined;
}
export interface DataLossPreventionStoredInfoTypeRegex {
    /**
     * The index of the submatch to extract as findings.
     *
     * When not specified, the entire match is returned. No more than 3 may be included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#group_indexes DataLossPreventionStoredInfoType#group_indexes}
     */
    readonly groupIndexes?: number[];
    /**
     * Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#pattern DataLossPreventionStoredInfoType#pattern}
     */
    readonly pattern: string;
}
export declare class DataLossPreventionStoredInfoTypeRegexOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _groupIndexes?;
    get groupIndexes(): number[] | undefined;
    set groupIndexes(value: number[] | undefined);
    resetGroupIndexes(): void;
    get groupIndexesInput(): number[] | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    get patternInput(): string | undefined;
}
export interface DataLossPreventionStoredInfoTypeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#create DataLossPreventionStoredInfoType#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#delete DataLossPreventionStoredInfoType#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html#update DataLossPreventionStoredInfoType#update}.
     */
    readonly update?: string;
}
export declare class DataLossPreventionStoredInfoTypeTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html google_data_loss_prevention_stored_info_type}.
 */
export declare class DataLossPreventionStoredInfoType extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_stored_info_type.html google_data_loss_prevention_stored_info_type} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataLossPreventionStoredInfoTypeConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _dictionary?;
    private __dictionaryOutput;
    get dictionary(): DataLossPreventionStoredInfoTypeDictionaryOutputReference;
    putDictionary(value: DataLossPreventionStoredInfoTypeDictionary | undefined): void;
    resetDictionary(): void;
    get dictionaryInput(): DataLossPreventionStoredInfoTypeDictionary | undefined;
    private _largeCustomDictionary?;
    private __largeCustomDictionaryOutput;
    get largeCustomDictionary(): DataLossPreventionStoredInfoTypeLargeCustomDictionaryOutputReference;
    putLargeCustomDictionary(value: DataLossPreventionStoredInfoTypeLargeCustomDictionary | undefined): void;
    resetLargeCustomDictionary(): void;
    get largeCustomDictionaryInput(): DataLossPreventionStoredInfoTypeLargeCustomDictionary | undefined;
    private _regex?;
    private __regexOutput;
    get regex(): DataLossPreventionStoredInfoTypeRegexOutputReference;
    putRegex(value: DataLossPreventionStoredInfoTypeRegex | undefined): void;
    resetRegex(): void;
    get regexInput(): DataLossPreventionStoredInfoTypeRegex | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DataLossPreventionStoredInfoTypeTimeoutsOutputReference;
    putTimeouts(value: DataLossPreventionStoredInfoTypeTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataLossPreventionStoredInfoTypeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
