import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLossPreventionJobTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of the job trigger.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#description DataLossPreventionJobTrigger#description}
     */
    readonly description?: string;
    /**
     * User set display name of the job trigger.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#display_name DataLossPreventionJobTrigger#display_name}
     */
    readonly displayName?: string;
    /**
     * The parent of the trigger, either in the format 'projects/{{project}}' or 'projects/{{project}}/locations/{{location}}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#parent DataLossPreventionJobTrigger#parent}
     */
    readonly parent: string;
    /**
     * Whether the trigger is currently active. Default value: "HEALTHY" Possible values: ["PAUSED", "HEALTHY", "CANCELLED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#status DataLossPreventionJobTrigger#status}
     */
    readonly status?: string;
    /**
     * inspect_job block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#inspect_job DataLossPreventionJobTrigger#inspect_job}
     */
    readonly inspectJob?: DataLossPreventionJobTriggerInspectJob;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#timeouts DataLossPreventionJobTrigger#timeouts}
     */
    readonly timeouts?: DataLossPreventionJobTriggerTimeouts;
    /**
     * triggers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#triggers DataLossPreventionJobTrigger#triggers}
     */
    readonly triggers: DataLossPreventionJobTriggerTriggers[];
}
export interface DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable {
    /**
     * Dataset ID of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#dataset_id DataLossPreventionJobTrigger#dataset_id}
     */
    readonly datasetId: string;
    /**
     * The Google Cloud Platform project ID of the project containing the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#project_id DataLossPreventionJobTrigger#project_id}
     */
    readonly projectId: string;
    /**
     * Name of the table.
     *
     * If is not set a new one will be generated for you with the following format:
     * 'dlp_googleapis_yyyy_mm_dd_[dlp_job_id]'. Pacific timezone will be used for generating the date details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#table_id DataLossPreventionJobTrigger#table_id}
     */
    readonly tableId?: string;
}
export declare class DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string | undefined;
    set tableId(value: string | undefined);
    resetTableId(): void;
    get tableIdInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig {
    /**
     * Schema used for writing the findings for Inspect jobs.
     *
     * This field is only used for
     * Inspect and must be unspecified for Risk jobs. Columns are derived from the Finding
     * object. If appending to an existing table, any columns from the predefined schema
     * that are missing will be added. No columns in the existing table will be deleted.
     *
     * If unspecified, then all available columns will be used for a new table or an (existing)
     * table with no schema, and no changes will be made to an existing table that has a schema.
     * Only for use with external storage. Possible values: ["BASIC_COLUMNS", "GCS_COLUMNS", "DATASTORE_COLUMNS", "BIG_QUERY_COLUMNS", "ALL_COLUMNS"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#output_schema DataLossPreventionJobTrigger#output_schema}
     */
    readonly outputSchema?: string;
    /**
     * table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#table DataLossPreventionJobTrigger#table}
     */
    readonly table: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable;
}
export declare class DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _outputSchema?;
    get outputSchema(): string | undefined;
    set outputSchema(value: string | undefined);
    resetOutputSchema(): void;
    get outputSchemaInput(): string | undefined;
    private _table?;
    private __tableOutput;
    get table(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableOutputReference;
    putTable(value: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable): void;
    get tableInput(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobActionsSaveFindings {
    /**
     * output_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#output_config DataLossPreventionJobTrigger#output_config}
     */
    readonly outputConfig: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig;
}
export declare class DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _outputConfig?;
    private __outputConfigOutput;
    get outputConfig(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputReference;
    putOutputConfig(value: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig): void;
    get outputConfigInput(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobActions {
    /**
     * save_findings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#save_findings DataLossPreventionJobTrigger#save_findings}
     */
    readonly saveFindings: DataLossPreventionJobTriggerInspectJobActionsSaveFindings;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference {
    /**
     * The dataset ID of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#dataset_id DataLossPreventionJobTrigger#dataset_id}
     */
    readonly datasetId: string;
    /**
     * The Google Cloud Platform project ID of the project containing the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#project_id DataLossPreventionJobTrigger#project_id}
     */
    readonly projectId: string;
    /**
     * The name of the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#table_id DataLossPreventionJobTrigger#table_id}
     */
    readonly tableId: string;
}
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions {
    /**
     * table_reference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#table_reference DataLossPreventionJobTrigger#table_reference}
     */
    readonly tableReference: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference;
}
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _tableReference?;
    private __tableReferenceOutput;
    get tableReference(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceOutputReference;
    putTableReference(value: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference): void;
    get tableReferenceInput(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet {
    /**
     * The name of a Cloud Storage bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#bucket_name DataLossPreventionJobTrigger#bucket_name}
     */
    readonly bucketName: string;
    /**
     * A list of regular expressions matching file paths to exclude.
     *
     * All files in the bucket that match at
     * least one of these regular expressions will be excluded from the scan.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#exclude_regex DataLossPreventionJobTrigger#exclude_regex}
     */
    readonly excludeRegex?: string[];
    /**
     * A list of regular expressions matching file paths to include.
     *
     * All files in the bucket
     * that match at least one of these regular expressions will be included in the set of files,
     * except for those that also match an item in excludeRegex. Leaving this field empty will
     * match all files by default (this is equivalent to including .* in the list)
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#include_regex DataLossPreventionJobTrigger#include_regex}
     */
    readonly includeRegex?: string[];
}
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _excludeRegex?;
    get excludeRegex(): string[] | undefined;
    set excludeRegex(value: string[] | undefined);
    resetExcludeRegex(): void;
    get excludeRegexInput(): string[] | undefined;
    private _includeRegex?;
    get includeRegex(): string[] | undefined;
    set includeRegex(value: string[] | undefined);
    resetIncludeRegex(): void;
    get includeRegexInput(): string[] | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet {
    /**
     * The Cloud Storage url of the file(s) to scan, in the format 'gs://<bucket>/<path>'. Trailing wildcard in the path is allowed.
     *
     * If the url ends in a trailing slash, the bucket or directory represented by the url will be scanned
     * non-recursively (content in sub-directories will not be scanned). This means that 'gs://mybucket/' is
     * equivalent to 'gs://mybucket/*', and 'gs://mybucket/directory/' is equivalent to 'gs://mybucket/directory/*'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#url DataLossPreventionJobTrigger#url}
     */
    readonly url?: string;
    /**
     * regex_file_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#regex_file_set DataLossPreventionJobTrigger#regex_file_set}
     */
    readonly regexFileSet?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet;
}
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _url?;
    get url(): string | undefined;
    set url(value: string | undefined);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _regexFileSet?;
    private __regexFileSetOutput;
    get regexFileSet(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetOutputReference;
    putRegexFileSet(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet | undefined): void;
    resetRegexFileSet(): void;
    get regexFileSetInput(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions {
    /**
     * Max number of bytes to scan from a file.
     *
     * If a scanned file's size is bigger than this value
     * then the rest of the bytes are omitted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#bytes_limit_per_file DataLossPreventionJobTrigger#bytes_limit_per_file}
     */
    readonly bytesLimitPerFile?: number;
    /**
     * Max percentage of bytes to scan from a file.
     *
     * The rest are omitted. The number of bytes scanned is rounded down.
     * Must be between 0 and 100, inclusively. Both 0 and 100 means no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#bytes_limit_per_file_percent DataLossPreventionJobTrigger#bytes_limit_per_file_percent}
     */
    readonly bytesLimitPerFilePercent?: number;
    /**
     * List of file type groups to include in the scan.
     *
     * If empty, all files are scanned and available data
     * format processors are applied. In addition, the binary content of the selected files is always scanned as well.
     * Images are scanned only as binary if the specified region does not support image inspection and no fileTypes were specified. Possible values: ["BINARY_FILE", "TEXT_FILE", "IMAGE", "WORD", "PDF", "AVRO", "CSV", "TSV"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#file_types DataLossPreventionJobTrigger#file_types}
     */
    readonly fileTypes?: string[];
    /**
     * Limits the number of files to scan to this percentage of the input FileSet.
     *
     * Number of files scanned is rounded down.
     * Must be between 0 and 100, inclusively. Both 0 and 100 means no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#files_limit_percent DataLossPreventionJobTrigger#files_limit_percent}
     */
    readonly filesLimitPercent?: number;
    /**
     * How to sample bytes if not all bytes are scanned.
     *
     * Meaningful only when used in conjunction with bytesLimitPerFile.
     * If not specified, scanning would start from the top. Possible values: ["TOP", "RANDOM_START"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#sample_method DataLossPreventionJobTrigger#sample_method}
     */
    readonly sampleMethod?: string;
    /**
     * file_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#file_set DataLossPreventionJobTrigger#file_set}
     */
    readonly fileSet: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet;
}
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bytesLimitPerFile?;
    get bytesLimitPerFile(): number | undefined;
    set bytesLimitPerFile(value: number | undefined);
    resetBytesLimitPerFile(): void;
    get bytesLimitPerFileInput(): number | undefined;
    private _bytesLimitPerFilePercent?;
    get bytesLimitPerFilePercent(): number | undefined;
    set bytesLimitPerFilePercent(value: number | undefined);
    resetBytesLimitPerFilePercent(): void;
    get bytesLimitPerFilePercentInput(): number | undefined;
    private _fileTypes?;
    get fileTypes(): string[] | undefined;
    set fileTypes(value: string[] | undefined);
    resetFileTypes(): void;
    get fileTypesInput(): string[] | undefined;
    private _filesLimitPercent?;
    get filesLimitPercent(): number | undefined;
    set filesLimitPercent(value: number | undefined);
    resetFilesLimitPercent(): void;
    get filesLimitPercentInput(): number | undefined;
    private _sampleMethod?;
    get sampleMethod(): string | undefined;
    set sampleMethod(value: string | undefined);
    resetSampleMethod(): void;
    get sampleMethodInput(): string | undefined;
    private _fileSet?;
    private __fileSetOutput;
    get fileSet(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetOutputReference;
    putFileSet(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet): void;
    get fileSetInput(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind {
    /**
     * The name of the Datastore kind.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#name DataLossPreventionJobTrigger#name}
     */
    readonly name: string;
}
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId {
    /**
     * If not empty, the ID of the namespace to which the entities belong.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#namespace_id DataLossPreventionJobTrigger#namespace_id}
     */
    readonly namespaceId?: string;
    /**
     * The ID of the project to which the entities belong.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#project_id DataLossPreventionJobTrigger#project_id}
     */
    readonly projectId: string;
}
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _namespaceId?;
    get namespaceId(): string | undefined;
    set namespaceId(value: string | undefined);
    resetNamespaceId(): void;
    get namespaceIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions {
    /**
     * kind block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#kind DataLossPreventionJobTrigger#kind}
     */
    readonly kind: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind;
    /**
     * partition_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#partition_id DataLossPreventionJobTrigger#partition_id}
     */
    readonly partitionId: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId;
}
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kind?;
    private __kindOutput;
    get kind(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindOutputReference;
    putKind(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind): void;
    get kindInput(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind | undefined;
    private _partitionId?;
    private __partitionIdOutput;
    get partitionId(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdOutputReference;
    putPartitionId(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId): void;
    get partitionIdInput(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField {
    /**
     * Specification of the field containing the timestamp of scanned items. Used for data sources like Datastore and BigQuery.
     *
     * For BigQuery: Required to filter out rows based on the given start and end times. If not specified and the table was
     * modified between the given start and end times, the entire table will be scanned. The valid data types of the timestamp
     * field are: INTEGER, DATE, TIMESTAMP, or DATETIME BigQuery column.
     *
     * For Datastore. Valid data types of the timestamp field are: TIMESTAMP. Datastore entity will be scanned if the
     * timestamp property does not exist or its value is empty or invalid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#name DataLossPreventionJobTrigger#name}
     */
    readonly name: string;
}
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig {
    /**
     * When the job is started by a JobTrigger we will automatically figure out a valid startTime to avoid scanning files that have not been modified since the last time the JobTrigger executed.
     *
     * This will
     * be based on the time of the execution of the last run of the JobTrigger.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#enable_auto_population_of_timespan_config DataLossPreventionJobTrigger#enable_auto_population_of_timespan_config}
     */
    readonly enableAutoPopulationOfTimespanConfig?: boolean | cdktf.IResolvable;
    /**
     * Exclude files or rows newer than this value. If set to zero, no upper time limit is applied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#end_time DataLossPreventionJobTrigger#end_time}
     */
    readonly endTime?: string;
    /**
     * Exclude files or rows older than this value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#start_time DataLossPreventionJobTrigger#start_time}
     */
    readonly startTime?: string;
    /**
     * timestamp_field block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#timestamp_field DataLossPreventionJobTrigger#timestamp_field}
     */
    readonly timestampField: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField;
}
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enableAutoPopulationOfTimespanConfig?;
    get enableAutoPopulationOfTimespanConfig(): boolean | cdktf.IResolvable | undefined;
    set enableAutoPopulationOfTimespanConfig(value: boolean | cdktf.IResolvable | undefined);
    resetEnableAutoPopulationOfTimespanConfig(): void;
    get enableAutoPopulationOfTimespanConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _endTime?;
    get endTime(): string | undefined;
    set endTime(value: string | undefined);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string | undefined;
    set startTime(value: string | undefined);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _timestampField?;
    private __timestampFieldOutput;
    get timestampField(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldOutputReference;
    putTimestampField(value: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField): void;
    get timestampFieldInput(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfig {
    /**
     * big_query_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#big_query_options DataLossPreventionJobTrigger#big_query_options}
     */
    readonly bigQueryOptions?: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions;
    /**
     * cloud_storage_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#cloud_storage_options DataLossPreventionJobTrigger#cloud_storage_options}
     */
    readonly cloudStorageOptions?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions;
    /**
     * datastore_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#datastore_options DataLossPreventionJobTrigger#datastore_options}
     */
    readonly datastoreOptions?: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions;
    /**
     * timespan_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#timespan_config DataLossPreventionJobTrigger#timespan_config}
     */
    readonly timespanConfig?: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig;
}
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bigQueryOptions?;
    private __bigQueryOptionsOutput;
    get bigQueryOptions(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsOutputReference;
    putBigQueryOptions(value: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions | undefined): void;
    resetBigQueryOptions(): void;
    get bigQueryOptionsInput(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions | undefined;
    private _cloudStorageOptions?;
    private __cloudStorageOptionsOutput;
    get cloudStorageOptions(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsOutputReference;
    putCloudStorageOptions(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions | undefined): void;
    resetCloudStorageOptions(): void;
    get cloudStorageOptionsInput(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions | undefined;
    private _datastoreOptions?;
    private __datastoreOptionsOutput;
    get datastoreOptions(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsOutputReference;
    putDatastoreOptions(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions | undefined): void;
    resetDatastoreOptions(): void;
    get datastoreOptionsInput(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions | undefined;
    private _timespanConfig?;
    private __timespanConfigOutput;
    get timespanConfig(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigOutputReference;
    putTimespanConfig(value: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig | undefined): void;
    resetTimespanConfig(): void;
    get timespanConfigInput(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig | undefined;
}
export interface DataLossPreventionJobTriggerInspectJob {
    /**
     * The name of the template to run when this job is triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#inspect_template_name DataLossPreventionJobTrigger#inspect_template_name}
     */
    readonly inspectTemplateName: string;
    /**
     * actions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#actions DataLossPreventionJobTrigger#actions}
     */
    readonly actions: DataLossPreventionJobTriggerInspectJobActions[];
    /**
     * storage_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#storage_config DataLossPreventionJobTrigger#storage_config}
     */
    readonly storageConfig: DataLossPreventionJobTriggerInspectJobStorageConfig;
}
export declare class DataLossPreventionJobTriggerInspectJobOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _inspectTemplateName?;
    get inspectTemplateName(): string;
    set inspectTemplateName(value: string);
    get inspectTemplateNameInput(): string | undefined;
    private _actions?;
    get actions(): DataLossPreventionJobTriggerInspectJobActions[];
    set actions(value: DataLossPreventionJobTriggerInspectJobActions[]);
    get actionsInput(): DataLossPreventionJobTriggerInspectJobActions[] | undefined;
    private _storageConfig?;
    private __storageConfigOutput;
    get storageConfig(): DataLossPreventionJobTriggerInspectJobStorageConfigOutputReference;
    putStorageConfig(value: DataLossPreventionJobTriggerInspectJobStorageConfig): void;
    get storageConfigInput(): DataLossPreventionJobTriggerInspectJobStorageConfig | undefined;
}
export interface DataLossPreventionJobTriggerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#create DataLossPreventionJobTrigger#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#delete DataLossPreventionJobTrigger#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#update DataLossPreventionJobTrigger#update}.
     */
    readonly update?: string;
}
export declare class DataLossPreventionJobTriggerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerTriggersSchedule {
    /**
     * With this option a job is started a regular periodic basis. For example: every day (86400 seconds).
     *
     * A scheduled start time will be skipped if the previous execution has not ended when its scheduled time occurs.
     *
     * This value must be set to a time duration greater than or equal to 1 day and can be no longer than 60 days.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#recurrence_period_duration DataLossPreventionJobTrigger#recurrence_period_duration}
     */
    readonly recurrencePeriodDuration?: string;
}
export declare class DataLossPreventionJobTriggerTriggersScheduleOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _recurrencePeriodDuration?;
    get recurrencePeriodDuration(): string | undefined;
    set recurrencePeriodDuration(value: string | undefined);
    resetRecurrencePeriodDuration(): void;
    get recurrencePeriodDurationInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerTriggers {
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html#schedule DataLossPreventionJobTrigger#schedule}
     */
    readonly schedule?: DataLossPreventionJobTriggerTriggersSchedule;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html google_data_loss_prevention_job_trigger}.
 */
export declare class DataLossPreventionJobTrigger extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger.html google_data_loss_prevention_job_trigger} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataLossPreventionJobTriggerConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    get lastRunTime(): string;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _status?;
    get status(): string | undefined;
    set status(value: string | undefined);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _inspectJob?;
    private __inspectJobOutput;
    get inspectJob(): DataLossPreventionJobTriggerInspectJobOutputReference;
    putInspectJob(value: DataLossPreventionJobTriggerInspectJob | undefined): void;
    resetInspectJob(): void;
    get inspectJobInput(): DataLossPreventionJobTriggerInspectJob | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DataLossPreventionJobTriggerTimeoutsOutputReference;
    putTimeouts(value: DataLossPreventionJobTriggerTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataLossPreventionJobTriggerTimeouts | undefined;
    private _triggers?;
    get triggers(): DataLossPreventionJobTriggerTriggers[];
    set triggers(value: DataLossPreventionJobTriggerTriggers[]);
    get triggersInput(): DataLossPreventionJobTriggerTriggers[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
