import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLossPreventionInspectTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of the inspect template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#description DataLossPreventionInspectTemplate#description}
     */
    readonly description?: string;
    /**
     * User set display name of the inspect template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#display_name DataLossPreventionInspectTemplate#display_name}
     */
    readonly displayName?: string;
    /**
     * The parent of the inspect template in any of the following formats:.
     *
     * 'projects/{{project}}'
     * 'projects/{{project}}/locations/{{location}}'
     * 'organizations/{{organization_id}}'
     * 'organizations/{{organization_id}}/locations/{{location}}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#parent DataLossPreventionInspectTemplate#parent}
     */
    readonly parent: string;
    /**
     * inspect_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#inspect_config DataLossPreventionInspectTemplate#inspect_config}
     */
    readonly inspectConfig?: DataLossPreventionInspectTemplateInspectConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#timeouts DataLossPreventionInspectTemplate#timeouts}
     */
    readonly timeouts?: DataLossPreventionInspectTemplateTimeouts;
}
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePath {
    /**
     * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#path DataLossPreventionInspectTemplate#path}
     */
    readonly path: string;
}
export declare class DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePathOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordList {
    /**
     * Words or phrases defining the dictionary.
     *
     * The dictionary must contain at least one
     * phrase and every phrase must contain at least 2 characters that are letters or digits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#words DataLossPreventionInspectTemplate#words}
     */
    readonly words: string[];
}
export declare class DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordListOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _words?;
    get words(): string[];
    set words(value: string[]);
    get wordsInput(): string[] | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionary {
    /**
     * cloud_storage_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#cloud_storage_path DataLossPreventionInspectTemplate#cloud_storage_path}
     */
    readonly cloudStoragePath?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePath;
    /**
     * word_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#word_list DataLossPreventionInspectTemplate#word_list}
     */
    readonly wordList?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordList;
}
export declare class DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cloudStoragePath?;
    private __cloudStoragePathOutput;
    get cloudStoragePath(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePathOutputReference;
    putCloudStoragePath(value: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePath | undefined): void;
    resetCloudStoragePath(): void;
    get cloudStoragePathInput(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryCloudStoragePath | undefined;
    private _wordList?;
    private __wordListOutput;
    get wordList(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordListOutputReference;
    putWordList(value: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordList | undefined): void;
    resetWordList(): void;
    get wordListInput(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionaryWordList | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesInfoType {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names
     * listed at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#name DataLossPreventionInspectTemplate#name}
     */
    readonly name: string;
}
export declare class DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesInfoTypeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesRegex {
    /**
     * The index of the submatch to extract as findings.
     *
     * When not specified, the entire match is returned. No more than 3 may be included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#group_indexes DataLossPreventionInspectTemplate#group_indexes}
     */
    readonly groupIndexes?: number[];
    /**
     * Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#pattern DataLossPreventionInspectTemplate#pattern}
     */
    readonly pattern: string;
}
export declare class DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesRegexOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _groupIndexes?;
    get groupIndexes(): number[] | undefined;
    set groupIndexes(value: number[] | undefined);
    resetGroupIndexes(): void;
    get groupIndexesInput(): number[] | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    get patternInput(): string | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesStoredType {
    /**
     * Resource name of the requested StoredInfoType, for example 'organizations/433245324/storedInfoTypes/432452342' or 'projects/project-id/storedInfoTypes/432452342'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#name DataLossPreventionInspectTemplate#name}
     */
    readonly name: string;
}
export declare class DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesStoredTypeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigCustomInfoTypes {
    /**
     * If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding to be returned.
     *
     * It still can be used for rules matching. Possible values: ["EXCLUSION_TYPE_EXCLUDE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#exclusion_type DataLossPreventionInspectTemplate#exclusion_type}
     */
    readonly exclusionType?: string;
    /**
     * Likelihood to return for this CustomInfoType.
     *
     * This base value can be altered by a detection rule if the finding meets the criteria
     * specified by the rule. Default value: "VERY_LIKELY" Possible values: ["VERY_UNLIKELY", "UNLIKELY", "POSSIBLE", "LIKELY", "VERY_LIKELY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#likelihood DataLossPreventionInspectTemplate#likelihood}
     */
    readonly likelihood?: string;
    /**
     * dictionary block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#dictionary DataLossPreventionInspectTemplate#dictionary}
     */
    readonly dictionary?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesDictionary;
    /**
     * info_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#info_type DataLossPreventionInspectTemplate#info_type}
     */
    readonly infoType: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesInfoType;
    /**
     * regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#regex DataLossPreventionInspectTemplate#regex}
     */
    readonly regex?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesRegex;
    /**
     * stored_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#stored_type DataLossPreventionInspectTemplate#stored_type}
     */
    readonly storedType?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypesStoredType;
}
export interface DataLossPreventionInspectTemplateInspectConfigInfoTypes {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names listed
     * at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#name DataLossPreventionInspectTemplate#name}
     */
    readonly name: string;
}
export interface DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeInfoType {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names listed
     * at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#name DataLossPreventionInspectTemplate#name}
     */
    readonly name: string;
}
export declare class DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeInfoTypeOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoType {
    /**
     * Max findings limit for the given infoType.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#max_findings DataLossPreventionInspectTemplate#max_findings}
     */
    readonly maxFindings: number;
    /**
     * info_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#info_type DataLossPreventionInspectTemplate#info_type}
     */
    readonly infoType: DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoTypeInfoType;
}
export interface DataLossPreventionInspectTemplateInspectConfigLimits {
    /**
     * Max number of findings that will be returned for each item scanned. The maximum returned is 2000.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#max_findings_per_item DataLossPreventionInspectTemplate#max_findings_per_item}
     */
    readonly maxFindingsPerItem: number;
    /**
     * Max number of findings that will be returned per request/job. The maximum returned is 2000.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#max_findings_per_request DataLossPreventionInspectTemplate#max_findings_per_request}
     */
    readonly maxFindingsPerRequest: number;
    /**
     * max_findings_per_info_type block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#max_findings_per_info_type DataLossPreventionInspectTemplate#max_findings_per_info_type}
     */
    readonly maxFindingsPerInfoType?: DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoType[];
}
export declare class DataLossPreventionInspectTemplateInspectConfigLimitsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxFindingsPerItem?;
    get maxFindingsPerItem(): number;
    set maxFindingsPerItem(value: number);
    get maxFindingsPerItemInput(): number | undefined;
    private _maxFindingsPerRequest?;
    get maxFindingsPerRequest(): number;
    set maxFindingsPerRequest(value: number);
    get maxFindingsPerRequestInput(): number | undefined;
    private _maxFindingsPerInfoType?;
    get maxFindingsPerInfoType(): DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoType[] | undefined;
    set maxFindingsPerInfoType(value: DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoType[] | undefined);
    resetMaxFindingsPerInfoType(): void;
    get maxFindingsPerInfoTypeInput(): DataLossPreventionInspectTemplateInspectConfigLimitsMaxFindingsPerInfoType[] | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetInfoTypes {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names listed
     * at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#name DataLossPreventionInspectTemplate#name}
     */
    readonly name: string;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePath {
    /**
     * A url representing a file or path (no wildcards) in Cloud Storage. Example: 'gs://[BUCKET_NAME]/dictionary.txt'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#path DataLossPreventionInspectTemplate#path}
     */
    readonly path: string;
}
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePathOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordList {
    /**
     * Words or phrases defining the dictionary.
     *
     * The dictionary must contain at least one
     * phrase and every phrase must contain at least 2 characters that are letters or digits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#words DataLossPreventionInspectTemplate#words}
     */
    readonly words: string[];
}
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordListOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _words?;
    get words(): string[];
    set words(value: string[]);
    get wordsInput(): string[] | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionary {
    /**
     * cloud_storage_path block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#cloud_storage_path DataLossPreventionInspectTemplate#cloud_storage_path}
     */
    readonly cloudStoragePath?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePath;
    /**
     * word_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#word_list DataLossPreventionInspectTemplate#word_list}
     */
    readonly wordList?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordList;
}
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cloudStoragePath?;
    private __cloudStoragePathOutput;
    get cloudStoragePath(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePathOutputReference;
    putCloudStoragePath(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePath | undefined): void;
    resetCloudStoragePath(): void;
    get cloudStoragePathInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryCloudStoragePath | undefined;
    private _wordList?;
    private __wordListOutput;
    get wordList(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordListOutputReference;
    putWordList(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordList | undefined): void;
    resetWordList(): void;
    get wordListInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryWordList | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypes {
    /**
     * Name of the information type.
     *
     * Either a name of your choosing when creating a CustomInfoType, or one of the names listed
     * at https://cloud.google.com/dlp/docs/infotypes-reference when specifying a built-in type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#name DataLossPreventionInspectTemplate#name}
     */
    readonly name: string;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypes {
    /**
     * info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#info_types DataLossPreventionInspectTemplate#info_types}
     */
    readonly infoTypes: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypes[];
}
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _infoTypes?;
    get infoTypes(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypes[];
    set infoTypes(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypes[]);
    get infoTypesInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesInfoTypes[] | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegex {
    /**
     * The index of the submatch to extract as findings.
     *
     * When not specified, the entire match is returned. No more than 3 may be included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#group_indexes DataLossPreventionInspectTemplate#group_indexes}
     */
    readonly groupIndexes?: number[];
    /**
     * Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#pattern DataLossPreventionInspectTemplate#pattern}
     */
    readonly pattern: string;
}
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegexOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _groupIndexes?;
    get groupIndexes(): number[] | undefined;
    set groupIndexes(value: number[] | undefined);
    resetGroupIndexes(): void;
    get groupIndexesInput(): number[] | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    get patternInput(): string | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRule {
    /**
     * How the rule is applied. See the documentation for more information: https://cloud.google.com/dlp/docs/reference/rest/v2/InspectConfig#MatchingType Possible values: ["MATCHING_TYPE_FULL_MATCH", "MATCHING_TYPE_PARTIAL_MATCH", "MATCHING_TYPE_INVERSE_MATCH"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#matching_type DataLossPreventionInspectTemplate#matching_type}
     */
    readonly matchingType: string;
    /**
     * dictionary block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#dictionary DataLossPreventionInspectTemplate#dictionary}
     */
    readonly dictionary?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionary;
    /**
     * exclude_info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#exclude_info_types DataLossPreventionInspectTemplate#exclude_info_types}
     */
    readonly excludeInfoTypes?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypes;
    /**
     * regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#regex DataLossPreventionInspectTemplate#regex}
     */
    readonly regex?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegex;
}
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _matchingType?;
    get matchingType(): string;
    set matchingType(value: string);
    get matchingTypeInput(): string | undefined;
    private _dictionary?;
    private __dictionaryOutput;
    get dictionary(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionaryOutputReference;
    putDictionary(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionary | undefined): void;
    resetDictionary(): void;
    get dictionaryInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleDictionary | undefined;
    private _excludeInfoTypes?;
    private __excludeInfoTypesOutput;
    get excludeInfoTypes(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypesOutputReference;
    putExcludeInfoTypes(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypes | undefined): void;
    resetExcludeInfoTypes(): void;
    get excludeInfoTypesInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleExcludeInfoTypes | undefined;
    private _regex?;
    private __regexOutput;
    get regex(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegexOutputReference;
    putRegex(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegex | undefined): void;
    resetRegex(): void;
    get regexInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRuleRegex | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegex {
    /**
     * The index of the submatch to extract as findings.
     *
     * When not specified,
     * the entire match is returned. No more than 3 may be included.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#group_indexes DataLossPreventionInspectTemplate#group_indexes}
     */
    readonly groupIndexes?: number[];
    /**
     * Pattern defining the regular expression. Its syntax (https://github.com/google/re2/wiki/Syntax) can be found under the google/re2 repository on GitHub.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#pattern DataLossPreventionInspectTemplate#pattern}
     */
    readonly pattern: string;
}
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegexOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _groupIndexes?;
    get groupIndexes(): number[] | undefined;
    set groupIndexes(value: number[] | undefined);
    resetGroupIndexes(): void;
    get groupIndexesInput(): number[] | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    get patternInput(): string | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustment {
    /**
     * Set the likelihood of a finding to a fixed value.
     *
     * Either this or relative_likelihood can be set. Possible values: ["VERY_UNLIKELY", "UNLIKELY", "POSSIBLE", "LIKELY", "VERY_LIKELY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#fixed_likelihood DataLossPreventionInspectTemplate#fixed_likelihood}
     */
    readonly fixedLikelihood?: string;
    /**
     * Increase or decrease the likelihood by the specified number of levels.
     *
     * For example,
     * if a finding would be POSSIBLE without the detection rule and relativeLikelihood is 1,
     * then it is upgraded to LIKELY, while a value of -1 would downgrade it to UNLIKELY.
     * Likelihood may never drop below VERY_UNLIKELY or exceed VERY_LIKELY, so applying an
     * adjustment of 1 followed by an adjustment of -1 when base likelihood is VERY_LIKELY
     * will result in a final likelihood of LIKELY. Either this or fixed_likelihood can be set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#relative_likelihood DataLossPreventionInspectTemplate#relative_likelihood}
     */
    readonly relativeLikelihood?: number;
}
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustmentOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _fixedLikelihood?;
    get fixedLikelihood(): string | undefined;
    set fixedLikelihood(value: string | undefined);
    resetFixedLikelihood(): void;
    get fixedLikelihoodInput(): string | undefined;
    private _relativeLikelihood?;
    get relativeLikelihood(): number | undefined;
    set relativeLikelihood(value: number | undefined);
    resetRelativeLikelihood(): void;
    get relativeLikelihoodInput(): number | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximity {
    /**
     * Number of characters after the finding to consider. Either this or window_before must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#window_after DataLossPreventionInspectTemplate#window_after}
     */
    readonly windowAfter?: number;
    /**
     * Number of characters before the finding to consider. Either this or window_after must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#window_before DataLossPreventionInspectTemplate#window_before}
     */
    readonly windowBefore?: number;
}
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximityOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _windowAfter?;
    get windowAfter(): number | undefined;
    set windowAfter(value: number | undefined);
    resetWindowAfter(): void;
    get windowAfterInput(): number | undefined;
    private _windowBefore?;
    get windowBefore(): number | undefined;
    set windowBefore(value: number | undefined);
    resetWindowBefore(): void;
    get windowBeforeInput(): number | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRule {
    /**
     * hotword_regex block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#hotword_regex DataLossPreventionInspectTemplate#hotword_regex}
     */
    readonly hotwordRegex: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegex;
    /**
     * likelihood_adjustment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#likelihood_adjustment DataLossPreventionInspectTemplate#likelihood_adjustment}
     */
    readonly likelihoodAdjustment: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustment;
    /**
     * proximity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#proximity DataLossPreventionInspectTemplate#proximity}
     */
    readonly proximity: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximity;
}
export declare class DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hotwordRegex?;
    private __hotwordRegexOutput;
    get hotwordRegex(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegexOutputReference;
    putHotwordRegex(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegex): void;
    get hotwordRegexInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleHotwordRegex | undefined;
    private _likelihoodAdjustment?;
    private __likelihoodAdjustmentOutput;
    get likelihoodAdjustment(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustmentOutputReference;
    putLikelihoodAdjustment(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustment): void;
    get likelihoodAdjustmentInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleLikelihoodAdjustment | undefined;
    private _proximity?;
    private __proximityOutput;
    get proximity(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximityOutputReference;
    putProximity(value: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximity): void;
    get proximityInput(): DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRuleProximity | undefined;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSetRules {
    /**
     * exclusion_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#exclusion_rule DataLossPreventionInspectTemplate#exclusion_rule}
     */
    readonly exclusionRule?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesExclusionRule;
    /**
     * hotword_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#hotword_rule DataLossPreventionInspectTemplate#hotword_rule}
     */
    readonly hotwordRule?: DataLossPreventionInspectTemplateInspectConfigRuleSetRulesHotwordRule;
}
export interface DataLossPreventionInspectTemplateInspectConfigRuleSet {
    /**
     * info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#info_types DataLossPreventionInspectTemplate#info_types}
     */
    readonly infoTypes: DataLossPreventionInspectTemplateInspectConfigRuleSetInfoTypes[];
    /**
     * rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#rules DataLossPreventionInspectTemplate#rules}
     */
    readonly rules: DataLossPreventionInspectTemplateInspectConfigRuleSetRules[];
}
export interface DataLossPreventionInspectTemplateInspectConfig {
    /**
     * List of options defining data content to scan.
     *
     * If empty, text, images, and other content will be included. Possible values: ["CONTENT_TEXT", "CONTENT_IMAGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#content_options DataLossPreventionInspectTemplate#content_options}
     */
    readonly contentOptions?: string[];
    /**
     * When true, excludes type information of the findings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#exclude_info_types DataLossPreventionInspectTemplate#exclude_info_types}
     */
    readonly excludeInfoTypes?: boolean | cdktf.IResolvable;
    /**
     * When true, a contextual quote from the data that triggered a finding is included in the response.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#include_quote DataLossPreventionInspectTemplate#include_quote}
     */
    readonly includeQuote?: boolean | cdktf.IResolvable;
    /**
     * Only returns findings equal or above this threshold.
     *
     * See https://cloud.google.com/dlp/docs/likelihood for more info Default value: "POSSIBLE" Possible values: ["VERY_UNLIKELY", "UNLIKELY", "POSSIBLE", "LIKELY", "VERY_LIKELY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#min_likelihood DataLossPreventionInspectTemplate#min_likelihood}
     */
    readonly minLikelihood?: string;
    /**
     * custom_info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#custom_info_types DataLossPreventionInspectTemplate#custom_info_types}
     */
    readonly customInfoTypes?: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypes[];
    /**
     * info_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#info_types DataLossPreventionInspectTemplate#info_types}
     */
    readonly infoTypes?: DataLossPreventionInspectTemplateInspectConfigInfoTypes[];
    /**
     * limits block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#limits DataLossPreventionInspectTemplate#limits}
     */
    readonly limits?: DataLossPreventionInspectTemplateInspectConfigLimits;
    /**
     * rule_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#rule_set DataLossPreventionInspectTemplate#rule_set}
     */
    readonly ruleSet?: DataLossPreventionInspectTemplateInspectConfigRuleSet[];
}
export declare class DataLossPreventionInspectTemplateInspectConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _contentOptions?;
    get contentOptions(): string[] | undefined;
    set contentOptions(value: string[] | undefined);
    resetContentOptions(): void;
    get contentOptionsInput(): string[] | undefined;
    private _excludeInfoTypes?;
    get excludeInfoTypes(): boolean | cdktf.IResolvable | undefined;
    set excludeInfoTypes(value: boolean | cdktf.IResolvable | undefined);
    resetExcludeInfoTypes(): void;
    get excludeInfoTypesInput(): boolean | cdktf.IResolvable | undefined;
    private _includeQuote?;
    get includeQuote(): boolean | cdktf.IResolvable | undefined;
    set includeQuote(value: boolean | cdktf.IResolvable | undefined);
    resetIncludeQuote(): void;
    get includeQuoteInput(): boolean | cdktf.IResolvable | undefined;
    private _minLikelihood?;
    get minLikelihood(): string | undefined;
    set minLikelihood(value: string | undefined);
    resetMinLikelihood(): void;
    get minLikelihoodInput(): string | undefined;
    private _customInfoTypes?;
    get customInfoTypes(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypes[] | undefined;
    set customInfoTypes(value: DataLossPreventionInspectTemplateInspectConfigCustomInfoTypes[] | undefined);
    resetCustomInfoTypes(): void;
    get customInfoTypesInput(): DataLossPreventionInspectTemplateInspectConfigCustomInfoTypes[] | undefined;
    private _infoTypes?;
    get infoTypes(): DataLossPreventionInspectTemplateInspectConfigInfoTypes[] | undefined;
    set infoTypes(value: DataLossPreventionInspectTemplateInspectConfigInfoTypes[] | undefined);
    resetInfoTypes(): void;
    get infoTypesInput(): DataLossPreventionInspectTemplateInspectConfigInfoTypes[] | undefined;
    private _limits?;
    private __limitsOutput;
    get limits(): DataLossPreventionInspectTemplateInspectConfigLimitsOutputReference;
    putLimits(value: DataLossPreventionInspectTemplateInspectConfigLimits | undefined): void;
    resetLimits(): void;
    get limitsInput(): DataLossPreventionInspectTemplateInspectConfigLimits | undefined;
    private _ruleSet?;
    get ruleSet(): DataLossPreventionInspectTemplateInspectConfigRuleSet[] | undefined;
    set ruleSet(value: DataLossPreventionInspectTemplateInspectConfigRuleSet[] | undefined);
    resetRuleSet(): void;
    get ruleSetInput(): DataLossPreventionInspectTemplateInspectConfigRuleSet[] | undefined;
}
export interface DataLossPreventionInspectTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#create DataLossPreventionInspectTemplate#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#delete DataLossPreventionInspectTemplate#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html#update DataLossPreventionInspectTemplate#update}.
     */
    readonly update?: string;
}
export declare class DataLossPreventionInspectTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html google_data_loss_prevention_inspect_template}.
 */
export declare class DataLossPreventionInspectTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_inspect_template.html google_data_loss_prevention_inspect_template} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataLossPreventionInspectTemplateConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _inspectConfig?;
    private __inspectConfigOutput;
    get inspectConfig(): DataLossPreventionInspectTemplateInspectConfigOutputReference;
    putInspectConfig(value: DataLossPreventionInspectTemplateInspectConfig | undefined): void;
    resetInspectConfig(): void;
    get inspectConfigInput(): DataLossPreventionInspectTemplateInspectConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): DataLossPreventionInspectTemplateTimeoutsOutputReference;
    putTimeouts(value: DataLossPreventionInspectTemplateTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataLossPreventionInspectTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
