import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleTpuTensorflowVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/tpu_tensorflow_versions.html#project DataGoogleTpuTensorflowVersions#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/tpu_tensorflow_versions.html#zone DataGoogleTpuTensorflowVersions#zone}.
     */
    readonly zone?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/tpu_tensorflow_versions.html google_tpu_tensorflow_versions}.
 */
export declare class DataGoogleTpuTensorflowVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/tpu_tensorflow_versions.html google_tpu_tensorflow_versions} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleTpuTensorflowVersionsConfig);
    get id(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get versions(): string[];
    private _zone?;
    get zone(): string | undefined;
    set zone(value: string | undefined);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
