import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleStorageProjectServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_project_service_account.html#project DataGoogleStorageProjectServiceAccount#project}.
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_project_service_account.html#user_project DataGoogleStorageProjectServiceAccount#user_project}.
     */
    readonly userProject?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/storage_project_service_account.html google_storage_project_service_account}.
 */
export declare class DataGoogleStorageProjectServiceAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/storage_project_service_account.html google_storage_project_service_account} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleStorageProjectServiceAccountConfig);
    get emailAddress(): string;
    get id(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _userProject?;
    get userProject(): string | undefined;
    set userProject(value: string | undefined);
    resetUserProject(): void;
    get userProjectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
