import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleStorageObjectSignedUrlConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#bucket DataGoogleStorageObjectSignedUrl#bucket}.
     */
    readonly bucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#content_md5 DataGoogleStorageObjectSignedUrl#content_md5}.
     */
    readonly contentMd5?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#content_type DataGoogleStorageObjectSignedUrl#content_type}.
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#credentials DataGoogleStorageObjectSignedUrl#credentials}.
     */
    readonly credentials?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#duration DataGoogleStorageObjectSignedUrl#duration}.
     */
    readonly duration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#extension_headers DataGoogleStorageObjectSignedUrl#extension_headers}.
     */
    readonly extensionHeaders?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#http_method DataGoogleStorageObjectSignedUrl#http_method}.
     */
    readonly httpMethod?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html#path DataGoogleStorageObjectSignedUrl#path}.
     */
    readonly path: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html google_storage_object_signed_url}.
 */
export declare class DataGoogleStorageObjectSignedUrl extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/storage_object_signed_url.html google_storage_object_signed_url} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleStorageObjectSignedUrlConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _contentMd5?;
    get contentMd5(): string | undefined;
    set contentMd5(value: string | undefined);
    resetContentMd5(): void;
    get contentMd5Input(): string | undefined;
    private _contentType?;
    get contentType(): string | undefined;
    set contentType(value: string | undefined);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _credentials?;
    get credentials(): string | undefined;
    set credentials(value: string | undefined);
    resetCredentials(): void;
    get credentialsInput(): string | undefined;
    private _duration?;
    get duration(): string | undefined;
    set duration(value: string | undefined);
    resetDuration(): void;
    get durationInput(): string | undefined;
    private _extensionHeaders?;
    get extensionHeaders(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set extensionHeaders(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetExtensionHeaders(): void;
    get extensionHeadersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _httpMethod?;
    get httpMethod(): string | undefined;
    set httpMethod(value: string | undefined);
    resetHttpMethod(): void;
    get httpMethodInput(): string | undefined;
    get id(): string;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    get signedUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
