import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleStorageBucketConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_bucket.html#name DataGoogleStorageBucket#name}
     */
    readonly name: string;
}
export declare class DataGoogleStorageBucketCors extends cdktf.ComplexComputedList {
    get maxAgeSeconds(): number;
    get method(): string[];
    get origin(): string[];
    get responseHeader(): string[];
}
export declare class DataGoogleStorageBucketEncryption extends cdktf.ComplexComputedList {
    get defaultKmsKeyName(): string;
}
export declare class DataGoogleStorageBucketLifecycleRuleAction extends cdktf.ComplexComputedList {
    get storageClass(): string;
    get type(): string;
}
export declare class DataGoogleStorageBucketLifecycleRuleCondition extends cdktf.ComplexComputedList {
    get age(): number;
    get createdBefore(): string;
    get customTimeBefore(): string;
    get daysSinceCustomTime(): number;
    get daysSinceNoncurrentTime(): number;
    get matchesStorageClass(): string[];
    get noncurrentTimeBefore(): string;
    get numNewerVersions(): number;
    get withState(): string;
}
export declare class DataGoogleStorageBucketLifecycleRule extends cdktf.ComplexComputedList {
    get action(): any;
    get condition(): any;
}
export declare class DataGoogleStorageBucketLogging extends cdktf.ComplexComputedList {
    get logBucket(): string;
    get logObjectPrefix(): string;
}
export declare class DataGoogleStorageBucketRetentionPolicy extends cdktf.ComplexComputedList {
    get isLocked(): any;
    get retentionPeriod(): number;
}
export declare class DataGoogleStorageBucketVersioning extends cdktf.ComplexComputedList {
    get enabled(): any;
}
export declare class DataGoogleStorageBucketWebsite extends cdktf.ComplexComputedList {
    get mainPageSuffix(): string;
    get notFoundPage(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/storage_bucket.html google_storage_bucket}.
 */
export declare class DataGoogleStorageBucket extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/storage_bucket.html google_storage_bucket} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: DataGoogleStorageBucketConfig);
    get bucketPolicyOnly(): any;
    cors(index: string): DataGoogleStorageBucketCors;
    get defaultEventBasedHold(): any;
    encryption(index: string): DataGoogleStorageBucketEncryption;
    get forceDestroy(): any;
    get id(): string;
    labels(key: string): string;
    lifecycleRule(index: string): DataGoogleStorageBucketLifecycleRule;
    get location(): string;
    logging(index: string): DataGoogleStorageBucketLogging;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get project(): string;
    get requesterPays(): any;
    retentionPolicy(index: string): DataGoogleStorageBucketRetentionPolicy;
    get selfLink(): string;
    get storageClass(): string;
    get uniformBucketLevelAccess(): any;
    get url(): string;
    versioning(index: string): DataGoogleStorageBucketVersioning;
    website(index: string): DataGoogleStorageBucketWebsite;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
