import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleStorageBucketObjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the containing bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object.html#bucket DataGoogleStorageBucketObject#bucket}
     */
    readonly bucket?: string;
    /**
     * The name of the object. If you're interpolating the name of this object, see output_name instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object.html#name DataGoogleStorageBucketObject#name}
     */
    readonly name?: string;
}
export declare class DataGoogleStorageBucketObjectCustomerEncryption extends cdktf.ComplexComputedList {
    get encryptionAlgorithm(): string;
    get encryptionKey(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object.html google_storage_bucket_object}.
 */
export declare class DataGoogleStorageBucketObject extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object.html google_storage_bucket_object} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: DataGoogleStorageBucketObjectConfig);
    private _bucket?;
    get bucket(): string | undefined;
    set bucket(value: string | undefined);
    resetBucket(): void;
    get bucketInput(): string | undefined;
    get cacheControl(): string;
    get content(): string;
    get contentDisposition(): string;
    get contentEncoding(): string;
    get contentLanguage(): string;
    get contentType(): string;
    get crc32C(): string;
    customerEncryption(index: string): DataGoogleStorageBucketObjectCustomerEncryption;
    get detectMd5Hash(): string;
    get eventBasedHold(): any;
    get id(): string;
    get kmsKeyName(): string;
    get md5Hash(): string;
    get mediaLink(): string;
    metadata(key: string): string;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    get outputName(): string;
    get selfLink(): string;
    get source(): string;
    get storageClass(): string;
    get temporaryHold(): any;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
